/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.coreprotect.Functions;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Database;
import net.coreprotect.database.Lookup;
import net.coreprotect.model.Config;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.inventory.ItemStack;

public class BlockListener
extends Queue
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockIgnite(BlockIgniteEvent event) {
        World world = event.getBlock().getWorld();
        if (!event.isCancelled() && Functions.checkConfig(world, "block-ignite") == 1) {
            Block block = event.getBlock();
            if (block == null) {
                return;
            }
            if (event.getPlayer() == null) {
                Queue.queueBlockPlace("#fire", block.getState(), block.getState(), Material.FIRE.getId());
            } else {
                Player player = event.getPlayer();
                Queue.queueBlockPlace(player.getName(), block.getState(), null, Material.FIRE.getId());
                int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
                int world_id = Functions.getWorldId(block.getWorld().getName());
                Config.lookup_cache.put(block.getX() + "." + block.getY() + "." + block.getZ() + "." + world_id, new Object[]{unixtimestamp, player.getName(), block.getTypeId()});
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockBurn(BlockBurnEvent event) {
        World world = event.getBlock().getWorld();
        if (!event.isCancelled() && Functions.checkConfig(world, "block-burn") == 1) {
            String player = "#fire";
            Block block = event.getBlock();
            int type = event.getBlock().getTypeId();
            byte data = event.getBlock().getData();
            Queue.queueBlockBreak(player, block.getState(), type, data);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockPistonExtend(BlockPistonExtendEvent event) {
        World world = event.getBlock().getWorld();
        if (Functions.checkConfig(world, "pistons") == 1 && !event.isCancelled()) {
            ArrayList<Block> nblocks = new ArrayList<Block>();
            ArrayList<BlockState> blocks = new ArrayList<BlockState>();
            List event_blocks = event.getBlocks();
            for (Block block : event_blocks) {
                Block block_relative = block.getRelative(event.getDirection());
                if (Functions.checkConfig(world, "block-movement") == 1) {
                    block_relative = Functions.fallingSand(block_relative, block.getState(), "#piston");
                }
                nblocks.add(block_relative);
                blocks.add(block.getState());
            }
            Block b = event.getBlock();
            BlockFace d = event.getDirection();
            Block bm = b.getRelative(d);
            int wid = Functions.getWorldId(bm.getWorld().getName());
            int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
            boolean log = false;
            int l = 0;
            while (l <= nblocks.size()) {
                int ll = l - 1;
                Block n = null;
                n = ll == -1 ? bm : (Block)nblocks.get(ll);
                if (n != null) {
                    int x = n.getX();
                    int y = n.getY();
                    int z = n.getZ();
                    int t = n.getTypeId();
                    String cords = x + "." + y + "." + z + "." + wid + "." + t;
                    if (Config.piston_cache.get(cords) == null) {
                        log = true;
                    }
                    Config.piston_cache.put(cords, new Object[]{unixtimestamp});
                }
                ++l;
            }
            if (log) {
                String e = "#piston";
                for (BlockState block : blocks) {
                    Queue.queueBlockBreak(e, block, block.getTypeId(), block.getData().getData());
                }
                int c = 0;
                for (Block nblock : nblocks) {
                    BlockState block = (BlockState)blocks.get(c);
                    Queue.queueBlockPlace(e, nblock.getState(), block.getTypeId(), (int)block.getData().getData());
                    ++c;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockSpread(BlockSpreadEvent event) {
        if (!event.isCancelled() && Functions.checkConfig(event.getBlock().getWorld(), "vine-growth") == 1) {
            Block block = event.getBlock();
            BlockState blockstate = event.getNewState();
            if (blockstate.getTypeId() == 106) {
                Queue.queueBlockPlace("#vine", block.getState(), blockstate.getTypeId(), (int)blockstate.getData().getData());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockFromTo(BlockFromToEvent event) {
        List<Integer> fb;
        World world;
        int type = event.getBlock().getTypeId();
        int type2 = event.getToBlock().getTypeId();
        if (!(event.isCancelled() || (Functions.checkConfig(world = event.getBlock().getWorld(), "water-flow") != 1 || type != 8 && type != 9) && (Functions.checkConfig(world, "lava-flow") != 1 || type != 10 && type != 11) || !(fb = Arrays.asList(0, 6, 27, 28, 30, 31, 32, 37, 38, 39, 40, 50, 51, 55, 59, 66, 69, 75, 76, 77, 78, 93, 94, 106, 127, 131, 132, 141, 142, 143, 144, 149, 150, 157)).contains(type2) && (type != 8 && type != 9 || type2 != 10 && type2 != 11) && (type != 10 && type != 11 || type2 != 8 && type2 != 9))) {
            String p;
            String f = "#flow";
            if (type == 8 || type == 9) {
                f = "#water";
            } else if (type == 10 || type == 11) {
                f = "#lava";
            }
            Block block = event.getBlock();
            int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
            int x = event.getToBlock().getX();
            int y = event.getToBlock().getY();
            int z = event.getToBlock().getZ();
            int wid = Functions.getWorldId(block.getWorld().getName());
            if (Functions.checkConfig(world, "liquid-tracking") == 1 && (p = Lookup.who_placed_cache(block)).length() > 0) {
                f = p;
            }
            Config.lookup_cache.put(x + "." + y + "." + z + "." + wid, new Object[]{unixtimestamp, f, type});
            Queue.queueBlockPlace(f, event.getToBlock(), event.getToBlock().getState(), type, event.getBlock().getData());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockPlace(BlockPlaceEvent event) {
        World world = event.getBlockPlaced().getWorld();
        if (!event.isCancelled() && Functions.checkConfig(world, "block-place") == 1) {
            ItemStack item;
            Block b;
            Player player = event.getPlayer();
            Block block = b = event.getBlockPlaced();
            BlockState breplaced = event.getBlockReplacedState();
            int force_type = -1;
            int force_data = -1;
            boolean abort = false;
            int block_type = b.getTypeId();
            if (Config.containers.contains(block_type) || block_type == 29 || block_type == 33 || block_type == 144 || block_type == 93 || block_type == 149) {
                Queue.queueBlockPlaceDelayed(player.getName(), block, breplaced, 0);
                abort = true;
            } else if (block_type == 51 && (item = event.getItemInHand()).getTypeId() != 51) {
                abort = true;
            }
            if (!abort) {
                if (Functions.checkConfig(world, "block-movement") == 1 && !(block = Functions.fallingSand(block, null, player.getName())).equals(b)) {
                    force_type = b.getTypeId();
                }
                Queue.queueBlockPlace(player, block.getState(), b, breplaced, force_type, force_data);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockBreak(BlockBreakEvent event) {
        if (!event.isCancelled()) {
            String player = event.getPlayer().getName();
            Block bl = event.getBlock();
            int x = bl.getX();
            int y = bl.getY();
            int z = bl.getZ();
            World world = bl.getWorld();
            Location l1 = new Location(world, (double)(x + 1), (double)y, (double)z);
            Location l2 = new Location(world, (double)(x - 1), (double)y, (double)z);
            Location l3 = new Location(world, (double)x, (double)y, (double)(z + 1));
            Location l4 = new Location(world, (double)x, (double)y, (double)(z - 1));
            Location l5 = new Location(world, (double)x, (double)(y + 1), (double)z);
            Location l6 = new Location(world, (double)x, (double)(y - 1), (double)z);
            byte l = 1;
            byte m = 7;
            if (Functions.checkConfig(world, "natural-break") == 0) {
                l = 6;
            }
            if (Functions.checkConfig(world, "block-break") == 0) {
                m = 6;
            }
            Block block = bl;
            int type = bl.getTypeId();
            byte data = bl.getData();
            while (l < m) {
                Location lc = l1;
                if (l == 2) {
                    lc = l2;
                }
                if (l == 3) {
                    lc = l3;
                }
                if (l == 4) {
                    lc = l4;
                }
                if (l == 5) {
                    lc = l5;
                }
                Block b = block;
                boolean check_down = false;
                int bt = type;
                byte bd = data;
                boolean log = true;
                if (l < 6) {
                    byte check_data;
                    if (l == 4 && (type == 64 || type == 71)) {
                        lc = l6;
                        check_down = true;
                    }
                    int t = world.getBlockTypeIdAt(lc);
                    if (l == 5 && Config.falling_block_types.contains(t) && Functions.checkConfig(world, "block-movement") == 1) {
                        int yc = y + 2;
                        boolean topfound = false;
                        while (!topfound) {
                            int up = world.getBlockTypeIdAt(x, yc, z);
                            if (!Config.falling_block_types.contains(up)) {
                                lc = new Location(world, (double)x, (double)(yc - 1), (double)z);
                                topfound = true;
                            }
                            ++yc;
                        }
                    }
                    if (!Config.track_any.contains(t)) {
                        if (l != 5 && !check_down) {
                            if (!Config.track_side.contains(t)) {
                                log = false;
                            } else if (type == 77 || type == 143) {
                                Block check = world.getBlockAt(lc);
                                check_data = check.getData();
                                if (check_data != l) {
                                    log = false;
                                }
                            } else if (t == 26 && type != 26) {
                                log = false;
                            }
                        } else if (!Config.track_top.contains(t)) {
                            log = false;
                        }
                        if (!log) {
                            if (type == 34) {
                                if (t == 29 || t == 33) {
                                    log = true;
                                }
                            } else if (l == 5 && Config.falling_block_types.contains(t)) {
                                log = true;
                            }
                        }
                    } else if (t == 34) {
                        if (type != 29 && type != 33) {
                            log = false;
                        }
                    } else {
                        Block check = world.getBlockAt(lc);
                        check_data = check.getData();
                        if (check_data != l) {
                            log = false;
                        }
                    }
                    if (log) {
                        b = world.getBlockAt(lc);
                        bt = b.getTypeId();
                        bd = b.getData();
                    }
                }
                BlockState b1 = b.getState();
                int bt1 = bt;
                byte bd1 = bd;
                byte bn = l;
                if (bt == 144 && log) {
                    try {
                        if (b1 instanceof Skull) {
                            Queue.queueSkullBreak(player, b1, bt1, bd1, type, bn);
                        }
                        log = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (log && (bt == 63 || bt == 68) && Functions.checkConfig(world, "sign-text") == 1) {
                    try {
                        Sign sign = (Sign)b.getState();
                        String line1 = sign.getLine(0);
                        String line2 = sign.getLine(1);
                        String line3 = sign.getLine(2);
                        String line4 = sign.getLine(3);
                        Queue.queueSignText(player, b1, line1, line2, line3, line4, 5);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (log) {
                    Database.containerBreakCheck(block, player);
                    Functions.iceBreakCheck(b1, player, bt1);
                    Queue.queueBlockBreak(player, b1, bt1, bd1, type, bn);
                }
                ++l;
            }
        }
    }
}

