/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.List;
import net.coreprotect.Functions;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Database;
import net.coreprotect.model.Config;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderDragonPart;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ItemDespawnEvent;

public class EntityListener
extends Queue
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    protected void onItemDespawn(ItemDespawnEvent event) {
        Item item = event.getEntity();
        int id = item.getEntityId();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onEntityCombust(EntityCombustEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Item) {
            int n = entity.getEntityId();
        }
    }

    protected void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Item) {
            int n = entity.getEntityId();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onEntityChangeBlock(EntityChangeBlockEvent event) {
        World world = event.getBlock().getWorld();
        if (!event.isCancelled() && Functions.checkConfig(world, "entity-change") == 1) {
            Entity entity = event.getEntity();
            Block block = event.getBlock();
            int newtype = event.getTo().getId();
            int type = event.getBlock().getTypeId();
            byte data = event.getBlock().getData();
            String e = "";
            if (entity instanceof Enderman) {
                e = "#enderman";
            } else if (entity instanceof EnderDragon) {
                e = "#enderdragon";
            } else if (entity instanceof Wither) {
                e = "#wither";
            } else if (entity instanceof Silverfish && newtype == 0) {
                e = "#silverfish";
            }
            if (e.length() > 0) {
                if (newtype == 0) {
                    Queue.queueBlockBreak(e, block.getState(), type, data);
                } else {
                    Queue.queueBlockPlace(e, block);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onEntityExplode(EntityExplodeEvent event) {
        Entity entity = event.getEntity();
        World world = event.getLocation().getWorld();
        String user = "#explosion";
        if (entity instanceof TNTPrimed) {
            user = "#tnt";
        } else if (entity instanceof Minecart) {
            String name = entity.getType().getName();
            if (name.contains("TNT")) {
                user = "#tnt";
            }
        } else if (entity instanceof Creeper) {
            user = "#creeper";
        } else if (entity instanceof EnderDragon || entity instanceof EnderDragonPart) {
            user = "#enderdragon";
        } else if (entity instanceof Wither || entity instanceof WitherSkull) {
            user = "#wither";
        }
        boolean log = false;
        if (Functions.checkConfig(world, "explosions") == 1) {
            log = true;
        }
        if ((user.equals("#enderdragon") || user.equals("#wither")) && Functions.checkConfig(world, "entity-change") == 0) {
            log = false;
        }
        if (!event.isCancelled() && log) {
            List b = event.blockList();
            ArrayList<Block> nb = new ArrayList<Block>();
            if (Functions.checkConfig(world, "natural-break") == 1) {
                for (Block block : b) {
                    int x = block.getX();
                    int y = block.getY();
                    int z = block.getZ();
                    Location l1 = new Location(world, (double)(x + 1), (double)y, (double)z);
                    Location l2 = new Location(world, (double)(x - 1), (double)y, (double)z);
                    Location l3 = new Location(world, (double)x, (double)y, (double)(z + 1));
                    Location l4 = new Location(world, (double)x, (double)y, (double)(z - 1));
                    Location l5 = new Location(world, (double)x, (double)(y + 1), (double)z);
                    int l = 1;
                    int m = 6;
                    while (l < m) {
                        int t;
                        Location lc = l1;
                        if (l == 2) {
                            lc = l2;
                        }
                        if (l == 3) {
                            lc = l3;
                        }
                        if (l == 4) {
                            lc = l4;
                        }
                        if (l == 5) {
                            lc = l5;
                        }
                        if (Config.track_any.contains(t = world.getBlockTypeIdAt(lc)) || Config.track_top.contains(t) || Config.track_side.contains(t)) {
                            Block bl = world.getBlockAt(lc);
                            nb.add(bl);
                        }
                        ++l;
                    }
                }
            }
            for (Block block : b) {
                if (nb.contains(block)) continue;
                nb.add(block);
            }
            for (Block block : nb) {
                Database.containerBreakCheck(block, user);
                Queue.queueBlockBreak(user, block.getState(), block.getTypeId(), block.getData());
            }
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        EntityDamageEvent damage;
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (Functions.checkConfig(entity.getWorld(), "entity-kills") == 1 && (damage = entity.getLastDamageCause()) != null) {
            String e = "";
            boolean skip = true;
            if (Functions.checkConfig(entity.getWorld(), "skip-generic-data") == 0 || !(entity instanceof Zombie) && !(entity instanceof Skeleton)) {
                skip = false;
            }
            if (damage instanceof EntityDamageByEntityEvent) {
                Player player;
                LivingEntity shooter;
                EntityDamageByEntityEvent attack = (EntityDamageByEntityEvent)damage;
                Entity attacker = attack.getDamager();
                if (attacker instanceof Player) {
                    Player player2 = (Player)attacker;
                    e = player2.getName();
                } else if (attacker instanceof Arrow) {
                    Arrow arrow = (Arrow)attacker;
                    shooter = arrow.getShooter();
                    if (shooter instanceof Player) {
                        player = (Player)shooter;
                        e = player.getName();
                    } else if (shooter != null) {
                        e = "#" + shooter.getType().getName().toLowerCase();
                    }
                } else if (attacker instanceof ThrownPotion) {
                    ThrownPotion potion = (ThrownPotion)attacker;
                    shooter = potion.getShooter();
                    if (shooter instanceof Player) {
                        player = (Player)shooter;
                        e = player.getName();
                    } else if (shooter != null) {
                        e = "#" + shooter.getType().getName().toLowerCase();
                    }
                } else if (attacker.getType().getName() != null) {
                    e = "#" + attacker.getType().getName().toLowerCase();
                }
            } else {
                EntityDamageEvent.DamageCause cause = damage.getCause();
                if (cause.equals((Object)EntityDamageEvent.DamageCause.FIRE)) {
                    e = "#fire";
                } else if (cause.equals((Object)EntityDamageEvent.DamageCause.FIRE_TICK)) {
                    if (!skip) {
                        e = "#fire";
                    }
                } else if (cause.equals((Object)EntityDamageEvent.DamageCause.LAVA)) {
                    e = "#lava";
                } else if (cause.equals((Object)EntityDamageEvent.DamageCause.BLOCK_EXPLOSION)) {
                    e = "#explosion";
                }
            }
            EntityType entity_type = entity.getType();
            if (e.length() == 0 && !skip && !(entity instanceof Player) && entity_type.getName() != null) {
                e = "#" + entity_type.getName().toLowerCase();
            }
            if (e.startsWith("#wither")) {
                e = "#wither";
            }
            if (e.startsWith("#enderdragon")) {
                e = "#enderdragon";
            }
            if (e.startsWith("#primedtnt") || e.startsWith("#tnt")) {
                e = "#tnt";
            }
            if (e.startsWith("#lightning")) {
                e = "#lightning";
            }
            if (e.length() > 0) {
                ArrayList<Object> data = new ArrayList<Object>();
                ArrayList<Constable> age = new ArrayList<Constable>();
                ArrayList<Object> tame = new ArrayList<Object>();
                ArrayList<Object> info = new ArrayList<Object>();
                short type = entity_type.getTypeId();
                if (entity instanceof Ageable) {
                    Ageable ageable = (Ageable)entity;
                    age.add(Integer.valueOf(ageable.getAge()));
                    age.add(Boolean.valueOf(ageable.getAgeLock()));
                    age.add(Boolean.valueOf(ageable.isAdult()));
                    age.add(Boolean.valueOf(ageable.canBreed()));
                }
                if (entity instanceof Tameable) {
                    Tameable tameable = (Tameable)entity;
                    tame.add(tameable.isTamed());
                    if (tameable.isTamed() && tameable.getOwner() != null) {
                        tame.add(tameable.getOwner().getName());
                    }
                }
                if (entity instanceof Creeper) {
                    Creeper creeper = (Creeper)entity;
                    info.add(creeper.isPowered());
                } else if (entity instanceof Enderman) {
                    Enderman enderman = (Enderman)entity;
                    info.add(enderman.getCarriedMaterial().toItemStack().serialize());
                } else if (entity instanceof IronGolem) {
                    IronGolem irongolem = (IronGolem)entity;
                    info.add(irongolem.isPlayerCreated());
                } else if (entity instanceof Ocelot) {
                    Ocelot ocelot = (Ocelot)entity;
                    info.add(ocelot.getCatType());
                    info.add(ocelot.isSitting());
                } else if (entity instanceof Pig) {
                    Pig pig = (Pig)entity;
                    info.add(pig.hasSaddle());
                } else if (entity instanceof Sheep) {
                    Sheep sheep = (Sheep)entity;
                    info.add(sheep.isSheared());
                    info.add(sheep.getColor());
                } else if (entity instanceof Skeleton) {
                    Skeleton skeleton = (Skeleton)entity;
                    info.add(skeleton.getSkeletonType());
                } else if (entity instanceof Slime) {
                    Slime slime = (Slime)entity;
                    info.add(slime.getSize());
                } else if (entity instanceof Villager) {
                    Villager villager = (Villager)entity;
                    info.add(villager.getProfession());
                } else if (entity instanceof Wolf) {
                    Wolf wolf = (Wolf)entity;
                    info.add(wolf.isSitting());
                    info.add(wolf.getCollarColor());
                } else if (entity instanceof Zombie) {
                    Zombie zombie = (Zombie)entity;
                    info.add(zombie.isBaby());
                    info.add(zombie.isVillager());
                }
                data.add(age);
                data.add(tame);
                data.add(info);
                if (!(entity instanceof Player)) {
                    Queue.queueEntityKill(e, entity.getLocation(), data, type);
                }
            }
        }
    }
}

