/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener;

import java.sql.Connection;
import java.sql.Statement;
import net.coreprotect.Functions;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Database;
import net.coreprotect.database.Lookup;
import net.coreprotect.model.Config;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;

public class HangingListener
extends Queue
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    protected void onHangingPlace(HangingPlaceEvent event) {
        Hanging entity = event.getEntity();
        Player player = event.getPlayer();
        if (entity instanceof ItemFrame || entity instanceof Painting) {
            Block block_event = event.getEntity().getLocation().getBlock();
            int t = 0;
            int d = 0;
            if (entity instanceof ItemFrame) {
                t = 389;
                d = 0;
            } else if (entity instanceof Painting) {
                t = 321;
                Painting painting = (Painting)entity;
                d = painting.getArt().getId();
            }
            boolean inspect = false;
            if (Config.inspecting.get(player) != null && Config.inspecting.get(player).booleanValue()) {
                inspect = true;
                event.setCancelled(true);
            }
            if (!event.isCancelled() && Functions.checkConfig(block_event.getWorld(), "block-place") == 1 && !inspect) {
                Queue.queueBlockPlace(player.getName(), block_event.getState(), t, d);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onHangingBreak(HangingBreakEvent event) {
        HangingBreakEvent.RemoveCause cause = event.getCause();
        Hanging entity = event.getEntity();
        Block block_event = event.getEntity().getLocation().getBlock();
        if ((entity instanceof ItemFrame || entity instanceof Painting) && (cause.equals((Object)HangingBreakEvent.RemoveCause.EXPLOSION) || cause.equals((Object)HangingBreakEvent.RemoveCause.PHYSICS) || cause.equals((Object)HangingBreakEvent.RemoveCause.OBSTRUCTION))) {
            String p = "#explosion";
            Block ab = null;
            if (cause.equals((Object)HangingBreakEvent.RemoveCause.PHYSICS)) {
                p = "#physics";
            } else if (cause.equals((Object)HangingBreakEvent.RemoveCause.OBSTRUCTION)) {
                p = "#obstruction";
            }
            if (!cause.equals((Object)HangingBreakEvent.RemoveCause.EXPLOSION)) {
                Hanging he = entity;
                BlockFace attached = he.getAttachedFace();
                ab = he.getLocation().getBlock().getRelative(attached);
            }
            int t = 0;
            int d = 0;
            if (entity instanceof ItemFrame) {
                t = 389;
                ItemFrame itemframe = (ItemFrame)entity;
                if (itemframe.getItem() != null) {
                    d = itemframe.getItem().getTypeId();
                }
            } else if (entity instanceof Painting) {
                t = 321;
                Painting painting = (Painting)entity;
                d = painting.getArt().getId();
            }
            if (!event.isCancelled() && Functions.checkConfig(block_event.getWorld(), "natural-break") == 1) {
                Queue.queueNaturalBlockBreak(p, block_event.getState(), ab, t, d);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    protected void onHangingBreakByEntity(HangingBreakByEntityEvent event) {
        Player player;
        Hanging entity = event.getEntity();
        Entity remover = event.getRemover();
        Block block_event = event.getEntity().getLocation().getBlock();
        boolean inspect = false;
        if (event.getRemover() instanceof Player && Config.inspecting.get((player = (Player)event.getRemover()).getName()) != null && Config.inspecting.get(player.getName()).booleanValue()) {
            Block cblock = block_event;
            Player player2 = player;
            class BasicThread
            implements Runnable {
                private final /* synthetic */ Block val$cblock;
                private final /* synthetic */ Player val$player2;

                BasicThread(Block block, Player player) {
                    this.val$cblock = block;
                    this.val$player2 = player;
                }

                @Override
                public void run() {
                    try {
                        Connection connection = Database.getConnection(false);
                        if (connection != null) {
                            Statement statement = connection.createStatement();
                            String blockdata = Lookup.block_lookup(statement, this.val$cblock, this.val$player2.getName(), 0, 1, 7);
                            if (blockdata.contains("\n")) {
                                String[] stringArray = blockdata.split("\n");
                                int n = stringArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String b = stringArray[n2];
                                    this.val$player2.sendMessage(b);
                                    ++n2;
                                }
                            } else if (blockdata.length() > 0) {
                                this.val$player2.sendMessage(blockdata);
                            }
                            statement.close();
                            connection.close();
                        } else {
                            this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            BasicThread runnable = new BasicThread(cblock, player2);
            Thread thread = new Thread(runnable);
            thread.start();
            event.setCancelled(true);
            inspect = true;
        }
        if (entity instanceof ItemFrame || entity instanceof Painting) {
            String p = "#entity";
            if (remover != null) {
                if (remover instanceof Player) {
                    Player player2 = (Player)remover;
                    p = player2.getName();
                } else if (remover.getType() != null) {
                    p = "#" + remover.getType().getName();
                }
            }
            int t = 0;
            int d = 0;
            if (entity instanceof ItemFrame) {
                t = 389;
                ItemFrame itemframe = (ItemFrame)entity;
                if (itemframe.getItem() != null) {
                    d = itemframe.getItem().getTypeId();
                }
            } else if (entity instanceof Painting) {
                t = 321;
                Painting painting = (Painting)entity;
                d = painting.getArt().getId();
            }
            if (!event.isCancelled() && Functions.checkConfig(block_event.getWorld(), "block-break") == 1 && !inspect) {
                Queue.queueBlockBreak(p, block_event.getState(), t, d);
            }
        }
    }
}

