/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener;

import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.coreprotect.Functions;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Database;
import net.coreprotect.database.Lookup;
import net.coreprotect.model.Config;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class PlayerListener
extends Queue
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    protected void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        String player = event.getPlayer().getName();
        Block block = event.getBlockClicked().getRelative(event.getBlockFace());
        World world = block.getWorld();
        boolean inspect = false;
        if (Config.inspecting.get(player) != null && Config.inspecting.get(player).booleanValue()) {
            inspect = true;
            event.setCancelled(true);
        }
        if (!event.isCancelled() && Functions.checkConfig(world, "buckets") == 1 && !inspect) {
            int wid = Functions.getWorldId(block.getWorld().getName());
            int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
            int type = 8;
            if (event.getBucket().equals((Object)Material.LAVA_BUCKET)) {
                type = 10;
            }
            Config.lookup_cache.put(block.getX() + "." + block.getY() + "." + block.getZ() + "." + wid, new Object[]{unixtimestamp, player, type});
            Queue.queueBlockPlace(player, block.getState(), type, 0);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    protected void onPlayerBucketFill(PlayerBucketFillEvent event) {
        String player = event.getPlayer().getName();
        Block block = event.getBlockClicked().getRelative(event.getBlockFace());
        World world = block.getWorld();
        int type = block.getTypeId();
        byte data = block.getData();
        boolean inspect = false;
        if (Config.inspecting.get(player) != null && Config.inspecting.get(player).booleanValue()) {
            inspect = true;
            event.setCancelled(true);
        }
        if (!event.isCancelled() && Functions.checkConfig(world, "buckets") == 1 && !inspect) {
            Queue.queueBlockBreak(player, block.getState(), type, data);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        World world = entity.getWorld();
        if (entity instanceof ItemFrame && !event.isCancelled() && Functions.checkConfig(world, "block-place") == 1) {
            ItemFrame frame = (ItemFrame)entity;
            int type = frame.getItem().getTypeId();
            int hand = player.getItemInHand().getTypeId();
            if (type == 0 && hand > 0) {
                int t = 389;
                int d = 0;
                if (frame.getItem() != null) {
                    d = frame.getItem().getTypeId();
                }
                String playername = player.getName();
                Block block = frame.getLocation().getBlock();
                Queue.queueBlockBreak(playername, block.getState(), t, d);
                Queue.queueBlockPlace(playername, block.getState(), t, hand);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    protected void onPlayerInteract(PlayerInteractEvent event) {
        int type;
        Block block;
        Player player = event.getPlayer();
        World world = player.getWorld();
        boolean inspecting_or_something = false;
        List<Integer> interact_blocks = Arrays.asList(23, 25, 54, 61, 62, 64, 69, 77, 93, 94, 96, 107, 117, 143, 145, 146, 149, 150, 154, 158);
        if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
            if (Config.inspecting.get(player.getName()) != null && Config.inspecting.get(player.getName()).booleanValue()) {
                Block block_final = event.getClickedBlock();
                Player player_final = player;
                class BasicThread
                implements Runnable {
                    private final /* synthetic */ Player val$player_final;
                    private final /* synthetic */ Block val$block_final;

                    BasicThread(Player player, Block block) {
                        this.val$player_final = player;
                        this.val$block_final = block;
                    }

                    @Override
                    public void run() {
                        try {
                            if (Config.converter_running) {
                                this.val$player_final.sendMessage("\u00a73CoreProtect \u00a7f- Upgrade in progress. Please try again later.");
                                return;
                            }
                            if (Config.purge_running) {
                                this.val$player_final.sendMessage("\u00a73CoreProtect \u00a7f- Purge in progress. Please try again later.");
                                return;
                            }
                            Connection connection = Database.getConnection(false);
                            if (connection != null) {
                                Statement statement = connection.createStatement();
                                String result_data = Lookup.block_lookup(statement, this.val$block_final, this.val$player_final.getName(), 0, 1, 7);
                                if (result_data.contains("\n")) {
                                    String[] stringArray = result_data.split("\n");
                                    int n = stringArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String b = stringArray[n2];
                                        this.val$player_final.sendMessage(b);
                                        ++n2;
                                    }
                                } else if (result_data.length() > 0) {
                                    this.val$player_final.sendMessage(result_data);
                                }
                                statement.close();
                                connection.close();
                            } else {
                                this.val$player_final.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                BasicThread runnable = new BasicThread(player_final, block_final);
                Thread thread = new Thread(runnable);
                thread.start();
                event.setCancelled(true);
            }
        } else if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && Config.inspecting.get(player.getName()) != null && Config.inspecting.get(player.getName()).booleanValue()) {
            List<Integer> safe_blocks = Arrays.asList(64, 69, 77, 96, 107);
            Block block2 = event.getClickedBlock();
            if (block2 != null) {
                Runnable runnable;
                Player player2;
                int type2 = block2.getTypeId();
                if (interact_blocks.contains(type2)) {
                    Block cblock = event.getClickedBlock();
                    player2 = player;
                    if (Config.containers.contains(type2) && Functions.checkConfig(world, "item-transactions") == 1) {
                        class BasicThread
                        implements Runnable {
                            private final /* synthetic */ Player val$player2;
                            private final /* synthetic */ int val$type;
                            private final /* synthetic */ Block val$cblock;

                            BasicThread(Player player, int n, Block block) {
                                this.val$player2 = player;
                                this.val$type = n;
                                this.val$cblock = block;
                            }

                            @Override
                            public void run() {
                                try {
                                    if (Config.converter_running) {
                                        this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Upgrade in progress. Please try again later.");
                                        return;
                                    }
                                    if (Config.purge_running) {
                                        this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Purge in progress. Please try again later.");
                                        return;
                                    }
                                    Connection connection = Database.getConnection(false);
                                    if (connection != null) {
                                        String blockdata;
                                        Statement statement = connection.createStatement();
                                        Location l = null;
                                        if (this.val$type == 54 || this.val$type == 146) {
                                            Chest chest = (Chest)this.val$cblock.getState();
                                            InventoryHolder i = chest.getInventory().getHolder();
                                            if (i instanceof DoubleChest) {
                                                DoubleChest c = (DoubleChest)i;
                                                l = c.getLocation();
                                            } else {
                                                l = chest.getLocation();
                                            }
                                        }
                                        if (l == null) {
                                            l = this.val$cblock.getLocation();
                                        }
                                        if ((blockdata = Lookup.chest_transactions(statement, l, this.val$player2.getName(), this.val$type, 1, 7)).contains("\n")) {
                                            String[] stringArray = blockdata.split("\n");
                                            int n = stringArray.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                String b = stringArray[n2];
                                                this.val$player2.sendMessage(b);
                                                ++n2;
                                            }
                                        } else {
                                            this.val$player2.sendMessage(blockdata);
                                        }
                                        statement.close();
                                        connection.close();
                                    } else {
                                        this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        runnable = new BasicThread(player2, type2, cblock);
                        Thread thread = new Thread(runnable);
                        thread.start();
                        event.setCancelled(true);
                    } else {
                        Block interact_block = cblock;
                        if (type2 == 64) {
                            int y = interact_block.getY() - 1;
                            Block block_under = interact_block.getWorld().getBlockAt(interact_block.getX(), y, interact_block.getZ());
                            if (block_under.getTypeId() == type2) {
                                interact_block = block_under;
                            }
                        }
                        Block final_interact_block = interact_block;
                        class BasicThread
                        implements Runnable {
                            private final /* synthetic */ Player val$player2;
                            private final /* synthetic */ Block val$final_interact_block;

                            BasicThread(Player player, Block block) {
                                this.val$player2 = player;
                                this.val$final_interact_block = block;
                            }

                            @Override
                            public void run() {
                                try {
                                    if (Config.converter_running) {
                                        this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Upgrade in progress. Please try again later.");
                                        return;
                                    }
                                    if (Config.purge_running) {
                                        this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Purge in progress. Please try again later.");
                                        return;
                                    }
                                    Connection connection = Database.getConnection(false);
                                    if (connection != null) {
                                        Statement statement = connection.createStatement();
                                        String blockdata = Lookup.interaction_lookup(statement, this.val$final_interact_block, this.val$player2.getName(), 0, 1, 7);
                                        if (blockdata.contains("\n")) {
                                            String[] stringArray = blockdata.split("\n");
                                            int n = stringArray.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                String b = stringArray[n2];
                                                this.val$player2.sendMessage(b);
                                                ++n2;
                                            }
                                        } else {
                                            this.val$player2.sendMessage(blockdata);
                                        }
                                        statement.close();
                                        connection.close();
                                    } else {
                                        this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        BasicThread runnable2 = new BasicThread(player2, final_interact_block);
                        Thread thread = new Thread(runnable2);
                        thread.start();
                        if (!safe_blocks.contains(type2)) {
                            event.setCancelled(true);
                        }
                    }
                    inspecting_or_something = true;
                } else {
                    Block fblock = event.getClickedBlock().getRelative(event.getBlockFace());
                    player2 = player;
                    class BasicThread
                    implements Runnable {
                        private final /* synthetic */ Player val$player2;
                        private final /* synthetic */ Block val$fblock;

                        BasicThread(Player player, Block block) {
                            this.val$player2 = player;
                            this.val$fblock = block;
                        }

                        @Override
                        public void run() {
                            try {
                                if (Config.converter_running) {
                                    this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Upgrade in progress. Please try again later.");
                                    return;
                                }
                                if (Config.purge_running) {
                                    this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Purge in progress. Please try again later.");
                                    return;
                                }
                                Connection connection = Database.getConnection(false);
                                if (connection != null) {
                                    Statement statement = connection.createStatement();
                                    if (this.val$fblock.getTypeId() == 0) {
                                        String blockdata = Lookup.block_lookup(statement, this.val$fblock, this.val$player2.getName(), 0, 1, 7);
                                        if (blockdata.contains("\n")) {
                                            String[] stringArray = blockdata.split("\n");
                                            int n = stringArray.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                String b = stringArray[n2];
                                                this.val$player2.sendMessage(b);
                                                ++n2;
                                            }
                                        } else if (blockdata.length() > 0) {
                                            this.val$player2.sendMessage(blockdata);
                                        }
                                    } else {
                                        String blockdata = Lookup.block_lookup(statement, this.val$fblock, this.val$player2.getName(), 0, 1, 7);
                                        if (blockdata.contains("\n")) {
                                            String[] stringArray = blockdata.split("\n");
                                            int n = stringArray.length;
                                            int n3 = 0;
                                            while (n3 < n) {
                                                String b = stringArray[n3];
                                                this.val$player2.sendMessage(b);
                                                ++n3;
                                            }
                                        } else if (blockdata.length() > 0) {
                                            this.val$player2.sendMessage(blockdata);
                                        }
                                    }
                                    statement.close();
                                    connection.close();
                                } else {
                                    this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    runnable = new BasicThread(player2, fblock);
                    Thread thread = new Thread(runnable);
                    thread.start();
                    event.setCancelled(true);
                }
            }
        }
        if ((block = event.getClickedBlock()) != null && interact_blocks.contains(type = block.getTypeId())) {
            boolean valid_click = true;
            if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                valid_click = false;
            }
            if (!inspecting_or_something && valid_click && !event.isCancelled() && Functions.checkConfig(world, "player-interactions") == 1) {
                Block interact_block = event.getClickedBlock();
                if (type == 64) {
                    int y = interact_block.getY() - 1;
                    Block block_under = interact_block.getWorld().getBlockAt(interact_block.getX(), y, interact_block.getZ());
                    if (block_under.getTypeId() == type) {
                        interact_block = block_under;
                    }
                }
                Queue.queuePlayerInteraction(player.getName(), interact_block.getState());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onInventoryClick(InventoryClickEvent event) {
        World world = event.getWhoClicked().getWorld();
        if (Functions.checkConfig(world, "item-transactions") == 1) {
            InventoryHolder i;
            Player player = (Player)event.getWhoClicked();
            Inventory inventory = event.getInventory();
            if (inventory != null && (i = inventory.getHolder()) != null) {
                BlockState state;
                Location l = null;
                if (i instanceof BlockState) {
                    state = (BlockState)i;
                    if (Config.containers.contains(state.getTypeId())) {
                        l = state.getLocation();
                    }
                } else if (i instanceof DoubleChest) {
                    state = (DoubleChest)i;
                    l = state.getLocation();
                }
                if (l != null) {
                    int x = l.getBlockX();
                    int y = l.getBlockY();
                    int z = l.getBlockZ();
                    for (HumanEntity viewer : inventory.getViewers()) {
                        List<ItemStack[]> list;
                        String logging_chest_id;
                        if (viewer.getName().equals(player.getName()) || Config.old_container.get(logging_chest_id = String.valueOf(viewer.getName().toLowerCase()) + "." + x + "." + y + "." + z) == null) continue;
                        int size_old = Config.old_container.get(logging_chest_id).size();
                        if (Config.force_containers.get(logging_chest_id) == null) {
                            Config.force_containers.put(logging_chest_id, new ArrayList());
                        }
                        if ((list = Config.force_containers.get(logging_chest_id)).size() >= size_old) continue;
                        list.add(Functions.get_container_state(inventory.getContents()));
                        Config.force_containers.put(logging_chest_id, list);
                    }
                    int chest_id = 0;
                    String logging_chest_id = String.valueOf(player.getName().toLowerCase()) + "." + x + "." + y + "." + z;
                    if (Config.logging_chest.get(logging_chest_id) != null) {
                        if (Config.force_containers.get(logging_chest_id) != null) {
                            int force_size = Config.force_containers.get(logging_chest_id).size();
                            List<ItemStack[]> list = Config.old_container.get(logging_chest_id);
                            if (list.size() > force_size) {
                                list.set(force_size, Functions.get_container_state(inventory.getContents()));
                            } else {
                                list.add(Functions.get_container_state(inventory.getContents()));
                            }
                            Config.old_container.put(logging_chest_id, list);
                        }
                        chest_id = Config.logging_chest.get(logging_chest_id) + 1;
                    } else {
                        ArrayList<ItemStack[]> list = new ArrayList<ItemStack[]>();
                        list.add(Functions.get_container_state(inventory.getContents()));
                        Config.old_container.put(logging_chest_id, list);
                    }
                    Config.logging_chest.put(logging_chest_id, chest_id);
                    Queue.queueContainerTransaction(player.getName(), l.getBlock().getState(), inventory, chest_id);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onSignChange(SignChangeEvent event) {
        String player = event.getPlayer().getName();
        Block block = event.getBlock();
        String line1 = event.getLine(0);
        String line2 = event.getLine(1);
        String line3 = event.getLine(2);
        String line4 = event.getLine(3);
        if (!event.isCancelled() && Functions.checkConfig(block.getWorld(), "sign-text") == 1) {
            Queue.queueSignText(player, block.getState(), line1, line2, line3, line4, 0);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (!event.getMessage().startsWith("/") && Functions.checkConfig(player.getWorld(), "player-messages") == 1) {
            int time = (int)(System.currentTimeMillis() / 1000L);
            Queue.queuePlayerChat(player, event.getMessage(), time);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (Functions.checkConfig(player.getWorld(), "player-commands") == 1) {
            int time = (int)(System.currentTimeMillis() / 1000L);
            Queue.queuePlayerCommand(player, event.getMessage(), time);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (Functions.checkConfig(player.getWorld(), "player-sessions") == 1) {
            int time = (int)(System.currentTimeMillis() / 1000L);
            Queue.queuePlayerLogin(player, time);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (Functions.checkConfig(player.getWorld(), "player-sessions") == 1) {
            int time = (int)(System.currentTimeMillis() / 1000L);
            Queue.queuePlayerQuit(player, time);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Item item = event.getItemDrop();
        int id = item.getEntityId();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Item item = event.getItem();
        int id = item.getEntityId();
    }
}

