/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener;

import java.util.List;
import net.coreprotect.Functions;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Lookup;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.StructureGrowEvent;

public class WorldListener
extends Queue
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    protected void onLeavesDecay(LeavesDecayEvent event) {
        World world = event.getBlock().getWorld();
        if (!event.isCancelled() && Functions.checkConfig(world, "leaf-decay") == 1) {
            String player = "#decay";
            Block block = event.getBlock();
            int type = event.getBlock().getTypeId();
            byte data = event.getBlock().getData();
            Queue.queueBlockBreak(player, block.getState(), type, data);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void OnPortalCreate(PortalCreateEvent event) {
        World world = event.getWorld();
        if (!event.isCancelled() && Functions.checkConfig(world, "portals") == 1) {
            int type;
            String user = "#portal";
            for (Block block : event.getBlocks()) {
                type = block.getTypeId();
                if (type != 51) continue;
                String result_data = Lookup.who_placed_cache(block);
                if (result_data.length() <= 0) break;
                user = result_data;
                break;
            }
            for (Block block : event.getBlocks()) {
                type = block.getTypeId();
                if (user.equals("#portal") && type != 49) {
                    Queue.queueBlockPlaceDelayed(user, block, null, 20);
                    continue;
                }
                if (type != 0) continue;
                Queue.queueBlockPlace(user, block.getState(), 90, (int)block.getData());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onStructureGrow(StructureGrowEvent event) {
        String user = "#tree";
        boolean tree = true;
        if (event.getSpecies().name().toLowerCase().contains("mushroom")) {
            user = "#mushroom";
            tree = false;
        }
        if (!event.isCancelled()) {
            World world = event.getWorld();
            if (tree && Functions.checkConfig(world, "tree-growth") == 1 || !tree && Functions.checkConfig(world, "mushroom-growth") == 1) {
                Player player = event.getPlayer();
                Location location = event.getLocation();
                List blocks = event.getBlocks();
                if (player != null) {
                    user = player.getName();
                }
                Queue.queueStructureGrow(user, world.getBlockAt(location).getState(), blocks);
            }
        }
    }
}

