/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.model;

import java.io.File;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.coreprotect.CoreProtect;
import net.coreprotect.consumer.Queue;
import net.coreprotect.convert.Converter;
import net.coreprotect.database.Database;
import net.coreprotect.model.BlockInfo;
import net.coreprotect.patch.Patch;
import org.bukkit.inventory.ItemStack;

public class Config
extends Queue {
    public static String driver = "com.mysql.jdbc.Driver";
    public static String sqlite = "plugins/CoreProtect/database.db";
    public static String host = "localhost";
    public static int port = 3306;
    public static String database = "database";
    public static String username = "root";
    public static String password = "";
    public static String prefix = "co_";
    public static boolean server_running = true;
    public static boolean converter_running = false;
    public static boolean purge_running = false;
    public static boolean consumer_running = false;
    public static int world_id = 0;
    public static Map<String, Integer> worlds = Collections.synchronizedMap(new HashMap());
    public static Map<Integer, String> worlds_reversed = Collections.synchronizedMap(new HashMap());
    public static Map<String, Integer> config = Collections.synchronizedMap(new HashMap());
    public static Map<String, int[]> rollback_hash = Collections.synchronizedMap(new HashMap());
    public static Map<String, Boolean> inspecting = Collections.synchronizedMap(new HashMap());
    public static Map<String, Object[]> lookup_cache = Collections.synchronizedMap(new HashMap());
    public static Map<String, Object[]> break_cache = Collections.synchronizedMap(new HashMap());
    public static Map<String, Object[]> piston_cache = Collections.synchronizedMap(new HashMap());
    public static Map<String, Object[]> entity_cache = Collections.synchronizedMap(new HashMap());
    public static Map<String, Boolean> blacklist = Collections.synchronizedMap(new HashMap());
    public static Map<String, Integer> logging_chest = Collections.synchronizedMap(new HashMap());
    public static Map<String, List<ItemStack[]>> old_container = Collections.synchronizedMap(new HashMap());
    public static Map<String, List<ItemStack[]>> force_containers = Collections.synchronizedMap(new HashMap());
    public static Map<String, Integer> lookup_type = Collections.synchronizedMap(new HashMap());
    public static Map<String, Integer> lookup_page = Collections.synchronizedMap(new HashMap());
    public static Map<String, String> lookup_command = Collections.synchronizedMap(new HashMap());
    public static Map<String, List<String>> lookup_blist = Collections.synchronizedMap(new HashMap());
    public static Map<String, List<String>> lookup_elist = Collections.synchronizedMap(new HashMap());
    public static Map<String, List<String>> lookup_e_userlist = Collections.synchronizedMap(new HashMap());
    public static Map<String, List<String>> lookup_ulist = Collections.synchronizedMap(new HashMap());
    public static Map<String, List<Integer>> lookup_alist = Collections.synchronizedMap(new HashMap());
    public static Map<String, Integer[]> lookup_radius = Collections.synchronizedMap(new HashMap());
    public static Map<String, String> lookup_time = Collections.synchronizedMap(new HashMap());
    public static Map<String, Integer> lookup_rows = Collections.synchronizedMap(new HashMap());
    public static Map<String, Integer> player_id_cache = Collections.synchronizedMap(new HashMap());
    public static Map<Integer, String> player_id_cache_reversed = Collections.synchronizedMap(new HashMap());
    public static Map<String, List<Object[]>> last_rollback = Collections.synchronizedMap(new HashMap());
    public static List<Integer> track_any = Arrays.asList(34, 50, 69, 75, 76);
    public static List<Integer> track_top = Arrays.asList(6, 27, 28, 31, 32, 37, 38, 39, 40, 55, 59, 63, 64, 66, 70, 71, 72, 78, 81, 83, 93, 94, 104, 105, 140, 141, 142, 147, 148, 149, 150, 157);
    public static List<Integer> track_side = Arrays.asList(26, 65, 68, 77, 96, 106, 127, 131, 143);
    public static List<Integer> containers = Arrays.asList(23, 54, 61, 62, 117, 146, 154, 158);
    public static List<Integer> falling_block_types = Arrays.asList(12, 13, 145);
    public static List<Integer> non_solid_entity_blocks = Arrays.asList(0, 6, 8, 9, 10, 11, 27, 28, 30, 31, 32, 34, 37, 38, 39, 40, 50, 51, 59, 66, 69, 70, 72, 75, 76, 77, 78, 83, 92, 93, 94, 96, 127, 131, 132, 140, 141, 142, 143, 147, 148, 149, 150, 157);
    public static Map<String, Boolean> active_rollbacks = Collections.synchronizedMap(new HashMap());

    public static void loadConfig() {
        try {
            File dir;
            String[] children;
            String confighead = "#CoreProtect Config\n";
            String noisy = "\n# If enabled, extra data is displayed when doing rollbacks and restores.\n# If disabled, you can manually trigger it in-game by adding \"#verbose\"\n# to the end of your rollback statement.\nverbose: true\n";
            String mysql = "\n# MySQL is optional and not required.\n# If you prefer to use MySQL, enable the following and fill out the fields.\nuse-mysql: false\ntable-prefix: co_\nmysql-host: localhost\nmysql-port: 3306\nmysql-database: database\nmysql-username: root\nmysql-password: \n";
            String update = "\n# If enabled, CoreProtect will check for updates when your server starts up.\n# If an update is available, you'll be notified via your server console.\ncheck-updates: true\n";
            String api = "\n# If enabled, other plugins will be able to utilize the CoreProtect API.\napi-enabled: true\n";
            String defaultradius = "\n# If no radius is specified in a rollback or restore, this value will be\n# used as the radius. Set to \"0\" to disable automatically adding a radius.\ndefault-radius: 10\n";
            String maxradius = "\n# The maximum radius that can be used in a command. Set to \"0\" to disable.\n# To run a rollback or restore without a radius, you can use \"r:#global\".\nmax-radius: 100\n";
            String rollbackitems = "\n# If enabled, items taken from containers (etc) will be included in rollbacks.\nrollback-items: true\n";
            String rollbackentities = "\n# If enabled, entities, such as killed animals, will be included in rollbacks.\nrollback-entities: true\n";
            String skipgenericdata = "\n# If enabled, generic data, like zombies burning in daylight, won't be logged.\nskip-generic-data: true\n";
            String blockplace = "\n# Logs blocks placed by players.\nblock-place: true\n";
            String blockbreak = "\n# Logs blocks broken by players.\nblock-break: true\n";
            String naturalbreak = "\n# Logs blocks that break off of other blocks; for example, a sign or torch\n# falling off of a dirt block that a player breaks. This is required for\n# beds/doors to properly rollback.\nnatural-break: true\n";
            String blockmovement = "\n# Properly track block movement, such as sand or gravel falling.\nblock-movement: true\n";
            String pistons = "\n# Properly track blocks moved by pistons.\npistons: true\n";
            String blockburn = "\n# Logs blocks that burn up in a fire.\nblock-burn: true\n";
            String blockignite = "\n# Logs when a block naturally ignites, such as from fire spreading.\nblock-ignite: true\n";
            String explosions = "\n# Logs explosions, such as TNT and Creepers.\nexplosions: true\n";
            String entitychange = "\n# Track when an entity changes a block, such as an Enderman destroying blocks.\nentity-change: true\n";
            String entitykills = "\n# Logs killed entities, such as killed cows and enderman.\nentity-kills: true\n";
            String signtext = "\n# Logs text on signs. If disabled, signs will be blank when rolled back.\nsign-text: true\n";
            String buckets = "\n# Logs lava and water sources placed/removed by players who are using buckets.\nbuckets: true\n";
            String leafdecay = "\n# Logs natural tree leaf decay.\nleaf-decay: true\n";
            String treegrowth = "\n# Logs tree growth. Trees are linked to the player who planted the sappling.\ntree-growth: true\n";
            String mushroomgrowth = "\n# Logs mushroom growth.\nmushroom-growth: true\n";
            String vinegrowth = "\n# Logs natural vine growth.\nvine-growth: true\n";
            String portals = "\n# Logs when portals such as Nether portals generate naturally.\nportals: true\n";
            String waterflow = "\n# Logs water flow. If water destroys other blocks, such as torches,\n# this allows it to be properly rolled back.\nwater-flow: true\n";
            String lavaflow = "\n# Logs lava flow. If lava destroys other blocks, such as torches,\n# this allows it to be properly rolled back.\nlava-flow: true\n";
            String liquidtracking = "\n# Allows liquid to be properly tracked and linked to players.\n# For example, if a player places water which flows and destroys torches,\n# it can all be properly restored by rolling back that single player.\nliquid-tracking: true\n";
            String itemlogging = "\n# Track item transactions, such as when a player takes items from a\n# chest, furnace, or dispenser. Necessary for any item based rollbacks.\nitem-transactions: true\n";
            String playerinteract = "\n# Track player interactions, such as when a player opens a door, presses\n# a button, or opens a chest. Player interactions can't be rolled back.\nplayer-interactions: true\n";
            String playermessages = "\n# Logs messages that players send in the chat.\nplayer-messages: true\n";
            String playercommands = "\n# Logs all commands used by players.\nplayer-commands: true\n";
            String playersessions = "\n# Logs the logins and logouts of players.\nplayer-sessions: true\n";
            String worldedit = "\n# Logs changes made via the plugin \"WorldEdit\" if it's in use on your server.\nworldedit: true\n";
            config.clear();
            File config_file = new File("plugins/CoreProtect/config.yml");
            boolean exists = config_file.exists();
            if (!exists) {
                config_file.createNewFile();
            }
            if ((children = (dir = new File("plugins/CoreProtect")).list()) != null) {
                int i = 0;
                while (i < children.length) {
                    String filename = children[i];
                    if (!filename.startsWith(".") && filename.endsWith(".yml")) {
                        try {
                            RandomAccessFile configfile;
                            long config_length;
                            String key = filename.replaceAll(".yml", "-");
                            if (key.equals("config-")) {
                                key = "";
                            }
                            if ((config_length = (configfile = new RandomAccessFile("plugins/CoreProtect/" + filename, "rw")).length()) > 0L) {
                                while (configfile.getFilePointer() < configfile.length()) {
                                    String setting;
                                    String line = configfile.readLine();
                                    if (!line.contains(":") || line.startsWith("#")) continue;
                                    line = line.replaceFirst(":", "\u00a7 ");
                                    String[] i2 = line.split("\u00a7");
                                    String option = i2[0].trim().toLowerCase();
                                    if (key.length() == 0) {
                                        if (option.equals("verbose")) {
                                            setting = i2[1].trim().toLowerCase();
                                            if (setting.startsWith("t")) {
                                                config.put(String.valueOf(key) + "verbose", 1);
                                            } else if (setting.startsWith("f")) {
                                                config.put("verbose", 0);
                                            }
                                        }
                                        if (option.equals("use-mysql")) {
                                            setting = i2[1].trim().toLowerCase();
                                            if (setting.startsWith("t")) {
                                                config.put("use-mysql", 1);
                                            } else if (setting.startsWith("f")) {
                                                config.put("use-mysql", 0);
                                            }
                                        }
                                        if (option.equals("table-prefix")) {
                                            prefix = i2[1].trim();
                                        }
                                        if (option.equals("mysql-host")) {
                                            host = i2[1].trim();
                                        }
                                        if (option.equals("mysql-port")) {
                                            setting = i2[1].trim();
                                            if ((setting = setting.replaceAll("[^0-9]", "")).length() == 0) {
                                                setting = "0";
                                            }
                                            port = Integer.parseInt(setting);
                                        }
                                        if (option.equals("mysql-database")) {
                                            database = i2[1].trim();
                                        }
                                        if (option.equals("mysql-username")) {
                                            username = i2[1].trim();
                                        }
                                        if (option.equals("mysql-password")) {
                                            password = i2[1].trim();
                                        }
                                        if (option.equals("check-updates")) {
                                            setting = i2[1].trim().toLowerCase();
                                            if (setting.startsWith("t")) {
                                                config.put("check-updates", 1);
                                            } else if (setting.startsWith("f")) {
                                                config.put("check-updates", 0);
                                            }
                                        }
                                        if (option.equals("api-enabled")) {
                                            setting = i2[1].trim().toLowerCase();
                                            if (setting.startsWith("t")) {
                                                config.put("api-enabled", 1);
                                            } else if (setting.startsWith("f")) {
                                                config.put("api-enabled", 0);
                                            }
                                        }
                                        if (option.equals("default-radius")) {
                                            setting = i2[1].trim();
                                            if ((setting = setting.replaceAll("[^0-9]", "")).length() == 0) {
                                                setting = "0";
                                            }
                                            config.put("default-radius", Integer.parseInt(setting));
                                        }
                                        if (option.equals("max-radius")) {
                                            setting = i2[1].trim();
                                            if ((setting = setting.replaceAll("[^0-9]", "")).length() == 0) {
                                                setting = "0";
                                            }
                                            config.put("max-radius", Integer.parseInt(setting));
                                        }
                                        if (option.equals("rollback-items")) {
                                            setting = i2[1].trim().toLowerCase();
                                            if (setting.startsWith("t")) {
                                                config.put("rollback-items", 1);
                                            } else if (setting.startsWith("f")) {
                                                config.put("rollback-items", 0);
                                            }
                                        }
                                        if (option.equals("rollback-entities")) {
                                            setting = i2[1].trim().toLowerCase();
                                            if (setting.startsWith("t")) {
                                                config.put("rollback-entities", 1);
                                            } else if (setting.startsWith("f")) {
                                                config.put("rollback-entities", 0);
                                            }
                                        }
                                    }
                                    if (option.equals("skip-generic-data")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "skip-generic-data", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "skip-generic-data", 0);
                                        }
                                    }
                                    if (option.equals("block-place")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "block-place", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "block-place", 0);
                                        }
                                    }
                                    if (option.equals("block-break")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "block-break", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "block-break", 0);
                                        }
                                    }
                                    if (option.equals("natural-break")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "natural-break", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "natural-break", 0);
                                        }
                                    }
                                    if (option.equals("block-movement")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "block-movement", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "block-movement", 0);
                                        }
                                    }
                                    if (option.equals("pistons")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "pistons", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "pistons", 0);
                                        }
                                    }
                                    if (option.equals("block-burn")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "block-burn", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "block-burn", 0);
                                        }
                                    }
                                    if (option.equals("block-ignite")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "block-ignite", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "block-ignite", 0);
                                        }
                                    }
                                    if (option.equals("explosions")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "explosions", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "explosions", 0);
                                        }
                                    }
                                    if (option.equals("entity-change")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "entity-change", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "entity-change", 0);
                                        }
                                    }
                                    if (option.equals("entity-kills")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "entity-kills", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "entity-kills", 0);
                                        }
                                    }
                                    if (option.equals("sign-text")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "sign-text", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "sign-text", 0);
                                        }
                                    }
                                    if (option.equals("buckets")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "buckets", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "buckets", 0);
                                        }
                                    }
                                    if (option.equals("leaf-decay")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "leaf-decay", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "leaf-decay", 0);
                                        }
                                    }
                                    if (option.equals("tree-growth")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "tree-growth", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "tree-growth", 0);
                                        }
                                    }
                                    if (option.equals("mushroom-growth")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "mushroom-growth", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "mushroom-growth", 0);
                                        }
                                    }
                                    if (option.equals("vine-growth")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "vine-growth", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "vine-growth", 0);
                                        }
                                    }
                                    if (option.equals("portals")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "portals", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "portals", 0);
                                        }
                                    }
                                    if (option.equals("water-flow")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "water-flow", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "water-flow", 0);
                                        }
                                    }
                                    if (option.equals("lava-flow")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "lava-flow", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "lava-flow", 0);
                                        }
                                    }
                                    if (option.equals("liquid-tracking")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "liquid-tracking", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "liquid-tracking", 0);
                                        }
                                    }
                                    if (option.equals("item-transactions")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "item-transactions", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "item-transactions", 0);
                                        }
                                    }
                                    if (option.equals("player-interactions")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "player-interactions", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "player-interactions", 0);
                                        }
                                    }
                                    if (option.equals("player-messages")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "player-messages", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "player-messages", 0);
                                        }
                                    }
                                    if (option.equals("player-commands")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "player-commands", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "player-commands", 0);
                                        }
                                    }
                                    if (option.equals("player-sessions")) {
                                        setting = i2[1].trim().toLowerCase();
                                        if (setting.startsWith("t")) {
                                            config.put(String.valueOf(key) + "player-sessions", 1);
                                        } else if (setting.startsWith("f")) {
                                            config.put(String.valueOf(key) + "player-sessions", 0);
                                        }
                                    }
                                    if (!option.equals("worldedit")) continue;
                                    setting = i2[1].trim().toLowerCase();
                                    if (setting.startsWith("t")) {
                                        config.put(String.valueOf(key) + "worldedit", 1);
                                        continue;
                                    }
                                    if (!setting.startsWith("f")) continue;
                                    config.put(String.valueOf(key) + "worldedit", 0);
                                }
                            }
                            if (key.length() == 0) {
                                if (config_length < 1L) {
                                    configfile.write(confighead.getBytes());
                                }
                                if (config.get("verbose") == null) {
                                    config.put("verbose", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(noisy.getBytes());
                                }
                                if (config.get("use-mysql") == null) {
                                    config.put("use-mysql", 0);
                                    configfile.seek(configfile.length());
                                    configfile.write(mysql.getBytes());
                                }
                                if (config.get("check-updates") == null) {
                                    config.put("check-updates", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(update.getBytes());
                                }
                                if (config.get("api-enabled") == null) {
                                    config.put("api-enabled", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(api.getBytes());
                                }
                                if (config.get("default-radius") == null) {
                                    config.put("default-radius", 10);
                                    configfile.seek(configfile.length());
                                    configfile.write(defaultradius.getBytes());
                                }
                                if (config.get("max-radius") == null) {
                                    config.put("max-radius", 100);
                                    configfile.seek(configfile.length());
                                    configfile.write(maxradius.getBytes());
                                }
                                if (config.get("rollback-items") == null) {
                                    config.put("rollback-items", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(rollbackitems.getBytes());
                                }
                                if (config.get("rollback-entities") == null) {
                                    config.put("rollback-entities", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(rollbackentities.getBytes());
                                }
                                if (config.get("skip-generic-data") == null) {
                                    config.put("skip-generic-data", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(skipgenericdata.getBytes());
                                }
                                if (config.get("block-place") == null) {
                                    config.put("block-place", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(blockplace.getBytes());
                                }
                                if (config.get("block-break") == null) {
                                    config.put("block-break", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(blockbreak.getBytes());
                                }
                                if (config.get("natural-break") == null) {
                                    config.put("natural-break", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(naturalbreak.getBytes());
                                }
                                if (config.get("block-movement") == null) {
                                    config.put("block-movement", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(blockmovement.getBytes());
                                }
                                if (config.get("pistons") == null) {
                                    config.put("pistons", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(pistons.getBytes());
                                }
                                if (config.get("block-burn") == null) {
                                    config.put("block-burn", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(blockburn.getBytes());
                                }
                                if (config.get("block-ignite") == null) {
                                    config.put("block-ignite", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(blockignite.getBytes());
                                }
                                if (config.get("explosions") == null) {
                                    config.put("explosions", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(explosions.getBytes());
                                }
                                if (config.get("entity-change") == null) {
                                    config.put("entity-change", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(entitychange.getBytes());
                                }
                                if (config.get("entity-kills") == null) {
                                    config.put("entity-kills", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(entitykills.getBytes());
                                }
                                if (config.get("sign-text") == null) {
                                    config.put("sign-text", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(signtext.getBytes());
                                }
                                if (config.get("buckets") == null) {
                                    config.put("buckets", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(buckets.getBytes());
                                }
                                if (config.get("leaf-decay") == null) {
                                    config.put("leaf-decay", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(leafdecay.getBytes());
                                }
                                if (config.get("tree-growth") == null) {
                                    config.put("tree-growth", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(treegrowth.getBytes());
                                }
                                if (config.get("mushroom-growth") == null) {
                                    config.put("mushroom-growth", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(mushroomgrowth.getBytes());
                                }
                                if (config.get("vine-growth") == null) {
                                    config.put("vine-growth", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(vinegrowth.getBytes());
                                }
                                if (config.get("portals") == null) {
                                    config.put("portals", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(portals.getBytes());
                                }
                                if (config.get("water-flow") == null) {
                                    config.put("water-flow", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(waterflow.getBytes());
                                }
                                if (config.get("lava-flow") == null) {
                                    config.put("lava-flow", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(lavaflow.getBytes());
                                }
                                if (config.get("liquid-tracking") == null) {
                                    config.put("liquid-tracking", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(liquidtracking.getBytes());
                                }
                                if (config.get("item-transactions") == null) {
                                    config.put("item-transactions", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(itemlogging.getBytes());
                                }
                                if (config.get("player-interactions") == null) {
                                    config.put("player-interactions", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(playerinteract.getBytes());
                                }
                                if (config.get("player-messages") == null) {
                                    config.put("player-messages", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(playermessages.getBytes());
                                }
                                if (config.get("player-commands") == null) {
                                    config.put("player-commands", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(playercommands.getBytes());
                                }
                                if (config.get("player-sessions") == null) {
                                    config.put("player-sessions", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(playersessions.getBytes());
                                }
                                if (config.get("worldedit") == null) {
                                    config.put("worldedit", 1);
                                    configfile.seek(configfile.length());
                                    configfile.write(worldedit.getBytes());
                                }
                            }
                            configfile.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
            if (config.get("use-mysql") == 0) {
                prefix = "co_";
            }
            Config.loadBlacklist();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadDatabase() {
        if (config.get("use-mysql") == 1) {
            boolean success = false;
            try {
                Connection connection = Database.getConnection(true);
                if (connection != null) {
                    Statement statement = connection.createStatement();
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "block(rowid int(10) NOT NULL AUTO_INCREMENT,PRIMARY KEY(rowid), time int(10), user int(8), wid int(4), x int(8), y int(3), z int(8), type int(6), data int(8), meta blob, action int(2), rolled_back tinyint(1), INDEX(wid,x,z,time), INDEX(user,time), INDEX(type,time)) ENGINE=InnoDB");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "chat(rowid int(8) NOT NULL AUTO_INCREMENT,PRIMARY KEY(rowid),time int(10), user int(8), message varchar(255), INDEX(time), INDEX(user,time)) ENGINE=InnoDB");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "command(rowid int(8) NOT NULL AUTO_INCREMENT,PRIMARY KEY(rowid),time int(10), user int(8), message varchar(255), INDEX(time), INDEX(user,time)) ENGINE=InnoDB");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "container(rowid int(10) NOT NULL AUTO_INCREMENT,PRIMARY KEY(rowid), time int(10), user int(8), wid int(4), x int(8), y int(3), z int(8), type int(6), data int(6), amount int(4), meta int(2), metadata blob, action int(2), rolled_back tinyint(1), INDEX(wid,x,z,time), INDEX(user,time), INDEX(type,time)) ENGINE=InnoDB");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "entity(rowid int(8) NOT NULL AUTO_INCREMENT,PRIMARY KEY(rowid), time int(10), data blob) ENGINE=InnoDB");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "session(rowid int(8) NOT NULL AUTO_INCREMENT,PRIMARY KEY(rowid),time int(10), user int(8), wid int(4), x int(8), y int (3), z int(8), action int(1), INDEX(wid,x,z,time), INDEX(action,time), INDEX(user,time), INDEX(time)) ENGINE=InnoDB");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "sign(rowid int(8) NOT NULL AUTO_INCREMENT,PRIMARY KEY(rowid),time int(10), user int(8), wid int(4), x int(8), y int(3), z int(8), line_1 varchar(100), line_2 varchar(100), line_3 varchar(100), line_4 varchar(100), INDEX(wid,x,z,y,time)) ENGINE=InnoDB");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "skull(rowid int(8) NOT NULL AUTO_INCREMENT,PRIMARY KEY(rowid), time int(10), type int(2), data int(1), rotation int(2), owner varchar(16)) ENGINE=InnoDB");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "user(rowid int(8) NOT NULL AUTO_INCREMENT,PRIMARY KEY(rowid),time int(10),user varchar(32), INDEX(user)) ENGINE=InnoDB");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "version(rowid int(8) NOT NULL AUTO_INCREMENT,PRIMARY KEY(rowid),time int(10),version varchar(16)) ENGINE=InnoDB");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "world(rowid int(8) NOT NULL AUTO_INCREMENT,PRIMARY KEY(rowid),id int(8),world varchar(255)) ENGINE=InnoDB");
                    statement.close();
                    connection.close();
                    success = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!success) {
                config.put("use-mysql", 0);
            }
        }
        if (config.get("use-mysql") == 0) {
            try {
                Connection connection = Database.getConnection(true);
                Statement statement = connection.createStatement();
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "block (time INTEGER, user INTEGER, wid INTEGER, x INTEGER, y INTEGER, z INTEGER, type INTEGER, data INTEGER, meta BLOB, action INTEGER, rolled_back INTEGER);");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS block_index ON " + prefix + "block(wid,x,z,time);");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS block_user_index ON " + prefix + "block(user,time);");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS block_type_index ON " + prefix + "block(type,time);");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "chat (time INTEGER, user INTEGER, message TEXT);");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS chat_index ON " + prefix + "chat(time);");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS chat_user_index ON " + prefix + "chat(user,time);");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "command (time INTEGER, user INTEGER, message TEXT);");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS command_index ON " + prefix + "command(time);");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS command_user_index ON " + prefix + "command(user,time);");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "container (time INTEGER, user INTEGER, wid INTEGER, x INTEGER, y INTEGER, z INTEGER, type INTEGER, data INTEGER, amount INTEGER, meta INTEGER, metadata BLOB, action INTEGER, rolled_back INTEGER);");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS container_index ON " + prefix + "container(wid,x,z,time);");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS container_user_index ON " + prefix + "container(user,time);");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS container_type_index ON " + prefix + "container(type,time);");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "entity (id INTEGER PRIMARY KEY ASC, time INTEGER, data BLOB);");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "session (time INTEGER, user INTEGER, wid INTEGER, x INTEGER, y INTEGER, z INTEGER, action INTEGER);");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS session_index ON " + prefix + "session(wid,x,z,time);");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS session_action_index ON " + prefix + "session(action,time);");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS session_user_index ON " + prefix + "session(user,time);");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS session_time_index ON " + prefix + "session(time);");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "sign (time INTEGER, user INTEGER, wid INTEGER, x INTEGER, y INTEGER, z INTEGER, line_1 TEXT, line_2 TEXT, line_3 TEXT, line_4 TEXT);");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS sign_index ON " + prefix + "sign(wid,x,z,y,time);");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "skull (id INTEGER PRIMARY KEY ASC, time INTEGER, type INTEGER, data INTEGER, rotation INTEGER, owner TEXT);");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "user (id INTEGER PRIMARY KEY ASC, time INTEGER, user TEXT);");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS user_index ON " + prefix + "user(user);");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "version (time INTEGER, version TEXT);");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + prefix + "world (id INTEGER, world TEXT);");
                statement.close();
                connection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadBlacklist() {
        try {
            blacklist.clear();
            String blacklist = "plugins/CoreProtect/blacklist.txt";
            boolean exists = new File(blacklist).exists();
            if (exists) {
                RandomAccessFile blfile = new RandomAccessFile(blacklist, "rw");
                long blc = blfile.length();
                if (blc > 0L) {
                    while (blfile.getFilePointer() < blfile.length()) {
                        String blacklist_user = blfile.readLine().replaceAll(" ", "").toLowerCase();
                        if (blacklist_user.length() <= 0) continue;
                        Config.blacklist.put(blacklist_user, true);
                    }
                }
                blfile.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void loadWorlds(Statement statement) {
        try {
            String query = "SELECT id,world FROM " + prefix + "world";
            ResultSet rs = statement.executeQuery(query);
            while (rs.next()) {
                int id = rs.getInt("id");
                String world = rs.getString("world");
                worlds.put(world, id);
                worlds_reversed.put(id, world);
                if (id <= world_id) continue;
                world_id = id;
            }
            List worlds = CoreProtect.getInstance().getServer().getWorlds();
            for (String world : worlds) {
                String worldname = world.getName();
                if (Config.worlds.get(worldname) != null) continue;
                int id = world_id + 1;
                Config.worlds.put(worldname, id);
                worlds_reversed.put(id, worldname);
                world_id = id;
                Queue.queueWorldInsert(id, worldname);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void init() {
        try {
            BlockInfo.loadData();
            Converter.performUpgrade();
            Config.loadConfig();
            Config.loadDatabase();
            Config.finishStartup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void finishStartup() {
        try {
            Connection connection = Database.getConnection(true);
            Statement statement = connection.createStatement();
            Config.loadWorlds(statement);
            Patch.versionCheck(statement);
            statement.close();
            connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

