/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.patch;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import net.coreprotect.CoreProtect;
import net.coreprotect.Functions;
import net.coreprotect.consumer.Consumer;
import net.coreprotect.convert.Converter;
import net.coreprotect.database.Database;
import net.coreprotect.model.Config;
import net.coreprotect.patch.v205;
import net.coreprotect.patch.v206;

public class Patch {
    private static int runPatcher(double last_version, double version) {
        int result = -1;
        try {
            boolean patch = false;
            Connection connection = Database.getConnection(true);
            Statement statement = connection.createStatement();
            double patch_version = last_version;
            DecimalFormat df = new DecimalFormat("#.##");
            while (patch_version < version) {
                boolean success = true;
                boolean valid = false;
                if ((patch_version = Double.parseDouble(df.format(patch_version + 0.01).replaceAll(",", "."))) == 2.05) {
                    valid = true;
                    success = v205.performPatch(statement);
                }
                if (patch_version == 2.06) {
                    valid = true;
                    success = v206.performPatch(statement);
                }
                if (success && valid) {
                    patch = true;
                    continue;
                }
                if (success) continue;
                patch_version = Double.parseDouble(df.format(patch_version - 0.01));
                break;
            }
            if (patch_version == version) {
                result = patch ? 1 : 0;
            }
            if (result >= 0) {
                int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
                statement.executeUpdate("INSERT INTO " + Config.prefix + "version (time,version) VALUES ('" + unixtimestamp + "', '" + version + "')");
            }
            statement.close();
            connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void versionCheck(Statement statement) {
        try {
            double last_version = 0.0;
            double current_version = Double.parseDouble(new DecimalFormat("0.00").format(Double.parseDouble(CoreProtect.getInstance().getDescription().getVersion())).replaceAll(",", "."));
            String query = "SELECT version FROM " + Config.prefix + "version ORDER BY rowid DESC LIMIT 0, 1";
            ResultSet rs = statement.executeQuery(query);
            while (rs.next()) {
                String version = rs.getString("version");
                if (!version.contains(".")) {
                    int version_int = Integer.parseInt(version);
                    version = String.format("%3.2f", (double)version_int / 100.0);
                }
                version = version.replaceAll(",", ".");
                last_version = Double.parseDouble(version);
            }
            if (last_version < current_version && last_version > 0.0 && !Config.converter_running) {
                Config.converter_running = true;
                Consumer.is_paused = true;
                double v_old = last_version;
                double v_new = current_version;
                class Patcher
                implements Runnable {
                    private final /* synthetic */ double val$v_old;
                    private final /* synthetic */ double val$v_new;

                    Patcher(double d, double d2) {
                        this.val$v_old = d;
                        this.val$v_new = d2;
                    }

                    @Override
                    public void run() {
                        try {
                            int finished = Patch.runPatcher(this.val$v_old, this.val$v_new);
                            Config.converter_running = false;
                            if (finished == 1) {
                                Converter.processConsumer();
                                Functions.messageOwner("-----");
                                Functions.messageOwner("Successfully upgraded to v" + CoreProtect.getInstance().getDescription().getVersion() + ".");
                                Functions.messageOwner("-----");
                            } else if (finished == 0) {
                                if (!Config.consumer_running) {
                                    Thread consumerThread = new Thread(new Consumer());
                                    consumerThread.start();
                                }
                            } else if (finished == -1) {
                                Config.consumer_running = false;
                                Functions.messageOwner("Upgrade interrupted. Will try again on restart.");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                Thread thread = new Thread(new Patcher(v_old, v_new));
                thread.start();
            } else if (last_version == 0.0) {
                int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
                statement.executeUpdate("INSERT INTO " + Config.prefix + "version (time,version) VALUES ('" + unixtimestamp + "', '" + current_version + "')");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

