/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.worldedit;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import net.coreprotect.CoreProtect;
import net.coreprotect.Functions;
import net.coreprotect.worldedit.WorldEdit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.ItemStack;

public class CoreProtectEditSession
extends EditSession {
    private LocalPlayer player;

    public CoreProtectEditSession(LocalWorld world, int max_blocks, LocalPlayer player, CoreProtect coreprotect) {
        super(world, max_blocks);
        this.player = player;
    }

    public CoreProtectEditSession(LocalWorld world, int max_blocks, BlockBag block_bag, LocalPlayer player, CoreProtect coreprotect) {
        super(world, max_blocks, block_bag);
        this.player = player;
    }

    public boolean rawSetBlock(Vector vector, BaseBlock base_block) {
        Block block = ((BukkitWorld)this.player.getWorld()).getWorld().getBlockAt(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
        if (!(this.player.getWorld() instanceof BukkitWorld) || Functions.checkConfig(block.getWorld(), "worldedit") == 0) {
            return super.rawSetBlock(vector, base_block);
        }
        BlockState block_state = block.getState();
        ItemStack[] container_contents = Functions.getContainerContents(block);
        boolean success = super.rawSetBlock(vector, base_block);
        if (success) {
            WorldEdit.logData(this.player, vector, block, block_state, container_contents);
        }
        return success;
    }
}

