/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.worldedit;

import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import java.util.Arrays;
import java.util.List;
import net.coreprotect.Functions;
import net.coreprotect.consumer.Queue;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class WorldEdit
extends Queue {
    public static WorldEditPlugin getWorldEdit(Server server) {
        Plugin pl = server.getPluginManager().getPlugin("WorldEdit");
        if (pl == null || !(pl instanceof WorldEditPlugin)) {
            return null;
        }
        return (WorldEditPlugin)pl;
    }

    protected static void logData(LocalPlayer player, Vector vector, Block block, BlockState block_state, ItemStack[] container_contents) {
        List<Integer> signs = Arrays.asList(63, 68);
        int old_type = block_state.getTypeId();
        byte old_data = block_state.getData().getData();
        int new_type = block.getTypeId();
        byte new_data = block.getData();
        if (old_type != new_type || old_data != new_data) {
            try {
                if (Functions.checkConfig(block_state.getWorld(), "sign-text") == 1 && signs.contains(old_type)) {
                    Sign sign = (Sign)block_state;
                    String line1 = sign.getLine(0);
                    String line2 = sign.getLine(1);
                    String line3 = sign.getLine(2);
                    String line4 = sign.getLine(3);
                    Queue.queueSignText(player.getName(), block.getState(), line1, line2, line3, line4, 5);
                }
                if (container_contents != null) {
                    Queue.queueContainerBreak(player.getName(), block.getState(), container_contents);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (old_type == 0 && new_type > 0) {
                Queue.queueBlockPlace(player.getName(), block);
            } else if (old_type > 0 && new_type > 0) {
                Queue.queueBlockPlace(player.getName(), block, block_state, 0);
            } else if (old_type > 0 && new_type == 0) {
                Queue.queueBlockBreak(player.getName(), block_state, old_type, old_data);
            }
        }
    }
}

