/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Compass;
import org.bukkit.entity.Player;

public class TownyAsciiMap {
    public static final int lineWidth = 27;
    public static final int halfLineWidth = 13;
    public static final String[] help = new String[]{"  \u00a78-\u00a77 = Unclaimed", "  \u00a7f+\u00a77 = Claimed", "  \u00a7f$\u00a77 = For sale", "  \u00a7a+\u00a77 = Your town", "  \u00a7e+\u00a77 = Your plot", "  \u00a72+\u00a77 = Ally", "  \u00a74+\u00a77 = Enemy"};

    public static String[] generateCompass(Player player) {
        Compass.Point point = Compass.getCompassPointForDirection(player.getLocation().getYaw());
        return new String[]{"\u00a70  -----  ", "\u00a70  -" + (point == Compass.Point.NW ? "\u00a76\\" : "-") + (point == Compass.Point.N ? "\u00a76" : "\u00a7f") + "N" + (point == Compass.Point.NE ? "\u00a76/\u00a70" : "\u00a70-") + "-  ", "\u00a70  -" + (point == Compass.Point.W ? "\u00a76W" : "\u00a7fW") + "\u00a77" + "+" + (point == Compass.Point.E ? "\u00a76" : "\u00a7f") + "E" + "\u00a70" + "-  ", "\u00a70  -" + (point == Compass.Point.SW ? "\u00a76/" : "-") + (point == Compass.Point.S ? "\u00a76" : "\u00a7f") + "S" + (point == Compass.Point.SE ? "\u00a76\\\u00a70" : "\u00a70-") + "-  "};
    }

    public static void generateAndSend(Towny towny, Player player, int n) {
        TownyWorld townyWorld;
        Resident resident;
        boolean bl = false;
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
            if (resident.hasTown()) {
                bl = true;
            }
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            return;
        }
        try {
            townyWorld = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
        }
        catch (NotRegisteredException notRegisteredException) {
            TownyMessaging.sendErrorMsg((Object)player, "You are not in a registered world.");
            return;
        }
        if (!townyWorld.isUsingTowny()) {
            TownyMessaging.sendErrorMsg((Object)player, "This world is not using towny.");
            return;
        }
        Coord coord = Coord.parseCoord(towny.getCache(player).getLastLocation());
        int n2 = n / 2;
        String[][] stringArray = new String[27][n];
        int n3 = 0;
        for (int i = coord.getX() + 13; i >= coord.getX() - 13; --i) {
            int n4 = 0;
            for (int j = coord.getZ() - n2; j <= coord.getZ() + (n - n2 - 1); ++j) {
                try {
                    TownBlock townBlock = townyWorld.getTownBlock(i, j);
                    if (!townBlock.hasTown()) {
                        throw new TownyException();
                    }
                    if (n4 == n2 && n3 == 13) {
                        stringArray[n3][n4] = "\u00a76";
                    } else if (bl) {
                        if (resident.getTown() == townBlock.getTown()) {
                            stringArray[n3][n4] = "\u00a7a";
                            try {
                                if (resident == townBlock.getResident()) {
                                    stringArray[n3][n4] = "\u00a7e";
                                }
                            }
                            catch (NotRegisteredException notRegisteredException) {}
                        } else {
                            Nation nation;
                            stringArray[n3][n4] = resident.hasNation() ? (resident.getTown().getNation().hasTown(townBlock.getTown()) ? "\u00a72" : (townBlock.getTown().hasNation() ? ((nation = resident.getTown().getNation()).hasAlly(townBlock.getTown().getNation()) ? "\u00a72" : (nation.hasEnemy(townBlock.getTown().getNation()) ? "\u00a74" : "\u00a7f")) : "\u00a7f")) : "\u00a7f";
                        }
                    } else {
                        stringArray[n3][n4] = "\u00a7f";
                    }
                    if (townBlock.getPlotPrice() != -1.0) {
                        if (townBlock.getType().equals((Object)TownBlockType.COMMERCIAL)) {
                            stringArray[n3][n4] = "\u00a73";
                        }
                        String[] stringArray2 = stringArray[n3];
                        int n5 = n4;
                        stringArray2[n5] = stringArray2[n5] + "$";
                    } else if (townBlock.isHomeBlock()) {
                        String[] stringArray3 = stringArray[n3];
                        int n6 = n4;
                        stringArray3[n6] = stringArray3[n6] + "H";
                    } else {
                        String[] stringArray4 = stringArray[n3];
                        int n7 = n4;
                        stringArray4[n7] = stringArray4[n7] + townBlock.getType().getAsciiMapKey();
                    }
                }
                catch (TownyException townyException) {
                    stringArray[n3][n4] = n4 == n2 && n3 == 13 ? "\u00a76" : "\u00a78";
                    String[] stringArray5 = stringArray[n3];
                    int n8 = n4;
                    stringArray5[n8] = stringArray5[n8] + "-";
                }
                ++n4;
            }
            ++n3;
        }
        String[] stringArray6 = TownyAsciiMap.generateCompass(player);
        player.sendMessage(ChatTools.formatTitle("Towny Map \u00a7f(" + coord.toString() + ")"));
        int n9 = 0;
        for (int i = 0; i < n; ++i) {
            String string = stringArray6[0];
            if (n9 < stringArray6.length) {
                string = stringArray6[n9];
            }
            for (int j = 26; j >= 0; --j) {
                string = string + stringArray[j][i];
            }
            if (n9 < help.length) {
                string = string + help[n9];
            }
            player.sendMessage(string);
            ++n9;
        }
        try {
            TownBlock townBlock = townyWorld.getTownBlock(coord);
            TownyMessaging.sendMsg((Object)player, "Town: " + (townBlock.hasTown() ? townBlock.getTown().getName() : "None") + " : " + "Owner: " + (townBlock.hasResident() ? townBlock.getResident().getName() : "None"));
        }
        catch (TownyException townyException) {
            player.sendMessage("");
        }
    }
}

