/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.iConomy.iConomy;
import com.iConomy.system.Account;
import com.nijikokun.register.payment.Method;
import com.nijikokun.register.payment.Methods;
import com.palmergames.bukkit.towny.Towny;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class TownyEconomyHandler {
    private static Towny plugin = null;
    private static Economy vaultEconomy = null;
    private static EcoType Type = EcoType.NONE;
    private static String version = "";

    public static void initialize(Towny towny) {
        plugin = towny;
    }

    public static EcoType getType() {
        return Type;
    }

    public static boolean isActive() {
        return Type != EcoType.NONE;
    }

    public static String getVersion() {
        return version;
    }

    private static void setVersion(String string) {
        version = string;
    }

    public static Boolean setupEconomy() {
        Plugin plugin = null;
        plugin = TownyEconomyHandler.plugin.getServer().getPluginManager().getPlugin("iConomy");
        if (plugin != null && plugin.getDescription().getVersion().matches("5.01")) {
            TownyEconomyHandler.setVersion(String.format("%s v%s", "iConomy", plugin.getDescription().getVersion()));
            Type = EcoType.ICO5;
            return true;
        }
        plugin = TownyEconomyHandler.plugin.getServer().getPluginManager().getPlugin("Register");
        if (plugin != null) {
            TownyEconomyHandler.setVersion(String.format("%s v%s", "Register", plugin.getDescription().getVersion()));
            Type = EcoType.REGISTER;
            return true;
        }
        try {
            RegisteredServiceProvider registeredServiceProvider = TownyEconomyHandler.plugin.getServer().getServicesManager().getRegistration(Economy.class);
            if (registeredServiceProvider != null) {
                vaultEconomy = (Economy)registeredServiceProvider.getProvider();
                TownyEconomyHandler.setVersion(String.format("%s v%s", "Vault", registeredServiceProvider.getPlugin().getDescription().getVersion()));
                Type = EcoType.VAULT;
                return true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return false;
    }

    private static Object getEconomyAccount(String string) {
        switch (Type) {
            case ICO5: {
                return iConomy.getAccount((String)string);
            }
            case REGISTER: {
                if (!Methods.getMethod().hasAccount(string)) {
                    Methods.getMethod().createAccount(string);
                }
                return Methods.getMethod().getAccount(string);
            }
        }
        return null;
    }

    public static void removeAccount(String string) {
        try {
            switch (Type) {
                case ICO5: {
                    iConomy.getAccount((String)string).remove();
                    break;
                }
                case REGISTER: {
                    Method.MethodAccount methodAccount = (Method.MethodAccount)TownyEconomyHandler.getEconomyAccount(string);
                    methodAccount.remove();
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public static double getBalance(String string, World world) {
        switch (Type) {
            case ICO5: {
                Account account = (Account)TownyEconomyHandler.getEconomyAccount(string);
                if (account == null) break;
                return account.getHoldings().balance();
            }
            case REGISTER: {
                Method.MethodAccount methodAccount = (Method.MethodAccount)TownyEconomyHandler.getEconomyAccount(string);
                if (methodAccount == null) break;
                return methodAccount.balance(world);
            }
            case VAULT: {
                if (!vaultEconomy.hasAccount(string)) {
                    vaultEconomy.createPlayerAccount(string);
                }
                return vaultEconomy.getBalance(string);
            }
        }
        return 0.0;
    }

    public static boolean hasEnough(String string, Double d, World world) {
        return TownyEconomyHandler.getBalance(string, world) >= d;
    }

    public static boolean subtract(String string, Double d, World world) {
        switch (Type) {
            case ICO5: {
                Account account = (Account)TownyEconomyHandler.getEconomyAccount(string);
                if (account == null) break;
                account.getHoldings().subtract(d.doubleValue());
                return true;
            }
            case REGISTER: {
                Method.MethodAccount methodAccount = (Method.MethodAccount)TownyEconomyHandler.getEconomyAccount(string);
                if (methodAccount == null) break;
                return methodAccount.subtract(d.doubleValue(), world);
            }
            case VAULT: {
                if (!vaultEconomy.hasAccount(string)) {
                    vaultEconomy.createPlayerAccount(string);
                }
                return TownyEconomyHandler.vaultEconomy.withdrawPlayer((String)string, (double)d.doubleValue()).type == EconomyResponse.ResponseType.SUCCESS;
            }
        }
        return false;
    }

    public static boolean add(String string, Double d, World world) {
        switch (Type) {
            case ICO5: {
                Account account = (Account)TownyEconomyHandler.getEconomyAccount(string);
                if (account == null) break;
                account.getHoldings().add(d.doubleValue());
                return true;
            }
            case REGISTER: {
                Method.MethodAccount methodAccount = (Method.MethodAccount)TownyEconomyHandler.getEconomyAccount(string);
                if (methodAccount == null) break;
                return methodAccount.add(d.doubleValue(), world);
            }
            case VAULT: {
                if (!vaultEconomy.hasAccount(string)) {
                    vaultEconomy.createPlayerAccount(string);
                }
                return TownyEconomyHandler.vaultEconomy.depositPlayer((String)string, (double)d.doubleValue()).type == EconomyResponse.ResponseType.SUCCESS;
            }
        }
        return false;
    }

    public static boolean setBalance(String string, Double d, World world) {
        switch (Type) {
            case ICO5: {
                Account account = (Account)TownyEconomyHandler.getEconomyAccount(string);
                if (account == null) break;
                account.getHoldings().set(d.doubleValue());
                return true;
            }
            case REGISTER: {
                Method.MethodAccount methodAccount = (Method.MethodAccount)TownyEconomyHandler.getEconomyAccount(string);
                if (methodAccount == null) break;
                return methodAccount.set(d.doubleValue(), world);
            }
            case VAULT: {
                if (!vaultEconomy.hasAccount(string)) {
                    vaultEconomy.createPlayerAccount(string);
                }
                return TownyEconomyHandler.vaultEconomy.depositPlayer((String)string, (double)(d.doubleValue() - TownyEconomyHandler.vaultEconomy.getBalance((String)string))).type == EconomyResponse.ResponseType.SUCCESS;
            }
        }
        return false;
    }

    public static String getFormattedBalance(double d) {
        try {
            switch (Type) {
                case ICO5: {
                    return iConomy.format((double)d);
                }
                case REGISTER: {
                    return Methods.getMethod().format(d);
                }
                case VAULT: {
                    return vaultEconomy.format(d);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.format("%.2f", d);
    }

    public static enum EcoType {
        NONE,
        ICO5,
        REGISTER,
        VAULT;

    }
}

