/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.util.StringMgmt;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class TownyFormatter {
    public static final SimpleDateFormat lastOnlineFormat = new SimpleDateFormat("MMMMM dd '@' HH:mm");
    public static final SimpleDateFormat registeredFormat = new SimpleDateFormat("MMM d yyyy");
    public static final String residentListPrefixFormat = "%3$s%1$s %4$s[%2$d]%3$s:%5$s ";

    public static void initialize(Towny towny) {
    }

    public static List<String> getFormattedOnlineResidents(String string, ResidentList residentList, Player player) {
        List<Resident> list = TownyUniverse.getOnlineResidentsViewable(player, residentList);
        return TownyFormatter.getFormattedResidents(string, list);
    }

    public static List<String> getFormattedResidents(String string, List<Resident> list) {
        return ChatTools.listArr(TownyFormatter.getFormattedNames(list), String.format(residentListPrefixFormat, string, list.size(), "\u00a72", "\u00a7a", "\u00a7f"));
    }

    public static String[] getFormattedNames(List<Resident> list) {
        return TownyFormatter.getFormattedNames(list.toArray(new Resident[0]));
    }

    public static String getTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh:mm aa");
        return simpleDateFormat.format(System.currentTimeMillis());
    }

    public static List<String> getStatus(TownBlock townBlock) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Town town = townBlock.getTown();
            TownyWorld townyWorld = townBlock.getWorld();
            TownBlockOwner townBlockOwner = townBlock.hasResident() ? townBlock.getResident() : townBlock.getTown();
            arrayList.add(ChatTools.formatTitle(TownyFormatter.getFormattedName(townBlockOwner) + (BukkitTools.isOnline(townBlockOwner.getName()) ? "\u00a7a (Online)" : "")));
            arrayList.add("\u00a72 Perm: " + (townBlockOwner instanceof Resident ? townBlock.getPermissions().getColourString() : townBlock.getPermissions().getColourString().replace("f", "r")));
            arrayList.add("\u00a72PvP: " + (town.isPVP() || townyWorld.isForcePVP() || townBlock.getPermissions().pvp ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Explosions: " + (townyWorld.isForceExpl() || townBlock.getPermissions().explosion ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Firespread: " + (town.isFire() || townyWorld.isForceFire() || townBlock.getPermissions().fire ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Mob Spawns: " + (town.hasMobs() || townyWorld.isForceTownMobs() || townBlock.getPermissions().mobs ? "\u00a74ON" : "\u00a7aOFF"));
        }
        catch (NotRegisteredException notRegisteredException) {
            arrayList.add("Error: " + notRegisteredException.getMessage());
        }
        return arrayList;
    }

    public static List<String> getStatus(Resident resident, Player player) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ChatTools.formatTitle(TownyFormatter.getFormattedName(resident) + (BukkitTools.isOnline(resident.getName()) && player != null && player.canSee(BukkitTools.getPlayer(resident.getName())) ? "\u00a7a (Online)" : "")));
        arrayList.add("\u00a72Registered: \u00a7a" + registeredFormat.format(resident.getRegistered()) + "\u00a78" + " | " + "\u00a72" + "Last Online: " + "\u00a7a" + lastOnlineFormat.format(resident.getLastOnline()));
        arrayList.add("\u00a72Owner of: \u00a7a" + resident.getTownBlocks().size() + " plots");
        arrayList.add("\u00a72    Perm: " + resident.getPermissions().getColourString());
        arrayList.add("\u00a72PVP: " + (resident.getPermissions().pvp ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Explosions: " + (resident.getPermissions().explosion ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Firespread: " + (resident.getPermissions().fire ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Mob Spawns: " + (resident.getPermissions().mobs ? "\u00a74ON" : "\u00a7aOFF"));
        if (TownySettings.isUsingEconomy() && TownyEconomyHandler.isActive()) {
            arrayList.add("\u00a72Bank: \u00a7a" + resident.getHoldingFormattedBalance());
        }
        String string = "\u00a72Town: \u00a7a";
        if (!resident.hasTown()) {
            string = string + "None";
        } else {
            try {
                string = string + TownyFormatter.getFormattedName(resident.getTown());
            }
            catch (TownyException townyException) {
                string = string + "Error: " + townyException.getMessage();
            }
        }
        arrayList.add(string);
        List<Resident> list = resident.getFriends();
        arrayList.addAll(TownyFormatter.getFormattedResidents("Friends", list));
        return arrayList;
    }

    public static List<String> getRanks(Town town) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = TownyFormatter.getFormattedName(town);
        string = string + "\u00a73 Rank List";
        arrayList.add(ChatTools.formatTitle(string));
        arrayList.add("\u00a72Mayor: \u00a7a" + TownyFormatter.getFormattedName(town.getMayor()));
        List<Resident> list = town.getResidents();
        List<String> list2 = TownyPerms.getTownRanks();
        ArrayList<Resident> arrayList2 = new ArrayList<Resident>();
        for (String string2 : list2) {
            for (Resident resident : list) {
                if (resident.getTownRanks() == null || !resident.getTownRanks().contains(string2)) continue;
                arrayList2.add(resident);
            }
            arrayList.addAll(TownyFormatter.getFormattedResidents(string2, arrayList2));
            arrayList2.clear();
        }
        return arrayList;
    }

    public static List<String> getStatus(Town town) {
        ArrayList<String> arrayList = new ArrayList<String>();
        TownyWorld townyWorld = town.getWorld();
        String string = TownyFormatter.getFormattedName(town);
        string = string + (!town.isAdminDisabledPVP() && (town.isPVP() || town.getWorld().isForcePVP()) ? "\u00a74 (PvP)" : "");
        string = string + (town.isOpen() ? "\u00a7b (Open)" : "");
        arrayList.add(ChatTools.formatTitle(string));
        try {
            arrayList.add("\u00a72Board: \u00a7a" + town.getTownBoard());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            arrayList.add("\u00a72Town Size: \u00a7a" + town.getTownBlocks().size() + " / " + TownySettings.getMaxTownBlocks(town) + (TownySettings.isSellingBonusBlocks() ? "\u00a7b [Bought: " + town.getPurchasedBlocks() + "/" + TownySettings.getMaxPurchedBlocks() + "]" : "") + (town.getBonusBlocks() > 0 ? "\u00a7b [Bonus: " + town.getBonusBlocks() + "]" : "") + (TownySettings.getNationBonusBlocks(town) > 0 ? "\u00a7b [NationBonus: " + TownySettings.getNationBonusBlocks(town) + "]" : "") + (town.isPublic() ? "\u00a77 [Home: " + (town.hasHomeBlock() ? town.getHomeBlock().getCoord().toString() : "None") + "]" : ""));
        }
        catch (TownyException townyException) {
            // empty catch block
        }
        if (town.hasOutpostSpawn()) {
            arrayList.add("\u00a72Outposts: \u00a7a" + town.getMaxOutpostSpawn());
        }
        arrayList.add("\u00a72Permissions: " + town.getPermissions().getColourString().replace("f", "r"));
        arrayList.add("\u00a72Explosions: " + (town.isBANG() || townyWorld.isForceExpl() ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Firespread: " + (town.isFire() || townyWorld.isForceFire() ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Mob Spawns: " + (town.hasMobs() || townyWorld.isForceTownMobs() ? "\u00a74ON" : "\u00a7aOFF"));
        String string2 = "";
        if (TownySettings.isUsingEconomy()) {
            if (TownyEconomyHandler.isActive()) {
                string2 = "\u00a72Bank: \u00a7a" + town.getHoldingFormattedBalance();
                if (town.hasUpkeep()) {
                    string2 = string2 + "\u00a78 | \u00a72Daily upkeep: \u00a74" + TownySettings.getTownUpkeepCost(town);
                }
                string2 = string2 + "\u00a78 | \u00a72Tax: \u00a74" + town.getTaxes() + (town.isTaxPercentage() ? "%" : "");
            }
            arrayList.add(string2);
        }
        arrayList.add("\u00a72Mayor: \u00a7a" + TownyFormatter.getFormattedName(town.getMayor()));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        List<Resident> list = town.getResidents();
        List<String> list2 = TownyPerms.getTownRanks();
        ArrayList<Resident> arrayList3 = new ArrayList<Resident>();
        for (String stringArray2 : list2) {
            for (Resident resident : list) {
                if (resident.getTownRanks() == null || !resident.getTownRanks().contains(stringArray2)) continue;
                arrayList3.add(resident);
            }
            arrayList2.addAll(TownyFormatter.getFormattedResidents(stringArray2, arrayList3));
            arrayList3.clear();
        }
        arrayList.addAll(arrayList2);
        try {
            arrayList.add("\u00a72Nation: \u00a7a" + TownyFormatter.getFormattedName(town.getNation()));
        }
        catch (TownyException townyException) {
            // empty catch block
        }
        String[] stringArray = TownyFormatter.getFormattedNames(town.getResidents().toArray(new Resident[0]));
        if (stringArray.length > 34) {
            String[] stringArray2 = stringArray;
            stringArray = new String[36];
            System.arraycopy(stringArray2, 0, stringArray, 0, 35);
            stringArray[35] = "and more...";
        }
        arrayList.addAll(ChatTools.listArr(stringArray, "\u00a72Residents \u00a7a[" + town.getNumResidents() + "]" + "\u00a72" + ":" + "\u00a7f" + " "));
        return arrayList;
    }

    public static List<String> getStatus(Nation nation) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ChatTools.formatTitle(TownyFormatter.getFormattedName(nation)));
        String string = "";
        if (TownySettings.isUsingEconomy() && TownyEconomyHandler.isActive()) {
            string = "\u00a72Bank: \u00a7a" + nation.getHoldingFormattedBalance();
            if (TownySettings.getNationUpkeepCost(nation) > 0.0) {
                string = string + "\u00a78 | \u00a72Daily upkeep: \u00a74" + TownySettings.getNationUpkeepCost(nation);
            }
        }
        if (nation.isNeutral()) {
            if (string.length() > 0) {
                string = string + "\u00a78 | ";
            }
            string = string + "\u00a77Neutral";
        }
        if (string.length() > 0) {
            arrayList.add(string);
        }
        if (nation.getNumTowns() > 0 && nation.hasCapital() && nation.getCapital().hasMayor()) {
            arrayList.add("\u00a72King: \u00a7a" + TownyFormatter.getFormattedName(nation.getCapital().getMayor()) + "\u00a72" + "  NationTax: " + "\u00a74" + nation.getTaxes());
        }
        if (nation.getAssistants().size() > 0) {
            arrayList.addAll(ChatTools.listArr(TownyFormatter.getFormattedNames(nation.getAssistants().toArray(new Resident[0])), "\u00a72Assistants:\u00a7f "));
        }
        arrayList.addAll(ChatTools.listArr(TownyFormatter.getFormattedNames(nation.getTowns().toArray(new Town[0])), "\u00a72Towns \u00a7a[" + nation.getNumTowns() + "]" + "\u00a72" + ":" + "\u00a7f" + " "));
        arrayList.addAll(ChatTools.listArr(TownyFormatter.getFormattedNames(nation.getAllies().toArray(new Nation[0])), "\u00a72Allies \u00a7a[" + nation.getAllies().size() + "]" + "\u00a72" + ":" + "\u00a7f" + " "));
        arrayList.addAll(ChatTools.listArr(TownyFormatter.getFormattedNames(nation.getEnemies().toArray(new Nation[0])), "\u00a72Enemies \u00a7a[" + nation.getEnemies().size() + "]" + "\u00a72" + ":" + "\u00a7f" + " "));
        return arrayList;
    }

    public static List<String> getStatus(TownyWorld townyWorld) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = TownyFormatter.getFormattedName(townyWorld);
        string = string + (townyWorld.isPVP() || townyWorld.isForcePVP() ? "\u00a74 (PvP)" : "");
        string = string + (townyWorld.isClaimable() ? "\u00a7a Claimable" : "\u00a7c NoClaims");
        arrayList.add(ChatTools.formatTitle(string));
        if (!townyWorld.isUsingTowny()) {
            arrayList.add(TownySettings.getLangString("msg_set_use_towny_off"));
        } else {
            arrayList.add("\u00a72ForcePvP: " + (townyWorld.isForcePVP() ? "\u00a7cOn" : "\u00a7aOff") + "\u00a78" + " | " + "\u00a72" + "Fire: " + (townyWorld.isFire() ? "\u00a7cOn" : "\u00a7aOff") + "\u00a78" + " | " + "\u00a72" + "Force Fire: " + (townyWorld.isForceFire() ? "\u00a7cForced" : "\u00a7aAdjustable"));
            arrayList.add("\u00a72Explosions: " + (townyWorld.isExpl() ? "\u00a7cOn:" : "\u00a7aOff") + "\u00a78" + " | " + "\u00a72" + " Force explosion: " + (townyWorld.isForceExpl() ? "\u00a7cForced" : "\u00a7aAdjustable"));
            arrayList.add("\u00a72World Mobs: " + (townyWorld.hasWorldMobs() ? "\u00a7cOn" : "\u00a7aOff") + "\u00a78" + " | " + "\u00a72" + "Force TownMobs: " + (townyWorld.isForceTownMobs() ? "\u00a7cForced" : "\u00a7aAdjustable"));
            arrayList.add("\u00a72Unclaim Revert: " + (townyWorld.isUsingPlotManagementRevert() ? "\u00a7aOn" : "\u00a7coff") + "\u00a78" + " | " + "\u00a72" + "Explosion Revert: " + (townyWorld.isUsingPlotManagementWildRevert() ? "\u00a7aOn" : "\u00a7coff"));
            arrayList.add("\u00a72" + townyWorld.getUnclaimedZoneName() + ":");
            arrayList.add("    " + (townyWorld.getUnclaimedZoneBuild() != false ? "\u00a7a" : "\u00a7c") + "Build" + "\u00a78" + ", " + (townyWorld.getUnclaimedZoneDestroy() != false ? "\u00a7a" : "\u00a7c") + "Destroy" + "\u00a78" + ", " + (townyWorld.getUnclaimedZoneSwitch() != false ? "\u00a7a" : "\u00a7c") + "Switch" + "\u00a78" + ", " + (townyWorld.getUnclaimedZoneItemUse() != false ? "\u00a7a" : "\u00a7c") + "ItemUse");
            arrayList.add("    \u00a72Ignored Blocks:\u00a7a " + StringMgmt.join(townyWorld.getUnclaimedZoneIgnoreIds(), ", "));
        }
        return arrayList;
    }

    public static List<String> getTaxStatus(Resident resident) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Town town = null;
        double d = 0.0;
        arrayList.add(ChatTools.formatTitle(TownyFormatter.getFormattedName(resident) + (BukkitTools.isOnline(resident.getName()) ? "\u00a7a (Online)" : "")));
        if (resident.hasTown()) {
            try {
                town = resident.getTown();
                arrayList.add("\u00a72Owner of: \u00a7a" + resident.getTownBlocks().size() + " plots");
                if (resident.isMayor() || town.hasAssistant(resident)) {
                    arrayList.add("\u00a72Staff are exempt from paying town taxes.");
                } else if (town.isTaxPercentage()) {
                    arrayList.add("\u00a72Town Tax: \u00a7a" + resident.getHoldingBalance() * town.getTaxes() / 100.0);
                } else {
                    arrayList.add("\u00a72Town Tax: \u00a7a" + town.getTaxes());
                    if (resident.getTownBlocks().size() > 0) {
                        for (TownBlock townBlock : new ArrayList<TownBlock>(resident.getTownBlocks())) {
                            d += townBlock.getType().getTax(townBlock.getTown());
                        }
                        arrayList.add("\u00a72Total Plot Taxes: \u00a7a" + d);
                    }
                    arrayList.add("\u00a72Total Tax to pay: \u00a7a" + (town.getTaxes() + d));
                }
            }
            catch (NotRegisteredException notRegisteredException) {
            }
            catch (EconomyException economyException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static String getNamePrefix(Resident resident) {
        if (resident == null) {
            return "";
        }
        if (resident.isKing()) {
            return TownySettings.getKingPrefix(resident);
        }
        if (resident.isMayor()) {
            return TownySettings.getMayorPrefix(resident);
        }
        return "";
    }

    public static String getNamePostfix(Resident resident) {
        if (resident == null) {
            return "";
        }
        if (resident.isKing()) {
            return TownySettings.getKingPostfix(resident);
        }
        if (resident.isMayor()) {
            return TownySettings.getMayorPostfix(resident);
        }
        return "";
    }

    public static String getFormattedName(TownyObject townyObject) {
        if (townyObject == null) {
            return "Null";
        }
        if (townyObject instanceof Resident) {
            return TownyFormatter.getFormattedResidentName((Resident)townyObject);
        }
        if (townyObject instanceof Town) {
            return TownyFormatter.getFormattedTownName((Town)townyObject);
        }
        if (townyObject instanceof Nation) {
            return TownyFormatter.getFormattedNationName((Nation)townyObject);
        }
        return townyObject.getName().replaceAll("_", " ");
    }

    public static String getFormattedResidentName(Resident resident) {
        if (resident == null) {
            return "null";
        }
        if (resident.isKing()) {
            return TownySettings.getKingPrefix(resident) + resident.getName().replaceAll("_", " ") + TownySettings.getKingPostfix(resident);
        }
        if (resident.isMayor()) {
            return TownySettings.getMayorPrefix(resident) + resident.getName().replaceAll("_", " ") + TownySettings.getMayorPostfix(resident);
        }
        return resident.getName().replaceAll("_", " ");
    }

    public static String getFormattedTownName(Town town) {
        if (town.isCapital()) {
            return TownySettings.getCapitalPrefix(town) + town.getName().replaceAll("_", " ") + TownySettings.getCapitalPostfix(town);
        }
        return TownySettings.getTownPrefix(town) + town.getName().replaceAll("_", " ") + TownySettings.getTownPostfix(town);
    }

    public static String getFormattedNationName(Nation nation) {
        return TownySettings.getNationPrefix(nation) + nation.getName().replaceAll("_", " ") + TownySettings.getNationPostfix(nation);
    }

    public static String[] getFormattedNames(Resident[] residentArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Resident resident : residentArray) {
            arrayList.add(TownyFormatter.getFormattedName(resident));
        }
        return arrayList.toArray(new String[0]);
    }

    public static String[] getFormattedNames(Town[] townArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Town town : townArray) {
            arrayList.add(TownyFormatter.getFormattedName(town));
        }
        return arrayList.toArray(new String[0]);
    }

    public static String[] getFormattedNames(Nation[] nationArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Nation nation : nationArray) {
            arrayList.add(TownyFormatter.getFormattedName(nation));
        }
        return arrayList.toArray(new String[0]);
    }
}

