/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.TownyObservableType;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.tasks.DailyTimerTask;
import com.palmergames.bukkit.towny.tasks.HealthRegenTimerTask;
import com.palmergames.bukkit.towny.tasks.MobRemovalTimerTask;
import com.palmergames.bukkit.towny.tasks.RepeatingTimerTask;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.TimeMgmt;
import com.palmergames.util.TimeTools;
import java.util.Calendar;
import java.util.TimeZone;

public class TownyTimerHandler {
    private static Towny plugin;
    private static TownyUniverse universe;
    private static int townyRepeatingTask;
    private static int dailyTask;
    private static int mobRemoveTask;
    private static int healthRegenTask;
    private static int teleportWarmupTask;

    public static void initialize(Towny towny) {
        plugin = towny;
        universe = towny.getTownyUniverse();
    }

    public static void newDay() {
        if (!TownyTimerHandler.isDailyTimerRunning()) {
            TownyTimerHandler.toggleDailyTimer(true);
        }
        if (BukkitTools.scheduleAsyncDelayedTask(new DailyTimerTask(plugin), 0L) == -1) {
            TownyMessaging.sendErrorMsg("Could not schedule newDay.");
        }
        universe.setChangedNotify(TownyObservableType.NEW_DAY);
    }

    public static void toggleTownyRepeatingTimer(boolean bl) {
        if (bl && !TownyTimerHandler.isTownyRepeatingTaskRunning()) {
            townyRepeatingTask = BukkitTools.scheduleSyncRepeatingTask(new RepeatingTimerTask(plugin), 0L, TimeTools.convertToTicks(1L));
            if (townyRepeatingTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule Towny Timer Task.");
            }
        } else if (!bl && TownyTimerHandler.isTownyRepeatingTaskRunning()) {
            BukkitTools.getScheduler().cancelTask(townyRepeatingTask);
            townyRepeatingTask = -1;
        }
        universe.setChangedNotify(TownyObservableType.TOGGLE_REPEATING_TIMER);
    }

    public static void toggleMobRemoval(boolean bl) {
        if (bl && !TownyTimerHandler.isMobRemovalRunning()) {
            mobRemoveTask = BukkitTools.scheduleSyncRepeatingTask(new MobRemovalTimerTask(plugin, BukkitTools.getServer()), 0L, TimeTools.convertToTicks(TownySettings.getMobRemovalSpeed()));
            if (mobRemoveTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule mob removal loop.");
            }
        } else if (!bl && TownyTimerHandler.isMobRemovalRunning()) {
            BukkitTools.getScheduler().cancelTask(mobRemoveTask);
            mobRemoveTask = -1;
        }
        universe.setChangedNotify(TownyObservableType.TOGGLE_MOB_REMOVAL);
    }

    public static void toggleDailyTimer(boolean bl) {
        if (bl && !TownyTimerHandler.isDailyTimerRunning()) {
            long l = TownyTimerHandler.townyTime();
            TownyMessaging.sendMsg("Time until a New Day: " + TimeMgmt.formatCountdownTime(l));
            dailyTask = BukkitTools.scheduleAsyncRepeatingTask(new DailyTimerTask(plugin), TimeTools.convertToTicks(l), TimeTools.convertToTicks(TownySettings.getDayInterval()));
            if (dailyTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule new day loop.");
            }
        } else if (!bl && TownyTimerHandler.isDailyTimerRunning()) {
            BukkitTools.getScheduler().cancelTask(dailyTask);
            dailyTask = -1;
        }
        universe.setChangedNotify(TownyObservableType.TOGGLE_DAILY_TIMER);
    }

    public static void toggleHealthRegen(boolean bl) {
        if (bl && !TownyTimerHandler.isHealthRegenRunning()) {
            healthRegenTask = BukkitTools.scheduleSyncRepeatingTask(new HealthRegenTimerTask(plugin, BukkitTools.getServer()), 0L, TimeTools.convertToTicks(TownySettings.getHealthRegenSpeed()));
            if (healthRegenTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule health regen loop.");
            }
        } else if (!bl && TownyTimerHandler.isHealthRegenRunning()) {
            BukkitTools.getScheduler().cancelTask(healthRegenTask);
            healthRegenTask = -1;
        }
        universe.setChangedNotify(TownyObservableType.TOGGLE_HEALTH_REGEN);
    }

    public static void toggleTeleportWarmup(boolean bl) {
        if (bl && !TownyTimerHandler.isTeleportWarmupRunning()) {
            teleportWarmupTask = BukkitTools.scheduleSyncRepeatingTask(new TeleportWarmupTimerTask(plugin), 0L, 20L);
            if (teleportWarmupTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule teleport warmup loop.");
            }
        } else if (!bl && TownyTimerHandler.isTeleportWarmupRunning()) {
            BukkitTools.getScheduler().cancelTask(teleportWarmupTask);
            teleportWarmupTask = -1;
        }
        universe.setChangedNotify(TownyObservableType.TOGGLE_TELEPORT_WARMUP);
    }

    public static boolean isTownyRepeatingTaskRunning() {
        return townyRepeatingTask != -1;
    }

    public static boolean isMobRemovalRunning() {
        return mobRemoveTask != -1;
    }

    public static boolean isDailyTimerRunning() {
        return dailyTask != -1;
    }

    public static boolean isHealthRegenRunning() {
        return healthRegenTask != -1;
    }

    public static boolean isTeleportWarmupRunning() {
        return teleportWarmupTask != -1;
    }

    public static Long townyTime() {
        Long l = TownySettings.getDayInterval();
        Calendar calendar = Calendar.getInstance();
        TimeZone timeZone = calendar.getTimeZone();
        Long l2 = System.currentTimeMillis();
        Integer n = timeZone.getOffset(l2) / 1000;
        return (l + (TownySettings.getNewDayTime() - l2 / 1000L % l - (long)n.intValue())) % l;
    }

    static {
        townyRepeatingTask = -1;
        dailyTask = -1;
        mobRemoveTask = -1;
        healthRegenTask = -1;
        teleportWarmupTask = -1;
    }
}

