/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import ca.xshade.bukkit.questioner.Questioner;
import ca.xshade.questionmanager.Option;
import ca.xshade.questionmanager.Question;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.questioner.JoinNationTask;
import com.palmergames.bukkit.towny.questioner.ResidentNationQuestionTask;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.InvalidNameException;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NationCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> nation_help;
    private static final List<String> king_help;

    public NationCommand(Towny towny) {
        plugin = towny;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            System.out.println("[PLAYER_COMMAND] " + player.getName() + ": /" + string + " " + StringMgmt.join(stringArray));
            if (stringArray == null) {
                for (String string2 : nation_help) {
                    player.sendMessage(string2);
                }
                this.parseNationCommand(player, stringArray);
            } else {
                this.parseNationCommand(player, stringArray);
            }
        } else {
            for (String string3 : nation_help) {
                commandSender.sendMessage(Colors.strip(string3));
            }
        }
        return true;
    }

    public void parseNationCommand(Player player, String[] stringArray) {
        block51: {
            String string = "/nation";
            try {
                if (stringArray.length == 0) {
                    try {
                        Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                        Town town = resident.getTown();
                        Nation nation = town.getNation();
                        TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(nation));
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_dont_belong_nation"));
                    }
                    break block51;
                }
                if (stringArray[0].equalsIgnoreCase("?")) {
                    for (String string2 : nation_help) {
                        player.sendMessage(string2);
                    }
                    break block51;
                }
                if (stringArray[0].equalsIgnoreCase("list")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_LIST.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.listNations(player);
                    break block51;
                }
                if (stringArray[0].equalsIgnoreCase("new")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_NEW.getNode())) {
                        throw new TownyException(TownySettings.getNotPermToNewNationLine());
                    }
                    if (stringArray.length == 1) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_specify_nation_name"));
                    } else if (stringArray.length == 2) {
                        Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                        if (!resident.isMayor() && !resident.getTown().hasAssistant(resident)) {
                            throw new TownyException(TownySettings.getLangString("msg_peasant_right"));
                        }
                        this.newNation(player, stringArray[1], resident.getTown().getName());
                    } else {
                        this.newNation(player, stringArray[1], stringArray[2]);
                    }
                    break block51;
                }
                if (stringArray[0].equalsIgnoreCase("leave")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_LEAVE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.nationLeave(player);
                    break block51;
                }
                if (stringArray[0].equalsIgnoreCase("withdraw")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_WITHDRAW.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (stringArray.length == 2) {
                        try {
                            this.nationWithdraw(player, Integer.parseInt(stringArray[1].trim()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
                        }
                    } else {
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_must_specify_amnt"), string));
                    }
                    break block51;
                }
                if (stringArray[0].equalsIgnoreCase("deposit")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_DEPOSIT.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (stringArray.length == 2) {
                        try {
                            this.nationDeposit(player, Integer.parseInt(stringArray[1].trim()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
                        }
                    } else {
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_must_specify_amnt"), string + " deposit"));
                    }
                    break block51;
                }
                String[] stringArray2 = StringMgmt.remFirstArg(stringArray);
                if (stringArray[0].equalsIgnoreCase("rank")) {
                    this.nationRank(player, stringArray2);
                    break block51;
                }
                if (stringArray[0].equalsIgnoreCase("king")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_KING.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.nationKing(player, stringArray2);
                    break block51;
                }
                if (stringArray[0].equalsIgnoreCase("add")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ADD.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.nationAdd(player, stringArray2);
                    break block51;
                }
                if (stringArray[0].equalsIgnoreCase("kick")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_DEPOSIT.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.nationKick(player, stringArray2);
                    break block51;
                }
                if (stringArray[0].equalsIgnoreCase("set")) {
                    this.nationSet(player, stringArray2);
                    break block51;
                }
                if (stringArray[0].equalsIgnoreCase("toggle")) {
                    this.nationToggle(player, stringArray2);
                    break block51;
                }
                if (stringArray[0].equalsIgnoreCase("ally")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.nationAlly(player, stringArray2);
                    break block51;
                }
                if (stringArray[0].equalsIgnoreCase("enemy")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ENEMY.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.nationEnemy(player, stringArray2);
                    break block51;
                }
                if (stringArray[0].equalsIgnoreCase("delete")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_DELETE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.nationDelete(player, stringArray2);
                    break block51;
                }
                if (stringArray[0].equalsIgnoreCase("online")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ONLINE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    try {
                        Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                        Town town = resident.getTown();
                        Nation nation = town.getNation();
                        TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOnlineResidents(TownySettings.getLangString("msg_nation_online"), nation, player));
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_dont_belong_nation"));
                    }
                    break block51;
                }
                try {
                    Nation nation = TownyUniverse.getDataSource().getNation(stringArray[0]);
                    TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(nation));
                }
                catch (NotRegisteredException notRegisteredException) {
                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_registered_1"), stringArray[0]));
                }
            }
            catch (Exception exception) {
                TownyMessaging.sendErrorMsg((Object)player, exception.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void nationRank(Player player, String[] stringArray) {
        Resident resident;
        if (stringArray.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/nation rank"));
            player.sendMessage(ChatTools.formatCommand("", "/nation rank", "add/remove [resident] rank", ""));
            return;
        }
        Town town = null;
        Town town2 = null;
        if (stringArray.length < 3) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /town rank add/remove [resident] [rank]");
            return;
        }
        try {
            Resident resident2 = TownyUniverse.getDataSource().getResident(player.getName());
            resident = TownyUniverse.getDataSource().getResident(stringArray[1]);
            town = resident2.getTown();
            town2 = resident.getTown();
            if (town.getNation() != town2.getNation()) {
                throw new TownyException("This resident is not a member of your Town!");
            }
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            return;
        }
        String string = stringArray[2].toLowerCase();
        if (!TownyPerms.getNationRanks().contains(string)) {
            TownyMessaging.sendErrorMsg((Object)player, "Unknown rank '" + string + "'. Permissible ranks are :- " + StringMgmt.join(TownyPerms.getNationRanks(), ",") + ".");
            return;
        }
        if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(string))) {
            TownyMessaging.sendErrorMsg((Object)player, "You do not have permission to modify this rank.");
            return;
        }
        if (stringArray[0].equalsIgnoreCase("add")) {
            try {
                if (!resident.addNationRank(string)) {
                    TownyMessaging.sendErrorMsg((Object)player, "That resident isn't a member of a town!");
                    return;
                }
                TownyMessaging.sendMsg(resident, "You have been granted the Nation rank of '" + string + "'.");
                TownyMessaging.sendMsg((Object)player, "You have granted the Nation rank of '" + string + "' to " + resident.getName() + ".");
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                TownyMessaging.sendMsg((Object)player, resident.getName() + " already holds this Nation rank.");
                return;
            }
        }
        if (!stringArray[0].equalsIgnoreCase("remove")) {
            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), stringArray[0]));
            return;
        }
        try {
            if (resident.removeNationRank(string)) {
                TownyMessaging.sendMsg(resident, "You have been demoted from the Nation rank of '" + string + "'.");
                TownyMessaging.sendMsg((Object)player, "You have removed the Nation rank of '" + string + "' from " + resident.getName() + ".");
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            TownyMessaging.sendMsg((Object)player, resident.getName() + " doesn't hold this Nation rank.");
            return;
        }
        TownyUniverse.getDataSource().saveResident(resident);
    }

    private void nationWithdraw(Player player, int n) {
        try {
            if (!TownySettings.geNationBankAllowWithdrawls()) {
                throw new TownyException(TownySettings.getLangString("msg_err_withdraw_disabled"));
            }
            if (n < 0) {
                throw new TownyException(TownySettings.getLangString("msg_err_negative_money"));
            }
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Nation nation = resident.getTown().getNation();
            nation.withdrawFromBank(resident, n);
            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_xx_withdrew_xx"), resident.getName(), n, "nation"));
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
        }
        catch (EconomyException economyException) {
            TownyMessaging.sendErrorMsg((Object)player, economyException.getMessage());
        }
    }

    private void nationDeposit(Player player, int n) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Nation nation = resident.getTown().getNation();
            double d = TownySettings.getNationBankCap();
            if (d > 0.0 && (double)n + nation.getHoldingBalance() > d) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_deposit_capped"), d));
            }
            if (n < 0) {
                throw new TownyException(TownySettings.getLangString("msg_err_negative_money"));
            }
            if (!resident.payTo(n, nation, "Nation Deposit")) {
                throw new TownyException(TownySettings.getLangString("msg_insuf_funds"));
            }
            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_xx_deposited_xx"), resident.getName(), n, "nation"));
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
        }
        catch (EconomyException economyException) {
            TownyMessaging.sendErrorMsg((Object)player, economyException.getMessage());
        }
    }

    public void listNations(Player player) {
        player.sendMessage(ChatTools.formatTitle(TownySettings.getLangString("nation_plu")));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Nation object : TownyUniverse.getDataSource().getNations()) {
            arrayList.add("\u00a7b" + object.getName() + "\u00a73" + " [" + object.getNumTowns() + "]" + "\u00a7f");
        }
        for (String string : ChatTools.list(arrayList)) {
            player.sendMessage(string);
        }
    }

    public void newNation(Player player, String string, String string2) {
        TownyUniverse townyUniverse = plugin.getTownyUniverse();
        try {
            String string3;
            Town town = TownyUniverse.getDataSource().getTown(string2);
            if (town.hasNation()) {
                throw new TownyException(TownySettings.getLangString("msg_err_already_nation"));
            }
            try {
                string3 = NameValidation.checkAndFilterName(string);
            }
            catch (InvalidNameException invalidNameException) {
                string3 = null;
            }
            if (string3 == null || TownyUniverse.getDataSource().hasNation(string3)) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_name"), string));
            }
            if (TownySettings.isUsingEconomy() && !town.pay(TownySettings.getNewNationPrice(), "New Nation Cost")) {
                throw new TownyException(TownySettings.getLangString("msg_no_funds_new_nation"));
            }
            this.newNation(townyUniverse, string, town);
            TownyMessaging.sendGlobalMessage(TownySettings.getNewNationMsg(player.getName(), string));
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
        }
        catch (EconomyException economyException) {
            TownyMessaging.sendErrorMsg((Object)player, economyException.getMessage());
        }
    }

    public Nation newNation(TownyUniverse townyUniverse, String string, Town town) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse.getDataSource().newNation(string);
        Nation nation = TownyUniverse.getDataSource().getNation(string);
        nation.addTown(town);
        nation.setCapital(town);
        if (TownySettings.isUsingEconomy()) {
            try {
                nation.setBalance(0.0, "Deleting Nation");
            }
            catch (EconomyException economyException) {
                economyException.printStackTrace();
            }
        }
        TownyUniverse.getDataSource().saveTown(town);
        TownyUniverse.getDataSource().saveNation(nation);
        TownyUniverse.getDataSource().saveNationList();
        return nation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void nationLeave(Player player) {
        Town town = null;
        Nation nation = null;
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            town = resident.getTown();
            nation = town.getNation();
            nation.removeTown(town);
            ArrayList<Resident> arrayList = new ArrayList<Resident>(town.getResidents());
            for (Resident resident2 : arrayList) {
                if (!resident2.hasTitle() && !resident2.hasSurname()) continue;
                resident2.setTitle("");
                resident2.setSurname("");
                TownyUniverse.getDataSource().saveResident(resident2);
            }
            TownyUniverse.getDataSource().saveNation(nation);
            TownyUniverse.getDataSource().saveNationList();
            TownyMessaging.sendNationMessage(nation, ChatTools.color(String.format(TownySettings.getLangString("msg_nation_town_left"), town.getName())));
            TownyMessaging.sendTownMessage(town, ChatTools.color(String.format(TownySettings.getLangString("msg_town_left_nation"), nation.getName())));
            TownyUniverse.getDataSource().saveTown(town);
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            TownyUniverse.getDataSource().saveTown(town);
            return;
        }
        catch (EmptyNationException emptyNationException) {
            TownyUniverse.getDataSource().removeNation(emptyNationException.getNation());
            TownyUniverse.getDataSource().saveNationList();
            TownyMessaging.sendGlobalMessage(ChatTools.color(String.format(TownySettings.getLangString("msg_del_nation"), emptyNationException.getNation().getName())));
            TownyUniverse.getDataSource().saveTown(town);
            {
                catch (Throwable throwable) {
                    TownyUniverse.getDataSource().saveTown(town);
                    throw throwable;
                }
            }
        }
    }

    public void nationDelete(Player player, String[] stringArray) {
        if (stringArray.length == 0) {
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                Town town = resident.getTown();
                Nation nation = town.getNation();
                TownyUniverse.getDataSource().removeNation(nation);
                TownyMessaging.sendGlobalMessage(TownySettings.getDelNationMsg(nation));
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                return;
            }
        }
        try {
            if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_NATION_DELETE.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_admin_only_delete_nation"));
            }
            Nation nation = TownyUniverse.getDataSource().getNation(stringArray[0]);
            TownyUniverse.getDataSource().removeNation(nation);
            TownyMessaging.sendGlobalMessage(TownySettings.getDelNationMsg(nation));
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            return;
        }
    }

    public void nationKing(Player player, String[] stringArray) {
        if (stringArray.length == 0 || stringArray[0].equalsIgnoreCase("?")) {
            for (String string : king_help) {
                player.sendMessage(string);
            }
        }
    }

    public void nationAdd(Player player, String[] stringArray) {
        Nation nation;
        if (stringArray.length < 1) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation add [names]");
            return;
        }
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            nation = resident.getTown().getNation();
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            return;
        }
        NationCommand.nationAdd(player, nation, TownyUniverse.getDataSource().getTowns(stringArray));
    }

    public static void nationAdd(Player player, Nation nation, List<Town> list) {
        ArrayList<Town> arrayList = new ArrayList<Town>();
        for (Town object : list) {
            try {
                NationCommand.nationInviteTown(player, nation, object);
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                arrayList.add(object);
            }
        }
        for (Town town : arrayList) {
            list.remove(town);
        }
        if (list.size() > 0) {
            Object object = "";
            for (Town town : list) {
                object = (String)object + town.getName() + ", ";
            }
            object = ((String)object).substring(0, ((String)object).length() - 2);
            object = String.format(TownySettings.getLangString("msg_invited_join_nation"), player.getName(), object);
            TownyMessaging.sendNationMessage(nation, ChatTools.color((String)object));
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    private static void nationInviteTown(Player player, Nation nation, Town town) throws AlreadyRegisteredException {
        Plugin plugin = NationCommand.plugin.getServer().getPluginManager().getPlugin("Questioner");
        Resident resident = town.getMayor();
        if (TownySettings.isUsingQuestioner() && plugin != null && plugin instanceof Questioner && plugin.isEnabled()) {
            Questioner questioner = (Questioner)plugin;
            questioner.loadClasses();
            ArrayList<Option> arrayList = new ArrayList<Option>();
            arrayList.add(new Option(TownySettings.questionerAccept(), (Runnable)((Object)new JoinNationTask(resident, nation))));
            arrayList.add(new Option(TownySettings.questionerDeny(), (Runnable)((Object)new ResidentNationQuestionTask(resident, nation){

                @Override
                public void run() {
                    TownyMessaging.sendNationMessage(this.nation, String.format(TownySettings.getLangString("msg_deny_invite"), this.getResident().getName()));
                }
            })));
            Question question = new Question(resident.getName(), String.format(TownySettings.getLangString("msg_invited"), nation.getName()), arrayList);
            try {
                NationCommand.plugin.appendQuestion(questioner, question);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else {
            nation.addTown(town);
            NationCommand.plugin.resetCache();
            TownyUniverse.getDataSource().saveTown(town);
        }
    }

    public static void nationAdd(Nation nation, List<Town> list) throws AlreadyRegisteredException {
        for (Town town : list) {
            if (town.hasNation()) continue;
            nation.addTown(town);
            TownyUniverse.getDataSource().saveTown(town);
            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_join_nation"), town.getName()));
        }
        plugin.resetCache();
        TownyUniverse.getDataSource().saveNation(nation);
    }

    public void nationKick(Player player, String[] stringArray) {
        Nation nation;
        Resident resident;
        if (stringArray.length < 1) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation kick [names]");
            return;
        }
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
            nation = resident.getTown().getNation();
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            return;
        }
        this.nationKick(player, resident, nation, TownyUniverse.getDataSource().getTowns(stringArray));
    }

    public void nationKick(Player player, Resident resident, Nation nation, List<Town> list) {
        ArrayList<Town> arrayList = new ArrayList<Town>();
        for (Town object : list) {
            if (object.isCapital()) {
                arrayList.add(object);
                continue;
            }
            try {
                nation.removeTown(object);
                TownyUniverse.getDataSource().saveTown(object);
            }
            catch (NotRegisteredException notRegisteredException) {
                arrayList.add(object);
            }
            catch (EmptyNationException emptyNationException) {}
        }
        for (Town town : arrayList) {
            list.remove(town);
        }
        if (list.size() > 0) {
            Object object = "";
            for (Town town : list) {
                object = (String)object + town.getName() + ", ";
                object = ((String)object).substring(0, ((String)object).length() - 2);
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_nation_kicked_by"), player.getName()));
            }
            object = ((String)object).substring(0, ((String)object).length() - 2);
            object = String.format(TownySettings.getLangString("msg_nation_kicked"), player.getName(), object);
            TownyMessaging.sendNationMessage(nation, ChatTools.color((String)object));
            TownyUniverse.getDataSource().saveNation(nation);
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public void nationAlly(Player player, String[] stringArray) {
        Nation nation;
        if (stringArray.length < 2) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation ally [add/remove] [name]");
            return;
        }
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            nation = resident.getTown().getNation();
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            return;
        }
        ArrayList<Nation> arrayList = new ArrayList<Nation>();
        String string = stringArray[0];
        String[] stringArray2 = StringMgmt.remFirstArg(stringArray);
        if ((string.equalsIgnoreCase("remove") || string.equalsIgnoreCase("add")) && stringArray2.length > 0) {
            for (String string2 : stringArray2) {
                try {
                    Nation nation2 = TownyUniverse.getDataSource().getNation(string2);
                    if (nation.equals(nation2)) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_own_nation_disallow"));
                        continue;
                    }
                    arrayList.add(nation2);
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
            if (!arrayList.isEmpty()) {
                this.nationAlly(player, nation, arrayList, string.equalsIgnoreCase("add"));
            }
        } else {
            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "[add/remove]"));
        }
    }

    public void nationAlly(Player player, Nation nation, List<Nation> list, boolean bl) {
        ArrayList<Nation> arrayList = new ArrayList<Nation>();
        for (Nation object : list) {
            try {
                if (bl && !nation.getAllies().contains(object)) {
                    if (!object.hasEnemy(nation)) {
                        nation.addAlly(object);
                        TownyMessaging.sendNationMessage(object, String.format(TownySettings.getLangString("msg_added_ally"), nation.getName()));
                        continue;
                    }
                    arrayList.add(object);
                    TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_unable_ally_enemy"), object.getName()));
                    continue;
                }
                if (!nation.getAllies().contains(object)) continue;
                nation.removeAlly(object);
                TownyMessaging.sendNationMessage(object, String.format(TownySettings.getLangString("msg_removed_ally"), nation.getName()));
                if (!object.hasAlly(nation)) continue;
                this.nationAlly(player, object, Arrays.asList(nation), false);
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                arrayList.add(object);
            }
            catch (NotRegisteredException notRegisteredException) {
                arrayList.add(object);
            }
        }
        for (Nation nation2 : arrayList) {
            list.remove(nation2);
        }
        if (list.size() > 0) {
            Object object = "";
            for (Nation nation3 : list) {
                object = (String)object + nation3.getName() + ", ";
            }
            object = ((String)object).substring(0, ((String)object).length() - 2);
            object = bl ? String.format(TownySettings.getLangString("msg_allied_nations"), player.getName(), object) : String.format(TownySettings.getLangString("msg_broke_alliance"), player.getName(), object);
            TownyMessaging.sendNationMessage(nation, ChatTools.color((String)object));
            TownyUniverse.getDataSource().saveNations();
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public void nationEnemy(Player player, String[] stringArray) {
        Nation nation;
        if (stringArray.length < 2) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation enemy [add/remove] [name]");
            return;
        }
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            nation = resident.getTown().getNation();
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            return;
        }
        ArrayList<Nation> arrayList = new ArrayList<Nation>();
        String string = stringArray[0];
        String[] stringArray2 = StringMgmt.remFirstArg(stringArray);
        if ((string.equalsIgnoreCase("remove") || string.equalsIgnoreCase("add")) && stringArray2.length > 0) {
            for (String string2 : stringArray2) {
                try {
                    Nation nation2 = TownyUniverse.getDataSource().getNation(string2);
                    if (nation.equals(nation2)) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_own_nation_disallow"));
                        continue;
                    }
                    arrayList.add(nation2);
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
            if (!arrayList.isEmpty()) {
                this.nationEnemy(player, nation, arrayList, string.equalsIgnoreCase("add"));
            }
        } else {
            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "[add/remove]"));
        }
    }

    public void nationEnemy(Player player, Nation nation, List<Nation> list, boolean bl) {
        ArrayList<Nation> arrayList = new ArrayList<Nation>();
        for (Nation object : list) {
            try {
                if (bl && !nation.getEnemies().contains(object)) {
                    nation.addEnemy(object);
                    TownyMessaging.sendNationMessage(object, String.format(TownySettings.getLangString("msg_added_enemy"), nation.getName()));
                    if (!object.hasAlly(nation)) continue;
                    this.nationAlly(player, object, Arrays.asList(nation), false);
                    continue;
                }
                if (!nation.getEnemies().contains(object)) continue;
                nation.removeEnemy(object);
                TownyMessaging.sendNationMessage(object, String.format(TownySettings.getLangString("msg_removed_enemy"), nation.getName()));
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                arrayList.add(object);
            }
            catch (NotRegisteredException notRegisteredException) {
                arrayList.add(object);
            }
        }
        for (Nation nation2 : arrayList) {
            list.remove(nation2);
        }
        if (list.size() > 0) {
            Object object = "";
            for (Nation nation3 : list) {
                object = (String)object + nation3.getName() + ", ";
            }
            object = ((String)object).substring(0, ((String)object).length() - 2);
            object = bl ? String.format(TownySettings.getLangString("msg_enemy_nations"), player.getName(), object) : String.format(TownySettings.getLangString("msg_enemy_to_neutral"), player.getName(), object);
            TownyMessaging.sendNationMessage(nation, ChatTools.color((String)object));
            TownyUniverse.getDataSource().saveNations();
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public void nationSet(Player player, String[] stringArray) throws TownyException, InvalidNameException {
        if (stringArray.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/nation set"));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "king " + TownySettings.getLangString("res_2"), ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "capital [town]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "taxes [$]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "name [name]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "title/surname [resident] [text]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "tag [upto 4 letters] or clear", ""));
        } else {
            Nation nation;
            Resident resident;
            try {
                resident = TownyUniverse.getDataSource().getResident(player.getName());
                nation = resident.getTown().getNation();
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                return;
            }
            if (stringArray[0].equalsIgnoreCase("king")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_KING.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (stringArray.length < 2) {
                    TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set king Dumbo");
                } else {
                    try {
                        Resident resident2 = TownyUniverse.getDataSource().getResident(stringArray[1]);
                        String string = nation.getCapital().getMayor().getName();
                        nation.setKing(resident2);
                        plugin.deleteCache(string);
                        plugin.deleteCache(resident2.getName());
                        TownyMessaging.sendNationMessage(nation, TownySettings.getNewKingMsg(resident2.getName(), nation.getName()));
                    }
                    catch (TownyException townyException) {
                        TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                    }
                }
            } else if (stringArray[0].equalsIgnoreCase("capital")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_CAPITOL.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (stringArray.length < 2) {
                    TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set capital {town name}");
                } else {
                    try {
                        Town town = TownyUniverse.getDataSource().getTown(stringArray[1]);
                        nation.setCapital(town);
                        plugin.resetCache();
                        TownyMessaging.sendNationMessage(nation, TownySettings.getNewKingMsg(town.getMayor().getName(), nation.getName()));
                    }
                    catch (TownyException townyException) {
                        TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                    }
                }
            } else if (stringArray[0].equalsIgnoreCase("taxes")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_TAXES.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (stringArray.length < 2) {
                    TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set taxes 70");
                } else {
                    Integer n = Integer.parseInt(stringArray[1].trim());
                    if (n < 0) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                        return;
                    }
                    try {
                        nation.setTaxes(n.intValue());
                        TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_town_set_nation_tax"), player.getName(), stringArray[1]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
                    }
                }
            } else if (stringArray[0].equalsIgnoreCase("name")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_NAME.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (stringArray.length < 2) {
                    TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set name Plutoria");
                } else if (!NameValidation.isBlacklistName(stringArray[1])) {
                    this.nationRename(player, nation, stringArray[1]);
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
                }
            } else if (stringArray[0].equalsIgnoreCase("tag")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_TAG.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (stringArray.length < 2) {
                    TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set tag PLT");
                } else if (stringArray[1].equalsIgnoreCase("clear")) {
                    try {
                        nation.setTag(" ");
                        TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_reset_nation_tag"), player.getName()));
                    }
                    catch (TownyException townyException) {
                        TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                    }
                } else {
                    nation.setTag(NameValidation.checkAndFilterName(stringArray[1]));
                }
                TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_set_nation_tag"), player.getName(), nation.getTag()));
            } else if (stringArray[0].equalsIgnoreCase("title")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_TITLE.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (stringArray.length < 2) {
                    TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set title bilbo Jester ");
                } else {
                    resident = TownyUniverse.getDataSource().getResident(stringArray[1]);
                }
                if (resident.hasNation()) {
                    if (resident.getTown().getNation() != TownyUniverse.getDataSource().getResident(player.getName()).getTown().getNation()) {
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_same_nation"), resident.getName()));
                        return;
                    }
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_same_nation"), resident.getName()));
                    return;
                }
                if (StringMgmt.join(stringArray = StringMgmt.remArgs(stringArray, 2)).length() > TownySettings.getMaxTitleLength()) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_input_too_long"));
                    return;
                }
                String string = StringMgmt.join(NameValidation.checkAndFilterArray(stringArray));
                resident.setTitle(string + " ");
                TownyUniverse.getDataSource().saveResident(resident);
                if (resident.hasTitle()) {
                    TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_set_title"), resident.getName(), resident.getTitle()));
                } else {
                    TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_clear_title_surname"), "Title", resident.getName()));
                }
            } else if (stringArray[0].equalsIgnoreCase("surname")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_SURNAME.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (stringArray.length < 2) {
                    TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set surname bilbo the dwarf ");
                } else {
                    resident = TownyUniverse.getDataSource().getResident(stringArray[1]);
                }
                if (resident.hasNation()) {
                    if (resident.getTown().getNation() != TownyUniverse.getDataSource().getResident(player.getName()).getTown().getNation()) {
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_same_nation"), resident.getName()));
                        return;
                    }
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_same_nation"), resident.getName()));
                    return;
                }
                if (StringMgmt.join(stringArray = StringMgmt.remArgs(stringArray, 2)).length() > TownySettings.getMaxTitleLength()) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_input_too_long"));
                    return;
                }
                String string = StringMgmt.join(NameValidation.checkAndFilterArray(stringArray));
                resident.setSurname(" " + string);
                TownyUniverse.getDataSource().saveResident(resident);
                if (resident.hasSurname()) {
                    TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_set_surname"), resident.getName(), resident.getSurname()));
                } else {
                    TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_clear_title_surname"), "Surname", resident.getName()));
                }
            } else {
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), stringArray[0]));
                return;
            }
            TownyUniverse.getDataSource().saveNation(nation);
            TownyUniverse.getDataSource().saveNationList();
        }
    }

    public void nationToggle(Player player, String[] stringArray) throws TownyException {
        if (stringArray.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/nation toggle"));
            player.sendMessage(ChatTools.formatCommand("", "/nation toggle", "neutral", ""));
        } else {
            Nation nation;
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                nation = resident.getTown().getNation();
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                return;
            }
            if (stringArray[0].equalsIgnoreCase("neutral")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_TOGGLE_NEUTRAL.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                try {
                    if (!TownySettings.isDeclaringNeutral()) {
                        throw new TownyException(TownySettings.getLangString("msg_neutral_disabled"));
                    }
                    boolean bl = !nation.isNeutral();
                    Double d = TownySettings.getNationNeutralityCost();
                    if (bl && TownySettings.isUsingEconomy() && !nation.pay(d, "Nation Neutrality Cost")) {
                        throw new TownyException(TownySettings.getLangString("msg_nation_cant_neutral"));
                    }
                    nation.setNeutral(bl);
                    if (TownySettings.isUsingEconomy() && d > 0.0) {
                        TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_you_paid"), TownyEconomyHandler.getFormattedBalance(d)));
                    } else {
                        TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_nation_set_neutral"));
                    }
                    TownyMessaging.sendNationMessage(nation, TownySettings.getLangString("msg_nation_neutral") + (nation.isNeutral() ? "\u00a72" : "\u00a74 not") + " neutral.");
                }
                catch (EconomyException economyException) {
                    TownyMessaging.sendErrorMsg((Object)player, economyException.getMessage());
                }
                catch (TownyException townyException) {
                    try {
                        nation.setNeutral(false);
                    }
                    catch (TownyException townyException2) {
                        townyException2.printStackTrace();
                    }
                    TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                }
                catch (Exception exception) {
                    TownyMessaging.sendErrorMsg((Object)player, exception.getMessage());
                }
            } else {
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "nation"));
                return;
            }
            plugin.getTownyUniverse();
            TownyUniverse.getDataSource().saveNation(nation);
        }
    }

    public void nationRename(Player player, Nation nation, String string) {
        try {
            TownyUniverse.getDataSource().renameNation(nation, string);
            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_nation_set_name"), player.getName(), nation.getName()));
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
        }
    }

    static {
        nation_help = new ArrayList<String>();
        king_help = new ArrayList<String>();
        nation_help.add(ChatTools.formatTitle("/nation"));
        nation_help.add(ChatTools.formatCommand("", "/nation", "", TownySettings.getLangString("nation_help_1")));
        nation_help.add(ChatTools.formatCommand("", "/nation", TownySettings.getLangString("nation_help_2"), TownySettings.getLangString("nation_help_3")));
        nation_help.add(ChatTools.formatCommand("", "/nation", "list", TownySettings.getLangString("nation_help_4")));
        nation_help.add(ChatTools.formatCommand("", "/nation", "online", TownySettings.getLangString("nation_help_9")));
        nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/nation", "deposit [$]", ""));
        nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/nation", "leave", TownySettings.getLangString("nation_help_5")));
        if (!TownySettings.isNationCreationAdminOnly()) {
            nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/nation", "new " + TownySettings.getLangString("nation_help_2"), TownySettings.getLangString("nation_help_6")));
        }
        nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "king ?", TownySettings.getLangString("nation_help_7")));
        nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/nation", "new " + TownySettings.getLangString("nation_help_2") + " [capital]", TownySettings.getLangString("nation_help_8")));
        nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/nation", "delete " + TownySettings.getLangString("nation_help_2"), ""));
        king_help.add(ChatTools.formatTitle(TownySettings.getLangString("king_help_1")));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "withdraw [$]", ""));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "[add/kick] [town] .. [town]", ""));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "rank [add/remove] " + TownySettings.getLangString("res_2"), "[Rank]"));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "set [] .. []", ""));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "toggle [] .. []", ""));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "ally [add/remove] " + TownySettings.getLangString("nation_help_2"), TownySettings.getLangString("king_help_2")));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "enemy [add/remove] " + TownySettings.getLangString("nation_help_2"), TownySettings.getLangString("king_help_3")));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "delete", ""));
    }
}

