/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ResidentCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> output;

    public ResidentCommand(Towny towny) {
        plugin = towny;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            System.out.println("[PLAYER_COMMAND] " + player.getName() + ": /" + string + " " + StringMgmt.join(stringArray));
            if (stringArray == null) {
                for (String string2 : output) {
                    player.sendMessage(string2);
                }
                this.parseResidentCommand(player, stringArray);
            } else {
                this.parseResidentCommand(player, stringArray);
            }
        } else {
            for (String string3 : output) {
                commandSender.sendMessage(Colors.strip(string3));
            }
        }
        return true;
    }

    public void parseResidentCommand(Player player, String[] stringArray) {
        block19: {
            try {
                if (stringArray.length == 0) {
                    try {
                        Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                        TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(resident, player));
                        break block19;
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        throw new TownyException(TownySettings.getLangString("msg_err_not_registered"));
                    }
                }
                if (stringArray[0].equalsIgnoreCase("?") || stringArray[0].equalsIgnoreCase("help")) {
                    for (String string : output) {
                        player.sendMessage(string);
                    }
                    break block19;
                }
                if (stringArray[0].equalsIgnoreCase("list")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_LIST.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.listResidents(player);
                    break block19;
                }
                if (stringArray[0].equalsIgnoreCase("tax")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TAX.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    try {
                        Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                        TownyMessaging.sendMessage((Object)player, TownyFormatter.getTaxStatus(resident));
                        break block19;
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        throw new TownyException(TownySettings.getLangString("msg_err_not_registered"));
                    }
                }
                if (stringArray[0].equalsIgnoreCase("set")) {
                    String[] stringArray2 = StringMgmt.remFirstArg(stringArray);
                    this.residentSet(player, stringArray2);
                    break block19;
                }
                if (stringArray[0].equalsIgnoreCase("toggle")) {
                    String[] stringArray3 = StringMgmt.remFirstArg(stringArray);
                    this.residentToggle(player, stringArray3);
                    break block19;
                }
                if (stringArray[0].equalsIgnoreCase("friend")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_FRIEND.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    String[] stringArray4 = StringMgmt.remFirstArg(stringArray);
                    this.residentFriend(player, stringArray4);
                    break block19;
                }
                try {
                    Resident resident = TownyUniverse.getDataSource().getResident(stringArray[0]);
                    TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(resident, player));
                }
                catch (NotRegisteredException notRegisteredException) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered_1"), stringArray[0]));
                }
            }
            catch (Exception exception) {
                TownyMessaging.sendErrorMsg((Object)player, exception.getMessage());
            }
        }
    }

    private void residentToggle(Player player, String[] stringArray) throws TownyException {
        if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE.getNode(stringArray[0].toLowerCase())) || stringArray[0].equalsIgnoreCase("spy")) {
            throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
        }
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            TownyPermission townyPermission = resident.getPermissions();
            if (stringArray[0].equalsIgnoreCase("pvp")) {
                townyPermission.pvp = !townyPermission.pvp;
            } else if (stringArray[0].equalsIgnoreCase("fire")) {
                townyPermission.fire = !townyPermission.fire;
            } else if (stringArray[0].equalsIgnoreCase("explosion")) {
                townyPermission.explosion = !townyPermission.explosion;
            } else if (stringArray[0].equalsIgnoreCase("mobs")) {
                townyPermission.mobs = !townyPermission.mobs;
            } else {
                resident.toggleMode(stringArray, true);
                return;
            }
            this.notifyPerms(player, townyPermission);
            TownyUniverse.getDataSource().saveResident(resident);
        }
        catch (NotRegisteredException notRegisteredException) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered"), player.getName()));
        }
    }

    private void notifyPerms(Player player, TownyPermission townyPermission) {
        TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_set_perms"));
        TownyMessaging.sendMessage((Object)player, "\u00a72PvP: " + (townyPermission.pvp ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Explosions: " + (townyPermission.explosion ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Firespread: " + (townyPermission.fire ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Mob Spawns: " + (townyPermission.mobs ? "\u00a74ON" : "\u00a7aOFF"));
    }

    public void listResidents(Player player) {
        player.sendMessage(ChatTools.formatTitle(TownySettings.getLangString("res_list")));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Resident object : plugin.getTownyUniverse().getActiveResidents()) {
            String string = object.isKing() ? "\u00a76" : (object.isMayor() ? "\u00a7b" : "\u00a7f");
            arrayList.add(string + object.getName() + "\u00a7f");
        }
        for (String string : ChatTools.list(arrayList)) {
            player.sendMessage(string);
        }
    }

    public void residentSet(Player player, String[] stringArray) throws TownyException {
        if (stringArray.length == 0) {
            player.sendMessage(ChatTools.formatCommand("", "/resident set", "perm ...", "'/resident set perm' " + TownySettings.getLangString("res_5")));
            player.sendMessage(ChatTools.formatCommand("", "/resident set", "mode ...", "'/resident set mode' " + TownySettings.getLangString("res_5")));
        } else {
            Resident resident;
            try {
                resident = TownyUniverse.getDataSource().getResident(player.getName());
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                return;
            }
            if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_SET.getNode(stringArray[0].toLowerCase()))) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            if (stringArray[0].equalsIgnoreCase("perm")) {
                String[] stringArray2 = StringMgmt.remFirstArg(stringArray);
                TownCommand.setTownBlockPermissions(player, resident, resident.getPermissions(), stringArray2, true);
            } else if (stringArray[0].equalsIgnoreCase("mode")) {
                String[] stringArray3 = StringMgmt.remFirstArg(stringArray);
                this.setMode(player, stringArray3);
            } else {
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "town"));
                return;
            }
            TownyUniverse.getDataSource().saveResident(resident);
        }
    }

    private void setMode(Player player, String[] stringArray) {
        if (stringArray.length == 0) {
            player.sendMessage(ChatTools.formatCommand("", "/resident set mode", "clear", ""));
            player.sendMessage(ChatTools.formatCommand("", "/resident set mode", "[mode] ...[mode]", ""));
            player.sendMessage(ChatTools.formatCommand("Mode", "map", "", TownySettings.getLangString("mode_1")));
            player.sendMessage(ChatTools.formatCommand("Mode", "townclaim", "", TownySettings.getLangString("mode_2")));
            player.sendMessage(ChatTools.formatCommand("Mode", "townunclaim", "", TownySettings.getLangString("mode_3")));
            player.sendMessage(ChatTools.formatCommand("Mode", "tc", "", TownySettings.getLangString("mode_4")));
            player.sendMessage(ChatTools.formatCommand("Mode", "nc", "", TownySettings.getLangString("mode_5")));
            player.sendMessage(ChatTools.formatCommand("Eg", "/resident set mode", "map townclaim town nation general", ""));
            return;
        }
        if (stringArray[0].equalsIgnoreCase("reset") || stringArray[0].equalsIgnoreCase("clear")) {
            plugin.removePlayerMode(player);
            return;
        }
        List<String> list = Arrays.asList(stringArray);
        if (list.contains("spy") && plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_CHAT_SPY.getNode())) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_command_disable"));
            return;
        }
        plugin.setPlayerMode(player, stringArray, true);
    }

    public void residentFriend(Player player, String[] stringArray) {
        if (stringArray.length == 0) {
            player.sendMessage(ChatTools.formatCommand("", "/resident friend", "add " + TownySettings.getLangString("res_2"), ""));
            player.sendMessage(ChatTools.formatCommand("", "/resident friend", "remove " + TownySettings.getLangString("res_2"), ""));
            player.sendMessage(ChatTools.formatCommand("", "/resident friend", "clear", ""));
        } else {
            Resident resident;
            try {
                resident = TownyUniverse.getDataSource().getResident(player.getName());
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                return;
            }
            if (stringArray[0].equalsIgnoreCase("add")) {
                String[] stringArray2 = StringMgmt.remFirstArg(stringArray);
                this.residentFriendAdd(player, resident, TownyUniverse.getOnlineResidents(player, stringArray2));
            } else if (stringArray[0].equalsIgnoreCase("remove")) {
                String[] stringArray3 = StringMgmt.remFirstArg(stringArray);
                this.residentFriendRemove(player, resident, TownyUniverse.getOnlineResidents(player, stringArray3));
            } else if (stringArray[0].equalsIgnoreCase("add+")) {
                String[] stringArray4 = StringMgmt.remFirstArg(stringArray);
                this.residentFriendAdd(player, resident, ResidentCommand.getResidents(player, stringArray4));
            } else if (stringArray[0].equalsIgnoreCase("remove+")) {
                String[] stringArray5 = StringMgmt.remFirstArg(stringArray);
                this.residentFriendRemove(player, resident, ResidentCommand.getResidents(player, stringArray5));
            } else if (stringArray[0].equalsIgnoreCase("clearlist") || stringArray[0].equalsIgnoreCase("clear")) {
                this.residentFriendRemove(player, resident, resident.getFriends());
            }
        }
    }

    private static List<Resident> getResidents(Player player, String[] stringArray) {
        ArrayList<Resident> arrayList = new ArrayList<Resident>();
        for (String string : stringArray) {
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(string);
                arrayList.add(resident);
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            }
        }
        return arrayList;
    }

    public void residentFriendAdd(Player player, Resident resident, List<Resident> list) {
        ArrayList<Resident> arrayList = new ArrayList<Resident>();
        for (Resident object : list) {
            try {
                resident.addFriend(object);
                plugin.deleteCache(object.getName());
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                arrayList.add(object);
            }
        }
        for (Resident resident2 : arrayList) {
            list.remove(resident2);
        }
        if (list.size() > 0) {
            Object object = "Added ";
            for (Resident resident3 : list) {
                object = (String)object + resident3.getName() + ", ";
                Player player2 = plugin.getServer().getPlayer(resident3.getName());
                if (player2 == null) continue;
                TownyMessaging.sendMsg((Object)player2, String.format(TownySettings.getLangString("msg_friend_add"), player.getName()));
            }
            object = ((String)object).substring(0, ((String)object).length() - 2);
            object = (String)object + TownySettings.getLangString("msg_to_list");
            TownyMessaging.sendMsg((Object)player, (String)object);
            TownyUniverse.getDataSource().saveResident(resident);
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public void residentFriendRemove(Player player, Resident resident, List<Resident> list) {
        ArrayList<Resident> arrayList = new ArrayList<Resident>();
        ArrayList<Resident> arrayList2 = new ArrayList<Resident>(list);
        for (Resident resident2 : arrayList2) {
            try {
                resident.removeFriend(resident2);
                plugin.deleteCache(resident2.getName());
            }
            catch (NotRegisteredException notRegisteredException) {
                arrayList.add(resident2);
            }
        }
        if (arrayList.size() > 0) {
            for (Resident resident2 : arrayList) {
                arrayList2.remove(resident2);
            }
        }
        if (arrayList2.size() > 0) {
            Object object = TownySettings.getLangString("msg_removed");
            for (Resident resident3 : arrayList2) {
                Resident resident2;
                object = (String)object + resident3.getName() + ", ";
                resident2 = plugin.getServer().getPlayer(resident3.getName());
                if (resident2 == null) continue;
                TownyMessaging.sendMsg(resident2, String.format(TownySettings.getLangString("msg_friend_remove"), player.getName()));
            }
            object = ((String)object).substring(0, ((String)object).length() - 2);
            object = (String)object + TownySettings.getLangString("msg_from_list");
            TownyMessaging.sendMsg((Object)player, (String)object);
            TownyUniverse.getDataSource().saveResident(resident);
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    static {
        output = new ArrayList<String>();
        output.add(ChatTools.formatTitle("/resident"));
        output.add(ChatTools.formatCommand("", "/resident", "", TownySettings.getLangString("res_1")));
        output.add(ChatTools.formatCommand("", "/resident", TownySettings.getLangString("res_2"), TownySettings.getLangString("res_3")));
        output.add(ChatTools.formatCommand("", "/resident", "list", TownySettings.getLangString("res_4")));
        output.add(ChatTools.formatCommand("", "/resident", "tax", ""));
        output.add(ChatTools.formatCommand("", "/resident", "toggle", "[mode]...[mode]"));
        output.add(ChatTools.formatCommand("", "/resident", "set [] .. []", "'/resident set' " + TownySettings.getLangString("res_5")));
        output.add(ChatTools.formatCommand("", "/resident", "friend [add/remove] " + TownySettings.getLangString("res_2"), TownySettings.getLangString("res_6")));
        output.add(ChatTools.formatCommand("", "/resident", "friend [add+/remove+] " + TownySettings.getLangString("res_2") + " ", TownySettings.getLangString("res_7")));
    }
}

