/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TownyWorldCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> townyworld_help;
    private static final List<String> townyworld_set;
    private static TownyWorld Globalworld;

    public TownyWorldCommand(Towny towny) {
        plugin = towny;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        townyworld_help.add(ChatTools.formatTitle("/townyworld"));
        townyworld_help.add(ChatTools.formatCommand("", "/townyworld", "", TownySettings.getLangString("world_help_1")));
        townyworld_help.add(ChatTools.formatCommand("", "/townyworld", TownySettings.getLangString("world_help_2"), TownySettings.getLangString("world_help_3")));
        townyworld_help.add(ChatTools.formatCommand("", "/townyworld", "list", TownySettings.getLangString("world_help_4")));
        townyworld_help.add(ChatTools.formatCommand("", "/townyworld", "toggle", ""));
        townyworld_help.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyworld", "set [] .. []", ""));
        townyworld_help.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyworld", "regen", TownySettings.getLangString("world_help_5")));
        townyworld_set.add(ChatTools.formatTitle("/townyworld set"));
        townyworld_set.add(ChatTools.formatCommand("", "/townyworld set", "wildname [name]", ""));
        if (!plugin.isPermissions()) {
            townyworld_set.add(ChatTools.formatCommand("", "/townyworld set", "usedefault", ""));
            townyworld_set.add(ChatTools.formatCommand("", "/townyworld set", "wildperm [perm] .. [perm]", "build,destroy,switch,useitem"));
            townyworld_set.add(ChatTools.formatCommand("", "/townyworld set", "wildignore [id] [id] [id]", ""));
        }
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            System.out.println("[PLAYER_COMMAND] " + player.getName() + ": /" + string + " " + StringMgmt.join(stringArray));
        }
        this.parseWorldCommand(commandSender, stringArray);
        townyworld_set.clear();
        townyworld_help.clear();
        Globalworld = null;
        return true;
    }

    public void parseWorldCommand(CommandSender commandSender, String[] stringArray) {
        Player player = null;
        if (commandSender instanceof Player) {
            player = (Player)commandSender;
            try {
                Globalworld = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
            }
            catch (NotRegisteredException notRegisteredException) {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_area_not_recog"));
                return;
            }
        }
        if (stringArray.length == 0) {
            commandSender.sendMessage(String.format(TownySettings.getLangString("msg_err_invalid_property"), "world"));
            return;
        }
        if (!stringArray[0].equalsIgnoreCase("?") && !stringArray[0].equalsIgnoreCase("list")) {
            try {
                if (stringArray.length < 1) {
                    commandSender.sendMessage(TownySettings.getLangString("msg_area_not_recog"));
                    return;
                }
                Globalworld = TownyUniverse.getDataSource().getWorld(stringArray[stringArray.length - 1].toLowerCase());
                stringArray = StringMgmt.remLastArg(stringArray);
            }
            catch (NotRegisteredException notRegisteredException) {
                commandSender.sendMessage(String.format(TownySettings.getLangString("msg_err_invalid_property"), "world"));
                return;
            }
        }
        if (stringArray.length == 0) {
            if (player == null) {
                for (String string : TownyFormatter.getStatus(Globalworld)) {
                    commandSender.sendMessage(Colors.strip(string));
                }
            } else {
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(Globalworld));
            }
            return;
        }
        try {
            if (stringArray[0].equalsIgnoreCase("?")) {
                if (player == null) {
                    for (String string : townyworld_help) {
                        commandSender.sendMessage(string);
                    }
                } else {
                    for (String string : townyworld_help) {
                        player.sendMessage(string);
                    }
                }
            } else if (stringArray[0].equalsIgnoreCase("list")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_LIST.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                this.listWorlds(player, commandSender);
            } else if (stringArray[0].equalsIgnoreCase("set")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_SET.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                this.worldSet(player, commandSender, StringMgmt.remFirstArg(stringArray));
            } else if (stringArray[0].equalsIgnoreCase("toggle")) {
                this.worldToggle(player, commandSender, StringMgmt.remFirstArg(stringArray));
            } else if (stringArray[0].equalsIgnoreCase("regen")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_REGEN.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (TownyUniverse.isWarTime()) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_war_cannot_do"));
                    return;
                }
                if (!TownyUniverse.getPermissionSource().isTownyAdmin(player)) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_admin_only"));
                    return;
                }
                if (TownySettings.getTownBlockSize() != 16) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_plot_regen_wrong_size"));
                    return;
                }
                if (player != null) {
                    TownyRegenAPI.regenChunk(player);
                }
            } else if (stringArray[0].equalsIgnoreCase("undo")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_UNDO.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (player != null) {
                    try {
                        TownyUniverse.getDataSource().getResident(player.getName()).regenUndo();
                    }
                    catch (NotRegisteredException notRegisteredException) {
                    }
                }
            }
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
        }
    }

    public void listWorlds(Player player, CommandSender commandSender) {
        if (player == null) {
            commandSender.sendMessage(ChatTools.formatTitle(TownySettings.getLangString("world_plu")));
        } else {
            player.sendMessage(ChatTools.formatTitle(TownySettings.getLangString("world_plu")));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, Integer> hashMap = BukkitTools.getPlayersPerWorld();
        for (TownyWorld object : TownyUniverse.getDataSource().getWorlds()) {
            int n = hashMap.containsKey(object.getName()) ? hashMap.get(object.getName()) : 0;
            arrayList.add("\u00a7b" + object.getName() + "\u00a73" + " [" + n + "]" + "\u00a7f");
        }
        if (player == null) {
            for (String string : ChatTools.list(arrayList)) {
                commandSender.sendMessage(string);
            }
        } else {
            for (String string : ChatTools.list(arrayList)) {
                player.sendMessage(string);
            }
        }
    }

    public void worldToggle(Player player, CommandSender commandSender, String[] stringArray) throws TownyException {
        if (stringArray.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/TownyWorld toggle"));
            player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "claimable", ""));
            player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "usingtowny", ""));
            player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "pvp/forcepvp", ""));
            player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "explosion/forceexplosion", ""));
            player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "fire/forcefire", ""));
            player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "townmobs/worldmobs", ""));
            player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "revertunclaim/revertexpl", ""));
        } else {
            if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE.getNode(stringArray[0].toLowerCase()))) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            if (stringArray[0].equalsIgnoreCase("claimable")) {
                Globalworld.setClaimable(!Globalworld.isClaimable());
                String string = String.format(TownySettings.getLangString("msg_set_claim"), Globalworld.getName(), Globalworld.isClaimable() ? "Enabled" : "Disabled");
                if (player != null) {
                    TownyMessaging.sendMsg((Object)player, string);
                } else {
                    TownyMessaging.sendMsg(string);
                }
            } else if (stringArray[0].equalsIgnoreCase("usingtowny")) {
                Globalworld.setUsingTowny(!Globalworld.isUsingTowny());
                plugin.resetCache();
                String string = String.format(Globalworld.isUsingTowny() ? TownySettings.getLangString("msg_set_use_towny_on") : TownySettings.getLangString("msg_set_use_towny_off"), new Object[0]);
                if (player != null) {
                    TownyMessaging.sendMsg((Object)player, string);
                } else {
                    TownyMessaging.sendMsg(string);
                }
            } else if (stringArray[0].equalsIgnoreCase("pvp")) {
                Globalworld.setPVP(!Globalworld.isPVP());
                String string = String.format(TownySettings.getLangString("msg_changed_world_setting"), "Global PVP", Globalworld.getName(), Globalworld.isPVP() ? "Enabled" : "Disabled");
                if (player != null) {
                    TownyMessaging.sendMsg((Object)player, string);
                } else {
                    TownyMessaging.sendMsg(string);
                }
            } else if (stringArray[0].equalsIgnoreCase("forcepvp")) {
                Globalworld.setForcePVP(!Globalworld.isForcePVP());
                String string = String.format(TownySettings.getLangString("msg_changed_world_setting"), "Force town PVP", Globalworld.getName(), Globalworld.isForcePVP() ? "Forced" : "Adjustable");
                if (player != null) {
                    TownyMessaging.sendMsg((Object)player, string);
                } else {
                    TownyMessaging.sendMsg(string);
                }
            } else if (stringArray[0].equalsIgnoreCase("explosion")) {
                Globalworld.setExpl(!Globalworld.isExpl());
                String string = String.format(TownySettings.getLangString("msg_changed_world_setting"), "Explosions", Globalworld.getName(), Globalworld.isExpl() ? "Enabled" : "Disabled");
                if (player != null) {
                    TownyMessaging.sendMsg((Object)player, string);
                } else {
                    TownyMessaging.sendMsg(string);
                }
            } else if (stringArray[0].equalsIgnoreCase("forceexplosion")) {
                Globalworld.setForceExpl(!Globalworld.isForceExpl());
                String string = String.format(TownySettings.getLangString("msg_changed_world_setting"), "Force town Explosions", Globalworld.getName(), Globalworld.isForceExpl() ? "Forced" : "Adjustable");
                if (player != null) {
                    TownyMessaging.sendMsg((Object)player, string);
                } else {
                    TownyMessaging.sendMsg(string);
                }
            } else if (stringArray[0].equalsIgnoreCase("fire")) {
                Globalworld.setFire(!Globalworld.isFire());
                String string = String.format(TownySettings.getLangString("msg_changed_world_setting"), "Fire Spread", Globalworld.getName(), Globalworld.isFire() ? "enabled" : "disabled");
                if (player != null) {
                    TownyMessaging.sendMsg((Object)player, string);
                } else {
                    TownyMessaging.sendMsg(string);
                }
            } else if (stringArray[0].equalsIgnoreCase("forcefire")) {
                Globalworld.setForceFire(!Globalworld.isForceFire());
                String string = String.format(TownySettings.getLangString("msg_changed_world_setting"), "Force town Fire Spread", Globalworld.getName(), Globalworld.isForceFire() ? "Forced" : "Adjustable");
                if (player != null) {
                    TownyMessaging.sendMsg((Object)player, string);
                } else {
                    TownyMessaging.sendMsg(string);
                }
            } else if (stringArray[0].equalsIgnoreCase("townmobs")) {
                Globalworld.setForceTownMobs(!Globalworld.isForceTownMobs());
                String string = String.format(TownySettings.getLangString("msg_changed_world_setting"), "Town Mob spawns", Globalworld.getName(), Globalworld.isForceTownMobs() ? "Forced" : "Adjustable");
                if (player != null) {
                    TownyMessaging.sendMsg((Object)player, string);
                } else {
                    TownyMessaging.sendMsg(string);
                }
            } else if (stringArray[0].equalsIgnoreCase("worldmobs")) {
                Globalworld.setWorldMobs(!Globalworld.hasWorldMobs());
                String string = String.format(TownySettings.getLangString("msg_changed_world_setting"), "World Mob spawns", Globalworld.getName(), Globalworld.hasWorldMobs() ? "Enabled" : "Disabled");
                if (player != null) {
                    TownyMessaging.sendMsg((Object)player, string);
                } else {
                    TownyMessaging.sendMsg(string);
                }
            } else if (stringArray[0].equalsIgnoreCase("revertunclaim")) {
                Globalworld.setUsingPlotManagementRevert(!Globalworld.isUsingPlotManagementRevert());
                String string = String.format(TownySettings.getLangString("msg_changed_world_setting"), "Unclaim Revert", Globalworld.getName(), Globalworld.isUsingPlotManagementRevert() ? "Enabled" : "Disabled");
                if (player != null) {
                    TownyMessaging.sendMsg((Object)player, string);
                } else {
                    TownyMessaging.sendMsg(string);
                }
            } else if (stringArray[0].equalsIgnoreCase("revertexpl")) {
                Globalworld.setUsingPlotManagementWildRevert(!Globalworld.isUsingPlotManagementWildRevert());
                String string = String.format(TownySettings.getLangString("msg_changed_world_setting"), "Wilderness Explosion Revert", Globalworld.getName(), Globalworld.isUsingPlotManagementWildRevert() ? "Enabled" : "Disabled");
                if (player != null) {
                    TownyMessaging.sendMsg((Object)player, string);
                } else {
                    TownyMessaging.sendMsg(string);
                }
            } else {
                String string = String.format(TownySettings.getLangString("msg_err_invalid_property"), "'" + stringArray[0] + "'");
                if (player != null) {
                    TownyMessaging.sendErrorMsg((Object)player, string);
                } else {
                    TownyMessaging.sendErrorMsg(string);
                }
                return;
            }
            TownyUniverse.getDataSource().saveWorld(Globalworld);
        }
    }

    public void worldSet(Player player, CommandSender commandSender, String[] stringArray) {
        if (stringArray.length == 0) {
            if (player == null) {
                for (String string : townyworld_set) {
                    commandSender.sendMessage(string);
                }
            } else {
                for (String string : townyworld_set) {
                    player.sendMessage(string);
                }
            }
        } else {
            block41: {
                if (stringArray[0].equalsIgnoreCase("usedefault")) {
                    Globalworld.setUsingDefault();
                    plugin.resetCache();
                    if (player != null) {
                        TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_usedefault"), Globalworld.getName()));
                    } else {
                        commandSender.sendMessage(String.format(TownySettings.getLangString("msg_usedefault"), Globalworld.getName()));
                    }
                } else if (stringArray[0].equalsIgnoreCase("wildperm")) {
                    if (stringArray.length < 2) {
                        Globalworld.setUsingDefault();
                        if (player != null) {
                            TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_usedefault"), Globalworld.getName()));
                        } else {
                            commandSender.sendMessage(String.format(TownySettings.getLangString("msg_usedefault"), Globalworld.getName()));
                        }
                    } else {
                        try {
                            List<String> list = Arrays.asList(StringMgmt.remFirstArg(stringArray));
                            Globalworld.setUnclaimedZoneBuild(list.contains("build"));
                            Globalworld.setUnclaimedZoneDestroy(list.contains("destroy"));
                            Globalworld.setUnclaimedZoneSwitch(list.contains("switch"));
                            Globalworld.setUnclaimedZoneItemUse(list.contains("itemuse"));
                            plugin.resetCache();
                            if (player != null) {
                                TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_set_wild_perms"), Globalworld.getName(), list.toString()));
                                break block41;
                            }
                            commandSender.sendMessage(String.format(TownySettings.getLangString("msg_set_wild_perms"), Globalworld.getName(), list.toString()));
                        }
                        catch (Exception exception) {
                            if (player != null) {
                                TownyMessaging.sendErrorMsg((Object)player, "Eg: /townyworld set wildperm build destroy");
                                break block41;
                            }
                            commandSender.sendMessage("Eg: /townyworld set wildperm build destroy <world>");
                        }
                    }
                } else if (stringArray[0].equalsIgnoreCase("wildignore")) {
                    if (stringArray.length < 2) {
                        if (player != null) {
                            TownyMessaging.sendErrorMsg((Object)player, "Eg: /townyworld set wildignore 11,25,45,67");
                        } else {
                            commandSender.sendMessage("Eg: /townyworld set wildignore 11,25,45,67 <world>");
                        }
                    } else {
                        try {
                            ArrayList<Integer> arrayList = new ArrayList<Integer>();
                            for (String string : StringMgmt.remFirstArg(stringArray)) {
                                try {
                                    arrayList.add(Integer.parseInt(string.trim()));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            Globalworld.setUnclaimedZoneIgnore(arrayList);
                            plugin.resetCache();
                            if (player != null) {
                                TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_set_wild_ignore"), Globalworld.getName(), Arrays.toString((Object[])arrayList.toArray(new Integer[0]))));
                                break block41;
                            }
                            commandSender.sendMessage(String.format(TownySettings.getLangString("msg_set_wild_ignore"), Globalworld.getName(), Arrays.toString((Object[])arrayList.toArray(new Integer[0]))));
                        }
                        catch (Exception exception) {
                            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_input"), " on/off."));
                        }
                    }
                } else if (stringArray[0].equalsIgnoreCase("wildname")) {
                    if (stringArray.length < 2) {
                        if (player != null) {
                            TownyMessaging.sendErrorMsg((Object)player, "Eg: /townyworld set wildname Wildy");
                        }
                    } else {
                        try {
                            Globalworld.setUnclaimedZoneName(stringArray[1]);
                            if (player != null) {
                                TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_set_wild_name"), Globalworld.getName(), stringArray[1]));
                                break block41;
                            }
                            commandSender.sendMessage(String.format(TownySettings.getLangString("msg_set_wild_name"), Globalworld.getName(), stringArray[1]));
                        }
                        catch (Exception exception) {
                            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_input"), " on/off."));
                        }
                    }
                } else {
                    if (player != null) {
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "world"));
                    }
                    return;
                }
            }
            TownyUniverse.getDataSource().saveWorld(Globalworld);
        }
    }

    static {
        townyworld_help = new ArrayList<String>();
        townyworld_set = new ArrayList<String>();
    }
}

