/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.util.FileMgmt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.bukkit.entity.Player;

public abstract class TownyDataSource {
    protected TownyUniverse universe;
    protected Towny plugin;
    protected boolean firstRun = true;

    public void initialize(Towny towny, TownyUniverse townyUniverse) {
        this.universe = townyUniverse;
        this.plugin = towny;
    }

    public synchronized void backup() throws IOException {
    }

    public synchronized void cleanupBackups() {
        long l = TownySettings.getBackupLifeLength();
        if (l >= 0L) {
            FileMgmt.deleteOldBackups(new File(this.universe.getRootFolder() + FileMgmt.fileSeparator() + "backup"), l);
        }
    }

    public synchronized void deleteUnusedResidentFiles() {
    }

    public boolean confirmContinuation(String string) {
        Object var2_2 = null;
        String string2 = null;
        while (var2_2 == null) {
            System.out.println(string);
            System.out.print("    Continue (y/n): ");
            Scanner scanner = new Scanner(System.in);
            string2 = scanner.next();
            string2 = string2.toLowerCase();
            if (string2.equals("y") || string2.equals("yes")) {
                scanner.close();
                return true;
            }
            if (!string2.equals("n") && !string2.equals("no")) continue;
            scanner.close();
            return false;
        }
        System.out.println("[Towny] Error recieving input, exiting.");
        return false;
    }

    public boolean loadAll() {
        return this.loadWorldList() && this.loadNationList() && this.loadTownList() && this.loadResidentList() && this.loadWorlds() && this.loadNations() && this.loadTowns() && this.loadResidents() && this.loadRegenList() && this.loadSnapshotList() && this.loadTownBlocks();
    }

    public boolean saveAll() {
        return this.saveWorldList() && this.saveNationList() && this.saveTownList() && this.saveResidentList() && this.saveWorlds() && this.saveNations() && this.saveTowns() && this.saveResidents() && this.saveAllTownBlocks() && this.saveRegenList() && this.saveSnapshotList();
    }

    public boolean saveAllWorlds() {
        return this.saveWorldList() && this.saveWorlds();
    }

    public boolean saveQueues() {
        return this.saveRegenList() && this.saveSnapshotList();
    }

    public abstract boolean loadResidentList();

    public abstract boolean loadTownList();

    public abstract boolean loadNationList();

    public abstract boolean loadWorldList();

    public abstract boolean loadRegenList();

    public abstract boolean loadSnapshotList();

    public abstract boolean loadTownBlocks();

    public abstract boolean loadResident(Resident var1);

    public abstract boolean loadTown(Town var1);

    public abstract boolean loadNation(Nation var1);

    public abstract boolean loadWorld(TownyWorld var1);

    public abstract boolean saveResidentList();

    public abstract boolean saveTownList();

    public abstract boolean saveNationList();

    public abstract boolean saveWorldList();

    public abstract boolean saveRegenList();

    public abstract boolean saveSnapshotList();

    public abstract boolean saveResident(Resident var1);

    public abstract boolean saveTown(Town var1);

    public abstract boolean saveNation(Nation var1);

    public abstract boolean saveWorld(TownyWorld var1);

    public abstract boolean saveAllTownBlocks();

    public abstract boolean saveTownBlock(TownBlock var1);

    public abstract boolean savePlotData(PlotBlockData var1);

    public abstract PlotBlockData loadPlotData(String var1, int var2, int var3);

    public abstract PlotBlockData loadPlotData(TownBlock var1);

    public abstract void deletePlotData(PlotBlockData var1);

    public abstract void deleteResident(Resident var1);

    public abstract void deleteTown(Town var1);

    public abstract void deleteNation(Nation var1);

    public abstract void deleteWorld(TownyWorld var1);

    public abstract void deleteTownBlock(TownBlock var1);

    public abstract void deleteFile(String var1);

    public boolean loadResidents() {
        TownyMessaging.sendDebugMsg("Loading Residents");
        ArrayList<Resident> arrayList = new ArrayList<Resident>();
        for (Resident resident : new ArrayList<Resident>(this.getResidents())) {
            if (this.loadResident(resident)) continue;
            System.out.println("[Towny] Loading Error: Could not read resident data '" + resident.getName() + "'.");
            arrayList.add(resident);
        }
        for (Resident resident : arrayList) {
            System.out.println("[Towny] Loading Error: Removing resident data for '" + resident.getName() + "'.");
            this.removeResidentList(resident);
        }
        return true;
    }

    public boolean loadTowns() {
        TownyMessaging.sendDebugMsg("Loading Towns");
        for (Town town : this.getTowns()) {
            if (this.loadTown(town)) continue;
            System.out.println("[Towny] Loading Error: Could not read town data " + town.getName() + "'.");
            return false;
        }
        return true;
    }

    public boolean loadNations() {
        TownyMessaging.sendDebugMsg("Loading Nations");
        for (Nation nation : this.getNations()) {
            if (this.loadNation(nation)) continue;
            System.out.println("[Towny] Loading Error: Could not read nation data '" + nation.getName() + "'.");
            return false;
        }
        return true;
    }

    public boolean loadWorlds() {
        TownyMessaging.sendDebugMsg("Loading Worlds");
        for (TownyWorld townyWorld : this.getWorlds()) {
            if (this.loadWorld(townyWorld)) continue;
            System.out.println("[Towny] Loading Error: Could not read world data '" + townyWorld.getName() + "'.");
            return false;
        }
        return true;
    }

    public boolean saveResidents() {
        TownyMessaging.sendDebugMsg("Saving Residents");
        for (Resident resident : this.getResidents()) {
            this.saveResident(resident);
        }
        return true;
    }

    public boolean saveTowns() {
        TownyMessaging.sendDebugMsg("Saving Towns");
        for (Town town : this.getTowns()) {
            this.saveTown(town);
        }
        return true;
    }

    public boolean saveNations() {
        TownyMessaging.sendDebugMsg("Saving Nations");
        for (Nation nation : this.getNations()) {
            this.saveNation(nation);
        }
        return true;
    }

    public boolean saveWorlds() {
        TownyMessaging.sendDebugMsg("Saving Worlds");
        for (TownyWorld townyWorld : this.getWorlds()) {
            this.saveWorld(townyWorld);
        }
        return true;
    }

    public abstract List<Resident> getResidents(Player var1, String[] var2);

    public abstract List<Resident> getResidents();

    public abstract List<Resident> getResidents(String[] var1);

    public abstract Resident getResident(String var1) throws NotRegisteredException;

    public abstract void removeResidentList(Resident var1);

    public abstract void removeNation(Nation var1);

    public abstract boolean hasResident(String var1);

    public abstract boolean hasTown(String var1);

    public abstract boolean hasNation(String var1);

    public abstract List<Town> getTowns(String[] var1);

    public abstract List<Town> getTowns();

    public abstract Town getTown(String var1) throws NotRegisteredException;

    public abstract List<Nation> getNations(String[] var1);

    public abstract List<Nation> getNations();

    public abstract Nation getNation(String var1) throws NotRegisteredException;

    public abstract TownyWorld getWorld(String var1) throws NotRegisteredException;

    public abstract List<TownyWorld> getWorlds();

    public abstract TownyWorld getTownWorld(String var1);

    public abstract void removeResident(Resident var1);

    public abstract void removeTownBlock(TownBlock var1);

    public abstract void removeTownBlocks(Town var1);

    public abstract List<TownBlock> getAllTownBlocks();

    public abstract void newResident(String var1) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void newTown(String var1) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void newNation(String var1) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void newWorld(String var1) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void removeTown(Town var1);

    public abstract void removeWorld(TownyWorld var1) throws UnsupportedOperationException;

    public abstract Set<String> getResidentKeys();

    public abstract Set<String> getTownsKeys();

    public abstract Set<String> getNationsKeys();

    public abstract List<Town> getTownsWithoutNation();

    public abstract List<Resident> getResidentsWithoutTown();

    public abstract void renameTown(Town var1, String var2) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void renameNation(Nation var1, String var2) throws AlreadyRegisteredException, NotRegisteredException;
}

