/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.db.TownyDatabaseHandler;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.KeyValueFile;
import com.palmergames.util.StringMgmt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;

public class TownyFlatFileSource
extends TownyDatabaseHandler {
    protected final String newLine = System.getProperty("line.separator");
    protected String rootFolder = "";
    protected String dataFolder = FileMgmt.fileSeparator() + "data";
    protected String settingsFolder = FileMgmt.fileSeparator() + "settings";
    protected String logFolder = FileMgmt.fileSeparator() + "logs";

    @Override
    public void initialize(Towny towny, TownyUniverse townyUniverse) {
        this.universe = townyUniverse;
        this.plugin = towny;
        this.rootFolder = townyUniverse.getRootFolder();
        try {
            FileMgmt.checkFolders(new String[]{this.rootFolder, this.rootFolder + this.dataFolder, this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "residents", this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "towns", this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "towns" + FileMgmt.fileSeparator() + "deleted", this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "nations", this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "nations" + FileMgmt.fileSeparator() + "deleted", this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "worlds", this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "worlds" + FileMgmt.fileSeparator() + "deleted", this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "plot-block-data", this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "townblocks"});
            FileMgmt.checkFiles(new String[]{this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "residents.txt", this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "towns.txt", this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "nations.txt", this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "worlds.txt", this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "regen.txt", this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "snapshot_queue.txt"});
        }
        catch (IOException iOException) {
            TownyMessaging.sendErrorMsg("Could not create flatfile default files and folders.");
        }
    }

    @Override
    public synchronized void backup() throws IOException {
        String string = TownySettings.getFlatFileBackupType();
        if (!string.equalsIgnoreCase("none")) {
            TownyLogger.shutDown();
            long l = System.currentTimeMillis();
            String string2 = this.rootFolder + FileMgmt.fileSeparator() + "backup" + FileMgmt.fileSeparator() + new SimpleDateFormat("yyyy-MM-dd HH-mm").format(l) + " - " + Long.toString(l);
            FileMgmt.checkFolders(new String[]{this.rootFolder, this.rootFolder + FileMgmt.fileSeparator() + "backup"});
            if (string.equalsIgnoreCase("folder")) {
                FileMgmt.checkFolders(new String[]{string2});
                FileMgmt.copyDirectory(new File(this.rootFolder + this.dataFolder), new File(string2));
                FileMgmt.copyDirectory(new File(this.rootFolder + this.logFolder), new File(string2));
                FileMgmt.copyDirectory(new File(this.rootFolder + this.settingsFolder), new File(string2));
            } else if (string.equalsIgnoreCase("zip")) {
                FileMgmt.zipDirectories(new File[]{new File(this.rootFolder + this.dataFolder), new File(this.rootFolder + this.logFolder), new File(this.rootFolder + this.settingsFolder)}, new File(string2 + ".zip"));
            } else {
                this.plugin.setupLogger();
                throw new IOException("Unsupported flatfile backup type (" + string + ")");
            }
            this.plugin.setupLogger();
        }
    }

    @Override
    public synchronized void deleteUnusedResidentFiles() {
        String string = this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "residents";
        Set<String> set = this.getResidentKeys();
        FileMgmt.deleteUnusedFiles(new File(string), set);
        string = this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "towns";
        set = this.getTownsKeys();
        FileMgmt.deleteUnusedFiles(new File(string), set);
        string = this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "nations";
        set = this.getNationsKeys();
        FileMgmt.deleteUnusedFiles(new File(string), set);
    }

    public String getResidentFilename(Resident resident) {
        return this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "residents" + FileMgmt.fileSeparator() + resident.getName() + ".txt";
    }

    public String getTownFilename(Town town) {
        return this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "towns" + FileMgmt.fileSeparator() + town.getName() + ".txt";
    }

    public String getNationFilename(Nation nation) {
        return this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "nations" + FileMgmt.fileSeparator() + nation.getName() + ".txt";
    }

    public String getWorldFilename(TownyWorld townyWorld) {
        return this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "worlds" + FileMgmt.fileSeparator() + townyWorld.getName() + ".txt";
    }

    public String getPlotFilename(PlotBlockData plotBlockData) {
        return this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "plot-block-data" + FileMgmt.fileSeparator() + plotBlockData.getWorldName() + FileMgmt.fileSeparator() + plotBlockData.getX() + "_" + plotBlockData.getZ() + "_" + plotBlockData.getSize() + ".data";
    }

    public String getPlotFilename(TownBlock townBlock) {
        return this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "plot-block-data" + FileMgmt.fileSeparator() + townBlock.getWorld().getName() + FileMgmt.fileSeparator() + townBlock.getX() + "_" + townBlock.getZ() + "_" + TownySettings.getTownBlockSize() + ".data";
    }

    public String getTownBlockFilename(TownBlock townBlock) {
        return this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "townblocks" + FileMgmt.fileSeparator() + townBlock.getWorld().getName() + FileMgmt.fileSeparator() + townBlock.getX() + "_" + townBlock.getZ() + "_" + TownySettings.getTownBlockSize() + ".data";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadResidentList() {
        TownyMessaging.sendDebugMsg("Loading Resident List");
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "residents.txt"));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.equals("")) continue;
                this.newResident(string);
            }
            boolean bl = true;
            return bl;
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            alreadyRegisteredException.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadTownList() {
        TownyMessaging.sendDebugMsg("Loading Town List");
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "towns.txt"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.equals("")) continue;
                this.newTown(string);
            }
            boolean bl = true;
            return bl;
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            alreadyRegisteredException.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadNationList() {
        TownyMessaging.sendDebugMsg("Loading Nation List");
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "nations.txt"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.equals("")) continue;
                this.newNation(string);
            }
            boolean bl = true;
            return bl;
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            alreadyRegisteredException.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadWorldList() {
        BufferedReader bufferedReader;
        Object object;
        if (this.plugin != null) {
            TownyMessaging.sendDebugMsg("Loading Server World List");
            object = this.plugin.getServer().getWorlds().iterator();
            while (object.hasNext()) {
                bufferedReader = (World)object.next();
                try {
                    this.newWorld(bufferedReader.getName());
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {
                }
                catch (NotRegisteredException notRegisteredException) {}
            }
        }
        TownyMessaging.sendDebugMsg("Loading World List");
        bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "worlds.txt"));
            while ((object = bufferedReader.readLine()) != null) {
                if (((String)object).equals("")) continue;
                this.newWorld((String)object);
            }
            boolean bl = true;
            return bl;
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadRegenList() {
        TownyMessaging.sendDebugMsg("Loading Regen List");
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "regen.txt"));
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                PlotBlockData plotBlockData;
                if (string.equals("") || (plotBlockData = this.loadPlotData((stringArray = string.split(","))[0], Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]))) == null) continue;
                TownyRegenAPI.addPlotChunk(plotBlockData, false);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadSnapshotList() {
        TownyMessaging.sendDebugMsg("Loading Snapshot Queue");
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "snapshot_queue.txt"));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.equals("")) continue;
                String[] stringArray = string.split(",");
                WorldCoord worldCoord = new WorldCoord(stringArray[0], Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
                TownyRegenAPI.addWorldCoord(worldCoord);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean loadResident(Resident resident) {
        String string = this.getResidentFilename(resident);
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            try {
                KeyValueFile keyValueFile = new KeyValueFile(string);
                resident.setLastOnline(Long.parseLong(keyValueFile.get("lastOnline")));
                String string2 = keyValueFile.get("registered");
                if (string2 != null) {
                    resident.setRegistered(Long.parseLong(string2));
                } else {
                    resident.setRegistered(resident.getLastOnline());
                }
                string2 = keyValueFile.get("isNPC");
                if (string2 != null) {
                    resident.setNPC(Boolean.parseBoolean(string2));
                }
                if ((string2 = keyValueFile.get("title")) != null) {
                    resident.setTitle(string2);
                }
                if ((string2 = keyValueFile.get("surname")) != null) {
                    resident.setSurname(string2);
                }
                if ((string2 = keyValueFile.get("town")) != null) {
                    resident.setTown(this.getTown(string2));
                }
                if ((string2 = keyValueFile.get("town-ranks")) != null) {
                    resident.setTownRanks(new ArrayList<String>(Arrays.asList(string2.split(","))));
                }
                if ((string2 = keyValueFile.get("nation-ranks")) != null) {
                    resident.setNationRanks(new ArrayList<String>(Arrays.asList(string2.split(","))));
                }
                if ((string2 = keyValueFile.get("friends")) != null) {
                    String[] stringArray;
                    for (String string3 : stringArray = string2.split(",")) {
                        Resident resident2;
                        if (string3.isEmpty() || (resident2 = this.getResident(string3)) == null) continue;
                        resident.addFriend(resident2);
                    }
                }
                if ((string2 = keyValueFile.get("protectionStatus")) != null) {
                    resident.setPermissions(string2);
                }
                if ((string2 = keyValueFile.get("townBlocks")) != null) {
                    this.utilLoadTownBlocks(string2, null, resident);
                }
            }
            catch (Exception exception) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading resident file " + resident.getName());
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean loadTown(Town town) {
        String string = this.getTownFilename(town);
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            block80: {
                try {
                    void var10_47;
                    int n;
                    World world;
                    Object object;
                    String[] stringArray;
                    KeyValueFile keyValueFile = new KeyValueFile(string);
                    String string2 = keyValueFile.get("residents");
                    if (string2 != null) {
                        stringArray = string2.split(",");
                        for (String d2 : stringArray) {
                            if (d2.isEmpty() || (object = this.getResident(d2)) == null) continue;
                            town.addResident((Resident)object);
                        }
                    }
                    if ((string2 = keyValueFile.get("mayor")) != null) {
                        town.setMayor(this.getResident(string2));
                    }
                    town.setTownBoard(keyValueFile.get("townBoard"));
                    string2 = keyValueFile.get("tag");
                    if (string2 != null) {
                        try {
                            town.setTag(string2);
                        }
                        catch (TownyException townyException) {
                            town.setTag("");
                        }
                    }
                    if ((string2 = keyValueFile.get("protectionStatus")) != null) {
                        town.setPermissions(string2);
                    }
                    if ((string2 = keyValueFile.get("bonusBlocks")) != null) {
                        try {
                            town.setBonusBlocks(Integer.parseInt(string2));
                        }
                        catch (Exception exception) {
                            town.setBonusBlocks(0);
                        }
                    }
                    if ((string2 = keyValueFile.get("purchasedBlocks")) != null) {
                        try {
                            town.setPurchasedBlocks(Integer.parseInt(string2));
                        }
                        catch (Exception exception) {
                            town.setPurchasedBlocks(0);
                        }
                    }
                    if ((string2 = keyValueFile.get("plotPrice")) != null) {
                        try {
                            town.setPlotPrice(Double.parseDouble(string2));
                        }
                        catch (Exception exception) {
                            town.setPlotPrice(0.0);
                        }
                    }
                    if ((string2 = keyValueFile.get("hasUpkeep")) != null) {
                        try {
                            town.setHasUpkeep(Boolean.parseBoolean(string2));
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((string2 = keyValueFile.get("taxpercent")) != null) {
                        try {
                            town.setTaxPercentage(Boolean.parseBoolean(string2));
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((string2 = keyValueFile.get("taxes")) != null) {
                        try {
                            town.setTaxes(Double.parseDouble(string2));
                        }
                        catch (Exception exception) {
                            town.setTaxes(0.0);
                        }
                    }
                    if ((string2 = keyValueFile.get("plotTax")) != null) {
                        try {
                            town.setPlotTax(Double.parseDouble(string2));
                        }
                        catch (Exception exception) {
                            town.setPlotTax(0.0);
                        }
                    }
                    if ((string2 = keyValueFile.get("commercialPlotPrice")) != null) {
                        try {
                            town.setCommercialPlotPrice(Double.parseDouble(string2));
                        }
                        catch (Exception exception) {
                            town.setCommercialPlotPrice(0.0);
                        }
                    }
                    if ((string2 = keyValueFile.get("commercialPlotTax")) != null) {
                        try {
                            town.setCommercialPlotTax(Double.parseDouble(string2));
                        }
                        catch (Exception exception) {
                            town.setCommercialPlotTax(0.0);
                        }
                    }
                    if ((string2 = keyValueFile.get("embassyPlotPrice")) != null) {
                        try {
                            town.setEmbassyPlotPrice(Double.parseDouble(string2));
                        }
                        catch (Exception exception) {
                            town.setEmbassyPlotPrice(0.0);
                        }
                    }
                    if ((string2 = keyValueFile.get("embassyPlotTax")) != null) {
                        try {
                            town.setEmbassyPlotTax(Double.parseDouble(string2));
                        }
                        catch (Exception exception) {
                            town.setEmbassyPlotTax(0.0);
                        }
                    }
                    if ((string2 = keyValueFile.get("adminDisabledPvP")) != null) {
                        try {
                            town.setAdminDisabledPVP(Boolean.parseBoolean(string2));
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((string2 = keyValueFile.get("open")) != null) {
                        try {
                            town.setOpen(Boolean.parseBoolean(string2));
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((string2 = keyValueFile.get("public")) != null) {
                        try {
                            town.setPublic(Boolean.parseBoolean(string2));
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((string2 = keyValueFile.get("townBlocks")) != null) {
                        this.utilLoadTownBlocks(string2, town, null);
                    }
                    if ((string2 = keyValueFile.get("homeBlock")) != null && (stringArray = string2.split(",")).length == 3) {
                        try {
                            world = this.getWorld(stringArray[0]);
                            try {
                                int numberFormatException = Integer.parseInt(stringArray[1]);
                                n = Integer.parseInt(stringArray[2]);
                                TownBlock townBlock = world.getTownBlock(numberFormatException, n);
                                town.setHomeBlock(townBlock);
                            }
                            catch (NumberFormatException notRegisteredException) {
                                TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid location.");
                            }
                            catch (NotRegisteredException townyException) {
                                TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid TownBlock.");
                            }
                            catch (TownyException d) {
                                TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " does not have a home block.");
                            }
                        }
                        catch (NotRegisteredException notRegisteredException) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid world.");
                        }
                    }
                    if ((string2 = keyValueFile.get("spawn")) != null && (stringArray = string2.split(",")).length >= 4) {
                        try {
                            world = this.plugin.getServerWorld(stringArray[0]);
                            double d = Double.parseDouble(stringArray[1]);
                            double d2 = Double.parseDouble(stringArray[2]);
                            double nullPointerException = Double.parseDouble(stringArray[3]);
                            Location location = new Location(world, d, d2, nullPointerException);
                            if (stringArray.length == 6) {
                                location.setPitch(Float.parseFloat(stringArray[4]));
                                location.setYaw(Float.parseFloat(stringArray[5]));
                            }
                            town.setSpawn(location);
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                        catch (NotRegisteredException notRegisteredException) {
                        }
                        catch (NullPointerException nullPointerException) {
                        }
                        catch (TownyException townyException) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " does not have a spawn point.");
                        }
                    }
                    if ((string2 = keyValueFile.get("outpostspawns")) == null) break block80;
                    world = string2.split(";");
                    Object object2 = world;
                    n = ((String[])object2).length;
                    boolean bl = false;
                    while (var10_47 < n) {
                        object = object2[var10_47];
                        stringArray = ((String)object).split(",");
                        if (stringArray.length >= 4) {
                            try {
                                World townyException = this.plugin.getServerWorld(stringArray[0]);
                                double d = Double.parseDouble(stringArray[1]);
                                double d3 = Double.parseDouble(stringArray[2]);
                                double d4 = Double.parseDouble(stringArray[3]);
                                Location location = new Location(townyException, d, d3, d4);
                                if (stringArray.length == 6) {
                                    location.setPitch(Float.parseFloat(stringArray[4]));
                                    location.setYaw(Float.parseFloat(stringArray[5]));
                                }
                                town.addOutpostSpawn(location);
                            }
                            catch (NumberFormatException numberFormatException) {
                            }
                            catch (NotRegisteredException notRegisteredException) {
                            }
                            catch (NullPointerException nullPointerException) {
                            }
                            catch (TownyException townyException) {
                                // empty catch block
                            }
                        }
                        ++var10_47;
                    }
                }
                catch (Exception exception) {
                    TownyMessaging.sendErrorMsg("Loading Error: Exception while reading town file " + town.getName());
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean loadNation(Nation nation) {
        String string = "";
        String string2 = this.getNationFilename(nation);
        File file = new File(string2);
        if (file.exists() && file.isFile()) {
            try {
                TownyEconomyObject townyEconomyObject;
                String[] stringArray;
                KeyValueFile keyValueFile = new KeyValueFile(string2);
                string = keyValueFile.get("towns");
                if (string != null) {
                    for (String string3 : stringArray = string.split(",")) {
                        if (string3.isEmpty() || (townyEconomyObject = this.getTown(string3)) == null) continue;
                        nation.addTown((Town)townyEconomyObject);
                    }
                }
                if ((string = keyValueFile.get("capital")) != null) {
                    nation.setCapital(this.getTown(string));
                }
                if ((string = keyValueFile.get("tag")) != null) {
                    try {
                        nation.setTag(string);
                    }
                    catch (TownyException townyException) {
                        nation.setTag("");
                    }
                }
                if ((string = keyValueFile.get("allies")) != null) {
                    for (String string3 : stringArray = string.split(",")) {
                        if (string3.isEmpty() || (townyEconomyObject = this.getNation(string3)) == null) continue;
                        nation.addAlly((Nation)townyEconomyObject);
                    }
                }
                if ((string = keyValueFile.get("enemies")) != null) {
                    for (String string3 : stringArray = string.split(",")) {
                        if (string3.isEmpty() || (townyEconomyObject = this.getNation(string3)) == null) continue;
                        nation.addEnemy((Nation)townyEconomyObject);
                    }
                }
                if ((string = keyValueFile.get("taxes")) != null) {
                    try {
                        nation.setTaxes(Double.parseDouble(string));
                    }
                    catch (Exception exception) {
                        nation.setTaxes(0.0);
                    }
                }
                if ((string = keyValueFile.get("neutral")) != null) {
                    try {
                        nation.setNeutral(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading nation file " + nation.getName());
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean loadWorld(TownyWorld townyWorld) {
        String string = "";
        String string2 = this.getWorldFilename(townyWorld);
        try {
            FileMgmt.checkFiles(new String[]{string2});
        }
        catch (IOException iOException) {
            TownyMessaging.sendErrorMsg("Loading Error: Exception while reading file " + string2);
        }
        File file = new File(string2);
        if (file.exists() && file.isFile()) {
            try {
                Object object;
                KeyValueFile keyValueFile = new KeyValueFile(string2);
                string = keyValueFile.get("towns");
                if (string != null) {
                    String[] stringArray = string.split(",");
                    for (String string3 : stringArray) {
                        Town object2;
                        if (string3.isEmpty() || (object2 = this.getTown(string3)) == null) continue;
                        object2.setWorld(townyWorld);
                    }
                }
                if ((string = keyValueFile.get("claimable")) != null) {
                    try {
                        townyWorld.setClaimable(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("pvp")) != null) {
                    try {
                        townyWorld.setPVP(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("forcepvp")) != null) {
                    try {
                        townyWorld.setForcePVP(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("forcetownmobs")) != null) {
                    try {
                        townyWorld.setForceTownMobs(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("worldmobs")) != null) {
                    try {
                        townyWorld.setWorldMobs(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("firespread")) != null) {
                    try {
                        townyWorld.setFire(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("forcefirespread")) != null) {
                    try {
                        townyWorld.setForceFire(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("explosions")) != null) {
                    try {
                        townyWorld.setExpl(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("forceexplosions")) != null) {
                    try {
                        townyWorld.setForceExpl(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("endermanprotect")) != null) {
                    try {
                        townyWorld.setEndermanProtect(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("disableplayertrample")) != null) {
                    try {
                        townyWorld.setDisablePlayerTrample(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("disablecreaturetrample")) != null) {
                    try {
                        townyWorld.setDisableCreatureTrample(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("unclaimedZoneBuild")) != null) {
                    try {
                        townyWorld.setUnclaimedZoneBuild(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("unclaimedZoneDestroy")) != null) {
                    try {
                        townyWorld.setUnclaimedZoneDestroy(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("unclaimedZoneSwitch")) != null) {
                    try {
                        townyWorld.setUnclaimedZoneSwitch(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("unclaimedZoneItemUse")) != null) {
                    try {
                        townyWorld.setUnclaimedZoneItemUse(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("unclaimedZoneName")) != null) {
                    try {
                        townyWorld.setUnclaimedZoneName(string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("unclaimedZoneIgnoreIds")) != null) {
                    try {
                        object = new ArrayList();
                        for (String string3 : string.split(",")) {
                            if (string3.isEmpty()) continue;
                            try {
                                object.add(Integer.parseInt(string3));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        townyWorld.setUnclaimedZoneIgnore((List<Integer>)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("usingPlotManagementDelete")) != null) {
                    try {
                        townyWorld.setUsingPlotManagementDelete(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("plotManagementDeleteIds")) != null) {
                    try {
                        object = new ArrayList();
                        for (String string4 : string.split(",")) {
                            if (string4.isEmpty()) continue;
                            try {
                                object.add(Integer.parseInt(string4));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        townyWorld.setPlotManagementDeleteIds((List<Integer>)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("usingPlotManagementMayorDelete")) != null) {
                    try {
                        townyWorld.setUsingPlotManagementMayorDelete(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("plotManagementMayorDelete")) != null) {
                    try {
                        object = new ArrayList();
                        for (String string5 : string.split(",")) {
                            if (string5.isEmpty()) continue;
                            try {
                                object.add(string5.toUpperCase().trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        townyWorld.setPlotManagementMayorDelete((List<String>)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("usingPlotManagementRevert")) != null) {
                    try {
                        townyWorld.setUsingPlotManagementRevert(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("usingPlotManagementRevertSpeed")) != null) {
                    try {
                        townyWorld.setPlotManagementRevertSpeed(Long.parseLong(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("plotManagementIgnoreIds")) != null) {
                    try {
                        object = new ArrayList();
                        for (String string6 : string.split(",")) {
                            if (string6.isEmpty()) continue;
                            try {
                                object.add(Integer.parseInt(string6));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        townyWorld.setPlotManagementIgnoreIds((List<Integer>)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("usingPlotManagementWildRegen")) != null) {
                    try {
                        townyWorld.setUsingPlotManagementWildRevert(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("PlotManagementWildRegenEntities")) != null) {
                    try {
                        object = new ArrayList();
                        for (String string7 : string.split(",")) {
                            if (string7.isEmpty()) continue;
                            try {
                                object.add(string7.trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        townyWorld.setPlotManagementWildRevertEntities((List<String>)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("usingPlotManagementWildRegenDelay")) != null) {
                    try {
                        townyWorld.setPlotManagementWildRevertDelay(Long.parseLong(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("usingTowny")) != null) {
                    try {
                        townyWorld.setUsingTowny(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading world file " + string2);
                return false;
            }
            return true;
        }
        TownyMessaging.sendErrorMsg("Loading Error: File error while reading " + townyWorld.getName());
        return false;
    }

    @Override
    public boolean loadTownBlocks() {
        String string = "";
        for (TownBlock townBlock : this.getAllTownBlocks()) {
            String string2 = this.getTownBlockFilename(townBlock);
            boolean bl = false;
            File file = new File(string2);
            if (!file.exists() || !file.isFile()) continue;
            try {
                KeyValueFile keyValueFile = new KeyValueFile(string2);
                string = keyValueFile.get("permissions");
                if (string != null) {
                    try {
                        townBlock.setPermissions(string.trim());
                        bl = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("changed")) != null) {
                    try {
                        townBlock.setChanged(Boolean.parseBoolean(string.trim()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = keyValueFile.get("locked")) != null) {
                    try {
                        townBlock.setLocked(Boolean.parseBoolean(string.trim()));
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading TownBlock file " + string2);
                return false;
            }
            if (bl) continue;
            try {
                if (townBlock.hasResident()) {
                    townBlock.setPermissions(townBlock.getResident().getPermissions().toString());
                    continue;
                }
                townBlock.setPermissions(townBlock.getTown().getPermissions().toString());
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveResidentList() {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "residents.txt"));
            for (Resident resident : this.getResidents()) {
                bufferedWriter.write(NameValidation.checkAndFilterPlayerName(resident.getName()) + this.newLine);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving residents list file");
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveTownList() {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "towns.txt"));
            for (Town town : this.getTowns()) {
                bufferedWriter.write(town.getName() + this.newLine);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving town list file");
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveNationList() {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "nations.txt"));
            for (Nation nation : this.getNations()) {
                bufferedWriter.write(nation.getName() + this.newLine);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving nation list file");
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveWorldList() {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "worlds.txt"));
            for (TownyWorld townyWorld : this.getWorlds()) {
                bufferedWriter.write(townyWorld.getName() + this.newLine);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving world list file");
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveRegenList() {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "regen.txt"));
            for (PlotBlockData plotBlockData : new ArrayList<PlotBlockData>(TownyRegenAPI.getPlotChunks().values())) {
                bufferedWriter.write(plotBlockData.getWorldName() + "," + plotBlockData.getX() + "," + plotBlockData.getZ() + this.newLine);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving regen file");
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveSnapshotList() {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "snapshot_queue.txt"));
            while (TownyRegenAPI.hasWorldCoords()) {
                WorldCoord worldCoord = TownyRegenAPI.getWorldCoord();
                bufferedWriter.write(worldCoord.getWorldName() + "," + worldCoord.getX() + "," + worldCoord.getZ() + this.newLine);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving snapshot_queue file");
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveResident(Resident resident) {
        BufferedWriter bufferedWriter = null;
        try {
            String string = this.getResidentFilename(resident);
            bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write("lastOnline=" + Long.toString(resident.getLastOnline()) + this.newLine);
            bufferedWriter.write("registered=" + Long.toString(resident.getRegistered()) + this.newLine);
            bufferedWriter.write("isNPC=" + Boolean.toString(resident.isNPC()) + this.newLine);
            bufferedWriter.write("title=" + resident.getTitle() + this.newLine);
            bufferedWriter.write("surname=" + resident.getSurname() + this.newLine);
            if (resident.hasTown()) {
                bufferedWriter.write("town=" + resident.getTown().getName() + this.newLine);
                bufferedWriter.write("town-ranks=" + StringMgmt.join(resident.getTownRanks(), ",") + this.newLine);
                bufferedWriter.write("nation-ranks=" + StringMgmt.join(resident.getNationRanks(), ",") + this.newLine);
            }
            bufferedWriter.write("friends=");
            for (Resident resident2 : resident.getFriends()) {
                bufferedWriter.write(resident2.getName() + ",");
            }
            bufferedWriter.write(this.newLine);
            bufferedWriter.write("townBlocks=" + this.utilSaveTownBlocks(new ArrayList<TownBlock>(resident.getTownBlocks())) + this.newLine);
            bufferedWriter.write("protectionStatus=" + resident.getPermissions().toString() + this.newLine);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving resident file (" + resident.getName() + ")");
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveTown(Town town) {
        BufferedWriter bufferedWriter = null;
        try {
            String string = this.getTownFilename(town);
            bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write("name=" + town.getName() + this.newLine);
            bufferedWriter.write("residents=" + StringMgmt.join(town.getResidents(), ",") + this.newLine);
            if (town.hasMayor()) {
                bufferedWriter.write("mayor=" + town.getMayor().getName() + this.newLine);
            }
            if (town.hasNation()) {
                bufferedWriter.write("nation=" + town.getNation().getName() + this.newLine);
            }
            bufferedWriter.write("assistants=");
            for (Resident object : town.getAssistants()) {
                bufferedWriter.write(object.getName() + ",");
            }
            bufferedWriter.write(this.newLine);
            bufferedWriter.write("townBoard=" + town.getTownBoard() + this.newLine);
            bufferedWriter.write("tag=" + town.getTag() + this.newLine);
            bufferedWriter.write("protectionStatus=" + town.getPermissions().toString() + this.newLine);
            bufferedWriter.write("bonusBlocks=" + Integer.toString(town.getBonusBlocks()) + this.newLine);
            bufferedWriter.write("purchasedBlocks=" + Integer.toString(town.getPurchasedBlocks()) + this.newLine);
            bufferedWriter.write("taxpercent=" + Boolean.toString(town.isTaxPercentage()) + this.newLine);
            bufferedWriter.write("taxes=" + Double.toString(town.getTaxes()) + this.newLine);
            bufferedWriter.write("plotPrice=" + Double.toString(town.getPlotPrice()) + this.newLine);
            bufferedWriter.write("plotTax=" + Double.toString(town.getPlotTax()) + this.newLine);
            bufferedWriter.write("commercialPlotPrice=" + Double.toString(town.getCommercialPlotPrice()) + this.newLine);
            bufferedWriter.write("commercialPlotTax=" + Double.toString(town.getCommercialPlotTax()) + this.newLine);
            bufferedWriter.write("embassyPlotPrice=" + Double.toString(town.getEmbassyPlotPrice()) + this.newLine);
            bufferedWriter.write("embassyPlotTax=" + Double.toString(town.getEmbassyPlotTax()) + this.newLine);
            bufferedWriter.write("hasUpkeep=" + Boolean.toString(town.hasUpkeep()) + this.newLine);
            bufferedWriter.write("open=" + Boolean.toString(town.isOpen()) + this.newLine);
            bufferedWriter.write("adminDisabledPvP=" + Boolean.toString(town.isAdminDisabledPVP()) + this.newLine);
            bufferedWriter.write("public=" + Boolean.toString(town.isPublic()) + this.newLine);
            bufferedWriter.write("townBlocks=" + this.utilSaveTownBlocks(new ArrayList<TownBlock>(town.getTownBlocks())) + this.newLine);
            if (town.hasHomeBlock()) {
                bufferedWriter.write("homeBlock=" + town.getHomeBlock().getWorld().getName() + "," + Integer.toString(town.getHomeBlock().getX()) + "," + Integer.toString(town.getHomeBlock().getZ()) + this.newLine);
            }
            if (town.hasSpawn()) {
                bufferedWriter.write("spawn=" + town.getSpawn().getWorld().getName() + "," + Double.toString(town.getSpawn().getX()) + "," + Double.toString(town.getSpawn().getY()) + "," + Double.toString(town.getSpawn().getZ()) + "," + Float.toString(town.getSpawn().getPitch()) + "," + Float.toString(town.getSpawn().getYaw()) + this.newLine);
            }
            if (town.hasOutpostSpawn()) {
                Object object = "outpostspawns=";
                for (Location location : new ArrayList<Location>(town.getAllOutpostSpawns())) {
                    object = (String)object + location.getWorld().getName() + "," + Double.toString(location.getX()) + "," + Double.toString(location.getY()) + "," + Double.toString(location.getZ()) + "," + Float.toString(location.getPitch()) + "," + Float.toString(location.getYaw()) + ";";
                }
                bufferedWriter.write((String)object);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving town file (" + town.getName() + ")");
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveNation(Nation nation) {
        BufferedWriter bufferedWriter = null;
        try {
            String string = this.getNationFilename(nation);
            bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write("towns=");
            for (Town townyEconomyObject : nation.getTowns()) {
                bufferedWriter.write(townyEconomyObject.getName() + ",");
            }
            bufferedWriter.write(this.newLine);
            if (nation.hasCapital()) {
                bufferedWriter.write("capital=" + nation.getCapital().getName() + this.newLine);
            }
            if (nation.hasTag()) {
                bufferedWriter.write("tag=" + nation.getTag() + this.newLine);
            }
            bufferedWriter.write("assistants=");
            for (Resident iOException : nation.getAssistants()) {
                bufferedWriter.write(iOException.getName() + ",");
            }
            bufferedWriter.write(this.newLine);
            bufferedWriter.write("allies=");
            for (Nation nation2 : nation.getAllies()) {
                bufferedWriter.write(nation2.getName() + ",");
            }
            bufferedWriter.write(this.newLine);
            bufferedWriter.write("enemies=");
            for (Nation nation3 : nation.getEnemies()) {
                bufferedWriter.write(nation3.getName() + ",");
            }
            bufferedWriter.write(this.newLine);
            bufferedWriter.write("taxes=" + Double.toString(nation.getTaxes()) + this.newLine);
            bufferedWriter.write("neutral=" + Boolean.toString(nation.isNeutral()) + this.newLine);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving nation file (" + nation.getName() + ")");
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveWorld(TownyWorld townyWorld) {
        BufferedWriter bufferedWriter = null;
        try {
            String string = this.getWorldFilename(townyWorld);
            bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write("towns=");
            for (Town town : townyWorld.getTowns()) {
                TownyMessaging.sendDebugMsg("   Town - " + town.getName());
                bufferedWriter.write(town.getName() + ",");
            }
            bufferedWriter.write(this.newLine);
            bufferedWriter.write(this.newLine);
            bufferedWriter.write("pvp=" + Boolean.toString(townyWorld.isPVP()) + this.newLine);
            bufferedWriter.write("forcepvp=" + Boolean.toString(townyWorld.isForcePVP()) + this.newLine);
            bufferedWriter.write("# Can players found towns and claim plots in this world?" + this.newLine);
            bufferedWriter.write("claimable=" + Boolean.toString(townyWorld.isClaimable()) + this.newLine);
            bufferedWriter.write("worldmobs=" + Boolean.toString(townyWorld.hasWorldMobs()) + this.newLine);
            bufferedWriter.write("forcetownmobs=" + Boolean.toString(townyWorld.isForceTownMobs()) + this.newLine);
            bufferedWriter.write("firespread=" + Boolean.toString(townyWorld.isFire()) + this.newLine);
            bufferedWriter.write("forcefirespread=" + Boolean.toString(townyWorld.isForceFire()) + this.newLine);
            bufferedWriter.write("explosions=" + Boolean.toString(townyWorld.isExpl()) + this.newLine);
            bufferedWriter.write("forceexplosions=" + Boolean.toString(townyWorld.isForceExpl()) + this.newLine);
            bufferedWriter.write("endermanprotect=" + Boolean.toString(townyWorld.isEndermanProtect()) + this.newLine);
            bufferedWriter.write("disableplayertrample=" + Boolean.toString(townyWorld.isDisablePlayerTrample()) + this.newLine);
            bufferedWriter.write("disablecreaturetrample=" + Boolean.toString(townyWorld.isDisableCreatureTrample()) + this.newLine);
            bufferedWriter.write(this.newLine);
            bufferedWriter.write("# Unclaimed Zone settings." + this.newLine);
            if (townyWorld.getUnclaimedZoneBuild() != null) {
                bufferedWriter.write("unclaimedZoneBuild=" + Boolean.toString(townyWorld.getUnclaimedZoneBuild()) + this.newLine);
            }
            if (townyWorld.getUnclaimedZoneDestroy() != null) {
                bufferedWriter.write("unclaimedZoneDestroy=" + Boolean.toString(townyWorld.getUnclaimedZoneDestroy()) + this.newLine);
            }
            if (townyWorld.getUnclaimedZoneSwitch() != null) {
                bufferedWriter.write("unclaimedZoneSwitch=" + Boolean.toString(townyWorld.getUnclaimedZoneSwitch()) + this.newLine);
            }
            if (townyWorld.getUnclaimedZoneItemUse() != null) {
                bufferedWriter.write("unclaimedZoneItemUse=" + Boolean.toString(townyWorld.getUnclaimedZoneItemUse()) + this.newLine);
            }
            if (townyWorld.getUnclaimedZoneName() != null) {
                bufferedWriter.write("unclaimedZoneName=" + townyWorld.getUnclaimedZoneName() + this.newLine);
            }
            bufferedWriter.write(this.newLine);
            bufferedWriter.write("# The following settings are only used if you are not using any permissions provider plugin" + this.newLine);
            if (townyWorld.getUnclaimedZoneIgnoreIds() != null) {
                bufferedWriter.write("unclaimedZoneIgnoreIds=" + StringMgmt.join(townyWorld.getUnclaimedZoneIgnoreIds(), ",") + this.newLine);
            }
            bufferedWriter.write(this.newLine);
            bufferedWriter.write("# The following settings control what blocks are deleted upon a townblock being unclaimed" + this.newLine);
            bufferedWriter.write("usingPlotManagementDelete=" + Boolean.toString(townyWorld.isUsingPlotManagementDelete()) + this.newLine);
            if (townyWorld.getPlotManagementDeleteIds() != null) {
                bufferedWriter.write("plotManagementDeleteIds=" + StringMgmt.join(townyWorld.getPlotManagementDeleteIds(), ",") + this.newLine);
            }
            bufferedWriter.write(this.newLine);
            bufferedWriter.write("# The following settings control what blocks are deleted upon a mayor issuing a '/plot clear' command" + this.newLine);
            bufferedWriter.write("usingPlotManagementMayorDelete=" + Boolean.toString(townyWorld.isUsingPlotManagementMayorDelete()) + this.newLine);
            if (townyWorld.getPlotManagementMayorDelete() != null) {
                bufferedWriter.write("plotManagementMayorDelete=" + StringMgmt.join(townyWorld.getPlotManagementMayorDelete(), ",") + this.newLine);
            }
            bufferedWriter.write(this.newLine + "# If enabled when a town claims a townblock a snapshot will be taken at the time it is claimed." + this.newLine);
            bufferedWriter.write("# When the townblock is unclaimded its blocks will begin to revert to the original snapshot." + this.newLine);
            bufferedWriter.write("usingPlotManagementRevert=" + Boolean.toString(townyWorld.isUsingPlotManagementRevert()) + this.newLine);
            bufferedWriter.write("usingPlotManagementRevertSpeed=" + Long.toString(townyWorld.getPlotManagementRevertSpeed()) + this.newLine);
            bufferedWriter.write("# Any block Id's listed here will not be respawned. Instead it will revert to air." + this.newLine);
            if (townyWorld.getPlotManagementIgnoreIds() != null) {
                bufferedWriter.write("plotManagementIgnoreIds=" + StringMgmt.join(townyWorld.getPlotManagementIgnoreIds(), ",") + this.newLine);
            }
            bufferedWriter.write(this.newLine);
            bufferedWriter.write("# If enabled any damage caused by explosions will repair itself." + this.newLine);
            bufferedWriter.write("usingPlotManagementWildRegen=" + Boolean.toString(townyWorld.isUsingPlotManagementWildRevert()) + this.newLine);
            if (townyWorld.getPlotManagementWildRevertEntities() != null) {
                bufferedWriter.write("PlotManagementWildRegenEntities=" + StringMgmt.join(townyWorld.getPlotManagementWildRevertEntities(), ",") + this.newLine);
            }
            bufferedWriter.write("usingPlotManagementWildRegenDelay=" + Long.toString(townyWorld.getPlotManagementWildRevertDelay()) + this.newLine);
            bufferedWriter.write(this.newLine);
            bufferedWriter.write("# This setting is used to enable or disable Towny in this world." + this.newLine);
            bufferedWriter.write("usingTowny=" + Boolean.toString(townyWorld.isUsingTowny()) + this.newLine);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving world file (" + townyWorld.getName() + ")");
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean saveAllTownBlocks() {
        for (TownyWorld townyWorld : this.getWorlds()) {
            for (TownBlock townBlock : townyWorld.getTownBlocks()) {
                this.saveTownBlock(townBlock);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveTownBlock(TownBlock townBlock) {
        FileMgmt.checkFolders(new String[]{this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "townblocks" + FileMgmt.fileSeparator() + townBlock.getWorld().getName()});
        BufferedWriter bufferedWriter = null;
        String string = this.getTownBlockFilename(townBlock);
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write("permissions=" + townBlock.getPermissions().toString() + this.newLine);
            bufferedWriter.write("changed=" + Boolean.toString(townBlock.isChanged()) + this.newLine);
            bufferedWriter.write("locked=" + Boolean.toString(townBlock.isLocked()) + this.newLine);
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving TownBlock file (" + string + ")");
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public void utilLoadTownBlocks(String string, Town town, Resident resident) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("\\|")) {
            String[] stringArray2 = string2.split(":");
            if (stringArray2.length != 2) {
                TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " BlockList does not have a World or data.");
                continue;
            }
            try {
                TownyWorld townyWorld = this.getWorld(stringArray2[0]);
                for (String string3 : stringArray2[1].split(";")) {
                    String[] stringArray3;
                    String string4 = null;
                    int n = string3.indexOf("[");
                    if (n != -1) {
                        int n2 = string3.indexOf("]");
                        if (n2 != -1) {
                            string4 = string3.substring(n + 1, n2);
                        }
                        string3 = string3.substring(n2 + 1);
                    }
                    if ((stringArray3 = string3.split(",")).length < 2) continue;
                    try {
                        int n3 = Integer.parseInt(stringArray3[0]);
                        int n4 = Integer.parseInt(stringArray3[1]);
                        try {
                            townyWorld.newTownBlock(n3, n4);
                        }
                        catch (AlreadyRegisteredException alreadyRegisteredException) {
                            // empty catch block
                        }
                        TownBlock townBlock = townyWorld.getTownBlock(n3, n4);
                        if (town != null) {
                            townBlock.setTown(town);
                        }
                        if (resident != null && townBlock.hasTown()) {
                            townBlock.setResident(resident);
                        }
                        if (string4 != null) {
                            this.utilLoadTownBlockTypeData(townBlock, string4);
                        }
                        if (stringArray3.length < 3) continue;
                        if (stringArray3[2] == "true") {
                            townBlock.setPlotPrice(town.getPlotPrice());
                            continue;
                        }
                        townBlock.setPlotPrice(Double.parseDouble(stringArray3[2]));
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    public void utilLoadTownBlockTypeData(TownBlock townBlock, String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length >= 1) {
            townBlock.setType(Integer.valueOf(stringArray[0]));
        }
        if (stringArray.length >= 2) {
            townBlock.setOutpost(stringArray[1].equalsIgnoreCase("1"));
        }
    }

    public String utilSaveTownBlocks(List<TownBlock> list) {
        HashMap hashMap = new HashMap();
        String string = "";
        for (TownBlock object : list) {
            TownyWorld townyWorld = object.getWorld();
            if (!hashMap.containsKey(townyWorld)) {
                hashMap.put(townyWorld, new ArrayList());
            }
            ((ArrayList)hashMap.get(townyWorld)).add(object);
        }
        for (TownyWorld townyWorld : hashMap.keySet()) {
            string = string + townyWorld.getName() + ":";
            for (TownBlock townBlock : (ArrayList)hashMap.get(townyWorld)) {
                string = string + "[" + townBlock.getType().getId();
                string = string + "," + (townBlock.isOutpost() ? "1" : "0");
                string = string + "]" + townBlock.getX() + "," + townBlock.getZ() + "," + townBlock.getPlotPrice() + ";";
            }
            string = string + "|";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean savePlotData(PlotBlockData plotBlockData) {
        FileMgmt.checkFolders(new String[]{this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "plot-block-data" + FileMgmt.fileSeparator() + plotBlockData.getWorldName()});
        FilterOutputStream filterOutputStream = null;
        String string = this.getPlotFilename(plotBlockData);
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            switch (plotBlockData.getVersion()) {
                case 1: {
                    filterOutputStream.write("VER".getBytes(Charset.forName("UTF-8")));
                    ((BufferedOutputStream)filterOutputStream).write(plotBlockData.getVersion());
                    break;
                }
            }
            ((BufferedOutputStream)filterOutputStream).write(plotBlockData.getHeight());
            for (int n : new ArrayList<Integer>(plotBlockData.getBlockList())) {
                ((BufferedOutputStream)filterOutputStream).write(n);
            }
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving PlotBlockData file (" + string + ")");
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    @Override
    public PlotBlockData loadPlotData(String string, int n, int n2) {
        try {
            TownyWorld townyWorld = this.getWorld(string);
            TownBlock townBlock = new TownBlock(n, n2, townyWorld);
            return this.loadPlotData(townBlock);
        }
        catch (NotRegisteredException notRegisteredException) {
            notRegisteredException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlotBlockData loadPlotData(TownBlock townBlock) {
        String string = this.getPlotFilename(townBlock);
        if (this.isFile(string)) {
            PlotBlockData plotBlockData = new PlotBlockData(townBlock);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            BufferedInputStream bufferedInputStream = null;
            try {
                int n;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                byte[] byArray = new byte[3];
                bufferedInputStream.read(byArray, 0, 3);
                String string2 = new String(byArray);
                switch (elements.fromString(string2)) {
                    case VER: {
                        int n2 = bufferedInputStream.read();
                        plotBlockData.setVersion(n2);
                        plotBlockData.setHeight(bufferedInputStream.read());
                        break;
                    }
                    default: {
                        plotBlockData.setVersion(0);
                        plotBlockData.setHeight(byArray[0]);
                        arrayList.add(Integer.valueOf(byArray[1]));
                        arrayList.add(Integer.valueOf(byArray[2]));
                    }
                }
                while ((n = bufferedInputStream.read()) >= 0) {
                    arrayList.add(n);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            plotBlockData.setBlockList(arrayList);
            plotBlockData.resetBlockListRestored();
            return plotBlockData;
        }
        return null;
    }

    @Override
    public void deletePlotData(PlotBlockData plotBlockData) {
        File file = new File(this.getPlotFilename(plotBlockData));
        if (file.exists()) {
            file.delete();
        }
    }

    private boolean isFile(String string) {
        File file = new File(string);
        return file.exists() && file.isFile();
    }

    @Override
    public void deleteFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void deleteResident(Resident resident) {
        File file = new File(this.getResidentFilename(resident));
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void deleteTown(Town town) {
        File file = new File(this.getTownFilename(town));
        if (file.exists()) {
            try {
                FileMgmt.moveFile(file, "deleted");
            }
            catch (IOException iOException) {
                TownyMessaging.sendErrorMsg("Error moving Town txt file.");
                file.delete();
            }
        }
    }

    @Override
    public void deleteNation(Nation nation) {
        File file = new File(this.getNationFilename(nation));
        if (file.exists()) {
            try {
                FileMgmt.moveFile(file, "deleted");
            }
            catch (IOException iOException) {
                TownyMessaging.sendErrorMsg("Error moving Nation txt file.");
                file.delete();
            }
        }
    }

    @Override
    public void deleteWorld(TownyWorld townyWorld) {
        File file = new File(this.getWorldFilename(townyWorld));
        if (file.exists()) {
            try {
                FileMgmt.moveFile(file, "deleted");
            }
            catch (IOException iOException) {
                TownyMessaging.sendErrorMsg("Error moving World txt file.");
            }
        }
    }

    @Override
    public void deleteTownBlock(TownBlock townBlock) {
        File file = new File(this.getTownBlockFilename(townBlock));
        if (file.exists()) {
            file.delete();
        }
    }

    private static enum elements {
        VER,
        novalue;


        public static elements fromString(String string) {
            try {
                return elements.valueOf(string);
            }
            catch (Exception exception) {
                return novalue;
            }
        }
    }
}

