/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.ChunkNotification;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.command.TownyCommand;
import com.palmergames.bukkit.towny.event.PlayerChangePlotEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.CellBorder;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.BorderUtil;
import com.palmergames.bukkit.util.DrawSmokeTaskFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class TownyCustomListener
implements Listener {
    private final Towny plugin;

    public TownyCustomListener(Towny towny) {
        this.plugin = towny;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChangePlotEvent(PlayerChangePlotEvent playerChangePlotEvent) {
        Object object;
        Player player = playerChangePlotEvent.getPlayer();
        WorldCoord worldCoord = playerChangePlotEvent.getFrom();
        WorldCoord worldCoord2 = playerChangePlotEvent.getTo();
        if (this.plugin.hasPlayerMode(player, "townclaim")) {
            TownCommand.parseTownClaimCommand(player, new String[0]);
        }
        if (this.plugin.hasPlayerMode(player, "townunclaim")) {
            TownCommand.parseTownUnclaimCommand(player, new String[0]);
        }
        if (this.plugin.hasPlayerMode(player, "map")) {
            TownyCommand.showMap(player);
        }
        try {
            String string;
            if (worldCoord2.getTownyWorld().isUsingTowny() && TownySettings.getShowTownNotifications() && (string = ((ChunkNotification)(object = new ChunkNotification(worldCoord, worldCoord2))).getNotificationString()) != null) {
                player.sendMessage(string);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            notRegisteredException.printStackTrace();
        }
        if (this.plugin.hasPlayerMode(player, "plotborder")) {
            object = BorderUtil.getPlotBorder(worldCoord2);
            ((CellBorder)object).runBorderedOnSurface(1, 2, DrawSmokeTaskFactory.sendToPlayer(player));
        }
    }
}

