/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.towny.war.eventwar.WarSpoils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class TownyEntityMonitorListener
implements Listener {
    private final Towny plugin;

    public TownyEntityMonitorListener(Towny towny) {
        this.plugin = towny;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent entityDeathEvent) {
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        TownyWorld townyWorld = null;
        try {
            townyWorld = TownyUniverse.getDataSource().getWorld(livingEntity.getLocation().getWorld().getName());
            if (!townyWorld.isUsingTowny()) {
                return;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            return;
        }
        if (livingEntity instanceof Player && livingEntity.getLastDamageCause() instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)livingEntity.getLastDamageCause();
            Entity entity = entityDamageByEntityEvent.getDamager();
            Player player = (Player)livingEntity;
            Player player2 = null;
            Resident resident = null;
            Resident resident2 = null;
            try {
                resident2 = TownyUniverse.getDataSource().getResident(player.getName());
            }
            catch (NotRegisteredException notRegisteredException) {
                return;
            }
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                if (projectile.getShooter() instanceof Player) {
                    player2 = (Player)projectile.getShooter();
                    try {
                        resident = TownyUniverse.getDataSource().getResident(player2.getName());
                    }
                    catch (NotRegisteredException notRegisteredException) {}
                }
            } else if (entity instanceof Player) {
                player2 = (Player)entity;
                try {
                    resident = TownyUniverse.getDataSource().getResident(player2.getName());
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
            this.deathPayment(player2, player, resident, resident2);
            this.wartimeDeathPoints(player2, player, resident, resident2);
            if (TownySettings.isRemovingOnMonarchDeath()) {
                this.monarchDeath(player2, player, resident, resident2);
            }
        }
    }

    private void wartimeDeathPoints(Player player, Player player2, Resident resident, Resident resident2) {
        if (player != null && player2 != null && TownyUniverse.isWarTime()) {
            try {
                if (CombatUtil.isAlly(player.getName(), player2.getName())) {
                    return;
                }
                if (TownySettings.getWarPointsForKill() > 0) {
                    this.plugin.getTownyUniverse().getWarEvent().townScored(resident.getTown(), TownySettings.getWarPointsForKill());
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    private void monarchDeath(Player player, Player player2, Resident resident, Resident resident2) {
        if (TownyUniverse.isWarTime()) {
            War war = this.plugin.getTownyUniverse().getWarEvent();
            try {
                Nation nation = resident2.getTown().getNation();
                if (war.isWarringNation(nation) && resident2.isMayor()) {
                    if (resident2.isKing()) {
                        if (resident != null && resident.hasTown()) {
                            war.remove(resident.getTown(), nation);
                        } else {
                            war.remove(nation);
                        }
                        TownyMessaging.sendGlobalMessage(nation.getName() + "'s king was killed. Nation removed from war.");
                    } else {
                        if (resident != null && resident.hasTown()) {
                            war.remove(resident.getTown(), resident2.getTown());
                        } else {
                            war.remove(resident2.getTown());
                        }
                        TownyMessaging.sendGlobalMessage(resident2.getTown() + "'s mayor was killed. Town removed from war.");
                    }
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    public void deathPayment(Player player, Player player2, Resident resident, Resident resident2) {
        if (player != null && TownyUniverse.isWarTime() && TownySettings.getWartimeDeathPrice() > 0.0) {
            try {
                if (resident == null) {
                    throw new NotRegisteredException(String.format("The attackingResident %s has not been registered.", player.getName()));
                }
                double d = TownySettings.getWartimeDeathPrice();
                double d2 = 0.0;
                if (!resident2.canPayFromHoldings(d)) {
                    d2 = d - resident2.getHoldingBalance();
                    d = resident2.getHoldingBalance();
                }
                if (d > 0.0) {
                    resident2.payTo(d, resident, "Death Payment (War)");
                    TownyMessaging.sendMsg((Object)player, "You robbed " + resident2.getName() + " of " + TownyEconomyHandler.getFormattedBalance(d) + ".");
                    TownyMessaging.sendMsg((Object)player2, resident.getName() + " robbed you of " + TownyEconomyHandler.getFormattedBalance(d) + ".");
                }
                if (d2 > 0.0) {
                    Town town = resident2.getTown();
                    if (!town.canPayFromHoldings(d2)) {
                        d2 = town.getHoldingBalance();
                        try {
                            this.plugin.getTownyUniverse().getWarEvent().remove(resident.getTown(), town);
                        }
                        catch (NotRegisteredException notRegisteredException) {
                            this.plugin.getTownyUniverse().getWarEvent().remove(town);
                        }
                    } else {
                        TownyMessaging.sendTownMessage(town, resident2.getName() + "'s wallet couldn't satisfy " + resident.getName() + ". " + d2 + " taken from town bank.");
                    }
                    town.payTo(d2, resident, String.format("Death Payment (War) (%s couldn't pay)", resident2.getName()));
                }
            }
            catch (NotRegisteredException notRegisteredException) {
            }
            catch (EconomyException economyException) {
                TownyMessaging.sendErrorMsg((Object)player, "Could not take wartime death funds.");
                TownyMessaging.sendErrorMsg((Object)player2, "Could not take wartime death funds.");
            }
        } else if (TownySettings.getDeathPrice() > 0.0) {
            try {
                double d = TownySettings.getDeathPrice();
                if (!resident2.canPayFromHoldings(d)) {
                    d = resident2.getHoldingBalance();
                }
                resident2.payTo(d, new WarSpoils(), "Death Payment");
                TownyMessaging.sendMsg((Object)player2, "You lost " + TownyEconomyHandler.getFormattedBalance(d) + ".");
            }
            catch (EconomyException economyException) {
                TownyMessaging.sendErrorMsg((Object)player2, "Could not take death funds.");
            }
        }
    }
}

