/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;

public class TownyWorldListener
implements Listener {
    public TownyWorldListener(Towny towny) {
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onWorldLoad(WorldLoadEvent worldLoadEvent) {
        this.newWorld(worldLoadEvent.getWorld().getName());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onWorldInit(WorldInitEvent worldInitEvent) {
        this.newWorld(worldInitEvent.getWorld().getName());
    }

    private void newWorld(String string) {
        try {
            TownyUniverse.getDataSource().newWorld(string);
            TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(string);
            if (townyWorld == null) {
                TownyMessaging.sendErrorMsg("Could not create data for " + string);
            } else if (!TownyUniverse.getDataSource().loadWorld(townyWorld)) {
                TownyUniverse.getDataSource().saveWorld(townyWorld);
            }
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
        }
        catch (NotRegisteredException notRegisteredException) {
            TownyMessaging.sendErrorMsg("Could not create data for " + string);
            notRegisteredException.printStackTrace();
        }
    }
}

