/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.util.DrawUtil;
import com.palmergames.bukkit.util.LocationRunnable;
import java.util.Arrays;
import org.bukkit.World;

public class CellBorder
extends WorldCoord {
    public boolean[] border;

    public CellBorder(WorldCoord worldCoord, boolean[] blArray) {
        super(worldCoord);
        this.border = blArray;
    }

    public void setBorderAt(Section section, boolean bl) {
        this.border[section.ordinal()] = bl;
    }

    public boolean hasBorderAt(Section section) {
        return this.border[section.ordinal()];
    }

    public boolean[] getBorder() {
        return this.border;
    }

    public boolean hasAnyBorder() {
        for (boolean bl : this.border) {
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public int getBlockX() {
        return this.getX() * CellBorder.getCellSize();
    }

    public int getBlockZ() {
        return this.getZ() * CellBorder.getCellSize();
    }

    public void runBorderedOnSurface(int n, int n2, LocationRunnable locationRunnable) {
        int n3 = this.getBlockX();
        int n4 = this.getBlockZ();
        int n5 = Coord.getCellSize() - 1;
        World world = this.getBukkitWorld();
        block10: for (Section section : Section.values()) {
            if (!this.border[section.ordinal()] || (section.getType() != Section.Type.WALL || n <= 0) && (section.getType() != Section.Type.CORNER || n2 <= 0)) continue;
            switch (section) {
                case N: {
                    DrawUtil.runOnSurface(world, n3, n4, n3, n4 + n5, n, locationRunnable);
                    continue block10;
                }
                case NE: {
                    DrawUtil.runOnSurface(world, n3, n4, n3, n4, n2, locationRunnable);
                    continue block10;
                }
                case E: {
                    DrawUtil.runOnSurface(world, n3, n4, n3 + n5, n4, n, locationRunnable);
                    continue block10;
                }
                case SE: {
                    DrawUtil.runOnSurface(world, n3 + n5, n4, n3 + n5, n4, n2, locationRunnable);
                    continue block10;
                }
                case S: {
                    DrawUtil.runOnSurface(world, n3 + n5, n4, n3 + n5, n4 + n5, n, locationRunnable);
                    continue block10;
                }
                case SW: {
                    DrawUtil.runOnSurface(world, n3 + n5, n4 + n5, n3 + n5, n4 + n5, n2, locationRunnable);
                    continue block10;
                }
                case W: {
                    DrawUtil.runOnSurface(world, n3, n4 + n5, n3 + n5, n4 + n5, n, locationRunnable);
                    continue block10;
                }
                case NW: {
                    DrawUtil.runOnSurface(world, n3, n4 + n5, n3, n4 + n5, n2, locationRunnable);
                }
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + Arrays.toString(this.getBorder());
    }

    public static enum Section {
        N(Type.WALL),
        NE(Type.CORNER),
        E(Type.WALL),
        SE(Type.CORNER),
        S(Type.WALL),
        SW(Type.CORNER),
        W(Type.WALL),
        NW(Type.CORNER);

        private Type type;

        private Section(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public static int numParts() {
            return Section.values().length;
        }

        public static enum Type {
            WALL,
            CORNER;

        }
    }
}

