/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;

public class Coord {
    protected static int cellSize = 16;
    protected int x;
    protected int z;

    public Coord(int n, int n2) {
        this.x = n;
        this.z = n2;
    }

    public Coord(Coord coord) {
        this.x = coord.getX();
        this.z = coord.getZ();
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int n) {
        this.z = n;
    }

    public Coord add(int n, int n2) {
        return new Coord(this.getX() + n, this.getZ() + n2);
    }

    public int hashCode() {
        int n = 17;
        n = 27 * n + this.x;
        n = 27 * n + this.z;
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Coord)) {
            return false;
        }
        Coord coord = (Coord)object;
        return this.x == coord.x && this.z == coord.z;
    }

    public static Coord parseCoord(int n, int n2) {
        int n3 = n / Coord.getCellSize();
        int n4 = n2 / Coord.getCellSize();
        boolean bl = n % Coord.getCellSize() != 0;
        boolean bl2 = n2 % Coord.getCellSize() != 0;
        return new Coord(n3 - (n < 0 && bl ? 1 : 0), n4 - (n2 < 0 && bl2 ? 1 : 0));
    }

    public static Coord parseCoord(Entity entity) {
        return Coord.parseCoord(entity.getLocation());
    }

    public static Coord parseCoord(Location location) {
        return Coord.parseCoord(location.getBlockX(), location.getBlockZ());
    }

    public static Coord parseCoord(Block block) {
        return Coord.parseCoord(block.getX(), block.getZ());
    }

    public String toString() {
        return this.getX() + "," + this.getZ();
    }

    public static void setCellSize(int n) {
        cellSize = n;
    }

    public static int getCellSize() {
        return cellSize;
    }
}

