/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.NationAddTownEvent;
import com.palmergames.bukkit.towny.event.NationRemoveTownEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.war.flagwar.TownyWar;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.World;
import org.bukkit.event.Event;

public class Nation
extends TownyEconomyObject
implements ResidentList {
    private static final String ECONOMY_ACCOUNT_PREFIX = "nation-";
    private List<Town> towns = new ArrayList<Town>();
    private List<Nation> allies = new ArrayList<Nation>();
    private List<Nation> enemies = new ArrayList<Nation>();
    private Town capital;
    private double taxes;
    private boolean neutral = false;
    private String tag;

    public Nation(String string) {
        this.setName(string);
        this.tag = "";
    }

    public void setTag(String string) throws TownyException {
        if (string.length() > 4) {
            throw new TownyException("Tag too long");
        }
        this.tag = string.toUpperCase();
        if (this.tag.matches(" ")) {
            this.tag = "";
        }
        this.setChangedName(true);
    }

    public String getTag() {
        return this.tag;
    }

    public boolean hasTag() {
        return !this.tag.isEmpty();
    }

    public void addAlly(Nation nation) throws AlreadyRegisteredException {
        if (this.hasAlly(nation)) {
            throw new AlreadyRegisteredException();
        }
        try {
            this.removeEnemy(nation);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.getAllies().add(nation);
    }

    public boolean removeAlly(Nation nation) throws NotRegisteredException {
        if (!this.hasAlly(nation)) {
            throw new NotRegisteredException();
        }
        return this.getAllies().remove(nation);
    }

    public boolean removeAllAllies() {
        for (Nation nation : new ArrayList<Nation>(this.getAllies())) {
            try {
                this.removeAlly(nation);
                nation.removeAlly(this);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return this.getAllies().size() == 0;
    }

    public boolean hasAlly(Nation nation) {
        return this.getAllies().contains(nation);
    }

    public void addEnemy(Nation nation) throws AlreadyRegisteredException {
        if (this.hasEnemy(nation)) {
            throw new AlreadyRegisteredException();
        }
        try {
            this.removeAlly(nation);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.getEnemies().add(nation);
    }

    public boolean removeEnemy(Nation nation) throws NotRegisteredException {
        if (!this.hasEnemy(nation)) {
            throw new NotRegisteredException();
        }
        return this.getEnemies().remove(nation);
    }

    public boolean removeAllEnemies() {
        for (Nation nation : new ArrayList<Nation>(this.getEnemies())) {
            try {
                this.removeEnemy(nation);
                nation.removeEnemy(this);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return this.getAllies().size() == 0;
    }

    public boolean hasEnemy(Nation nation) {
        return this.getEnemies().contains(nation);
    }

    public List<Town> getTowns() {
        return this.towns;
    }

    public boolean isKing(Resident resident) {
        return this.hasCapital() ? this.getCapital().isMayor(resident) : false;
    }

    public boolean hasCapital() {
        return this.getCapital() != null;
    }

    public boolean hasAssistant(Resident resident) {
        return this.getAssistants().contains(resident);
    }

    public boolean isCapital(Town town) {
        return town == this.getCapital();
    }

    public boolean hasTown(String string) {
        for (Town town : this.towns) {
            if (!town.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTown(Town town) {
        return this.towns.contains(town);
    }

    public void addTown(Town town) throws AlreadyRegisteredException {
        if (this.hasTown(town)) {
            throw new AlreadyRegisteredException();
        }
        if (town.hasNation()) {
            throw new AlreadyRegisteredException();
        }
        this.towns.add(town);
        town.setNation(this);
        BukkitTools.getPluginManager().callEvent((Event)new NationAddTownEvent(town, this));
    }

    public void setCapital(Town town) {
        this.capital = town;
        try {
            TownyPerms.assignPermissions(town.getMayor(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Town getCapital() {
        return this.capital;
    }

    public boolean setAllegiance(String string, Nation nation) {
        try {
            if (string.equalsIgnoreCase("ally")) {
                this.removeEnemy(nation);
                this.addAlly(nation);
                if (!this.hasEnemy(nation) && this.hasAlly(nation)) {
                    return true;
                }
            } else if (string.equalsIgnoreCase("neutral")) {
                this.removeEnemy(nation);
                this.removeAlly(nation);
                if (!this.hasEnemy(nation) && !this.hasAlly(nation)) {
                    return true;
                }
            } else if (string.equalsIgnoreCase("enemy")) {
                this.removeAlly(nation);
                this.addEnemy(nation);
                if (this.hasEnemy(nation) && !this.hasAlly(nation)) {
                    return true;
                }
            }
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            return false;
        }
        catch (NotRegisteredException notRegisteredException) {
            return false;
        }
        return false;
    }

    public List<Resident> getAssistants() {
        ArrayList<Resident> arrayList = new ArrayList<Resident>();
        for (Town town : this.towns) {
            for (Resident resident : town.getResidents()) {
                if (!resident.hasNationRank("assistant")) continue;
                arrayList.add(resident);
            }
        }
        return arrayList;
    }

    public void setEnemies(List<Nation> list) {
        this.enemies = list;
    }

    public List<Nation> getEnemies() {
        return this.enemies;
    }

    public void setAllies(List<Nation> list) {
        this.allies = list;
    }

    public List<Nation> getAllies() {
        return this.allies;
    }

    public int getNumTowns() {
        return this.towns.size();
    }

    public int getNumResidents() {
        int n = 0;
        for (Town town : this.getTowns()) {
            n += town.getNumResidents();
        }
        return n;
    }

    public void removeTown(Town town) throws EmptyNationException, NotRegisteredException {
        if (!this.hasTown(town)) {
            throw new NotRegisteredException();
        }
        boolean bl = town.isCapital();
        this.remove(town);
        if (this.getNumTowns() == 0) {
            throw new EmptyNationException(this);
        }
        if (bl) {
            int n = 0;
            Town town2 = null;
            for (Town town3 : this.getTowns()) {
                if (town3.getNumResidents() <= n) continue;
                town2 = town3;
                n = town3.getNumResidents();
            }
            if (town2 != null) {
                this.setCapital(town2);
            }
        }
    }

    private void remove(Town town) {
        try {
            town.setNation(null);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        this.towns.remove(town);
        BukkitTools.getPluginManager().callEvent((Event)new NationRemoveTownEvent(town, this));
    }

    private void removeAllTowns() {
        for (Town town : new ArrayList<Town>(this.towns)) {
            this.remove(town);
        }
    }

    public void setTaxes(double d) {
        this.taxes = d > TownySettings.getMaxTax() ? TownySettings.getMaxTax() : d;
    }

    public double getTaxes() {
        this.setTaxes(this.taxes);
        return this.taxes;
    }

    public void clear() {
        this.removeAllAllies();
        this.removeAllEnemies();
        this.removeAllTowns();
        this.capital = null;
    }

    public void setNeutral(boolean bl) throws TownyException {
        if (!TownySettings.isDeclaringNeutral() && bl) {
            throw new TownyException(TownySettings.getLangString("msg_err_fight_like_king"));
        }
        if (bl) {
            for (Resident resident : this.getResidents()) {
                TownyWar.removeAttackerFlags(resident.getName());
            }
        }
        this.neutral = bl;
    }

    public boolean isNeutral() {
        return this.neutral;
    }

    public void setKing(Resident resident) throws TownyException {
        if (!this.hasResident(resident)) {
            throw new TownyException(TownySettings.getLangString("msg_err_king_not_in_nation"));
        }
        if (!resident.isMayor()) {
            throw new TownyException(TownySettings.getLangString("msg_err_new_king_notmayor"));
        }
        this.setCapital(resident.getTown());
    }

    public boolean hasResident(Resident resident) {
        for (Town town : this.getTowns()) {
            if (!town.hasResident(resident)) continue;
            return true;
        }
        return false;
    }

    public void collect(double d) throws EconomyException {
        if (TownySettings.isUsingEconomy()) {
            double d2 = TownySettings.getNationBankCap();
            if (d2 > 0.0 && d + this.getHoldingBalance() > d2) {
                TownyMessaging.sendNationMessage(this, String.format(TownySettings.getLangString("msg_err_deposit_capped"), d2));
                return;
            }
            this.collect(d, null);
        }
    }

    public void withdrawFromBank(Resident resident, int n) throws EconomyException, TownyException {
        if (TownySettings.isUsingEconomy()) {
            if (!this.payTo(n, resident, "Nation Withdraw")) {
                throw new TownyException(TownySettings.getLangString("msg_err_no_money"));
            }
        } else {
            throw new TownyException(TownySettings.getLangString("msg_err_no_economy"));
        }
    }

    @Override
    public List<Resident> getResidents() {
        ArrayList<Resident> arrayList = new ArrayList<Resident>();
        for (Town town : this.getTowns()) {
            arrayList.addAll(town.getResidents());
        }
        return arrayList;
    }

    @Override
    public List<String> getTreeString(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getTreeDepth(n) + "Nation (" + this.getName() + ")");
        arrayList.add(this.getTreeDepth(n + 1) + "Capital: " + this.getCapital().getName());
        List<Resident> list = this.getAssistants();
        if (list.size() > 0) {
            arrayList.add(this.getTreeDepth(n + 1) + "Assistants (" + list.size() + "): " + Arrays.toString(list.toArray(new Resident[0])));
        }
        if (this.getAllies().size() > 0) {
            arrayList.add(this.getTreeDepth(n + 1) + "Allies (" + this.getAllies().size() + "): " + Arrays.toString(this.getAllies().toArray(new Nation[0])));
        }
        if (this.getEnemies().size() > 0) {
            arrayList.add(this.getTreeDepth(n + 1) + "Enemies (" + this.getEnemies().size() + "): " + Arrays.toString(this.getEnemies().toArray(new Nation[0])));
        }
        arrayList.add(this.getTreeDepth(n + 1) + "Towns (" + this.getTowns().size() + "):");
        for (Town town : this.getTowns()) {
            arrayList.addAll(town.getTreeString(n + 2));
        }
        return arrayList;
    }

    @Override
    public boolean hasResident(String string) {
        for (Town town : this.getTowns()) {
            if (!town.hasResident(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected World getBukkitWorld() {
        if (this.hasCapital() && this.getCapital().hasWorld()) {
            return BukkitTools.getWorld(this.getCapital().getWorld().getName());
        }
        return super.getBukkitWorld();
    }

    @Override
    public String getEconomyName() {
        return StringMgmt.trimMaxLength(ECONOMY_ACCOUNT_PREFIX + this.getName(), 32);
    }
}

