/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlayerCache {
    private HashMap<Integer, HashMap<Byte, Boolean>> buildPermission = new HashMap();
    private HashMap<Integer, HashMap<Byte, Boolean>> destroyPermission = new HashMap();
    private HashMap<Integer, HashMap<Byte, Boolean>> switchPermission = new HashMap();
    private HashMap<Integer, HashMap<Byte, Boolean>> itemUsePermission = new HashMap();
    private WorldCoord lastWorldCoord;
    private String blockErrMsg;
    private Location lastLocation;
    private TownBlockStatus townBlockStatus = TownBlockStatus.UNKOWN;

    public PlayerCache(TownyWorld townyWorld, Player player) {
        this(new WorldCoord(townyWorld.getName(), Coord.parseCoord((Entity)player)));
        this.setLastLocation(player.getLocation());
    }

    public PlayerCache(WorldCoord worldCoord) {
        this.setLastTownBlock(worldCoord);
    }

    public void setLastTownBlock(WorldCoord worldCoord) {
        this.lastWorldCoord = worldCoord;
    }

    public void resetAndUpdate(WorldCoord worldCoord) {
        this.reset();
        this.setLastTownBlock(worldCoord);
    }

    public WorldCoord getLastTownBlock() {
        return this.lastWorldCoord;
    }

    public boolean updateCoord(WorldCoord worldCoord) {
        if (!this.getLastTownBlock().equals(worldCoord)) {
            this.reset();
            this.setLastTownBlock(worldCoord);
            return true;
        }
        return false;
    }

    public boolean getCachePermission(Integer n, byte by, TownyPermission.ActionType actionType) throws NullPointerException {
        switch (actionType) {
            case BUILD: {
                return this.getBuildPermission(n, by);
            }
            case DESTROY: {
                return this.getDestroyPermission(n, by);
            }
            case SWITCH: {
                return this.getSwitchPermission(n, by);
            }
            case ITEM_USE: {
                return this.getItemUsePermission(n, by);
            }
        }
        throw new NullPointerException();
    }

    public void setBuildPermission(Integer n, byte by, Boolean bl) {
        this.updateMaps(this.buildPermission, n, by, bl);
    }

    public void setDestroyPermission(Integer n, byte by, Boolean bl) {
        this.updateMaps(this.destroyPermission, n, by, bl);
    }

    public void setSwitchPermission(Integer n, byte by, Boolean bl) {
        this.updateMaps(this.switchPermission, n, by, bl);
    }

    public void setItemUsePermission(Integer n, byte by, Boolean bl) {
        this.updateMaps(this.itemUsePermission, n, by, bl);
    }

    public boolean getBuildPermission(Integer n, byte by) throws NullPointerException {
        return this.getBlockPermission(this.buildPermission, n, by);
    }

    public boolean getDestroyPermission(Integer n, byte by) throws NullPointerException {
        return this.getBlockPermission(this.destroyPermission, n, by);
    }

    public boolean getSwitchPermission(Integer n, byte by) throws NullPointerException {
        return this.getBlockPermission(this.switchPermission, n, by);
    }

    public Boolean getItemUsePermission(Integer n, byte by) throws NullPointerException {
        return this.getBlockPermission(this.itemUsePermission, n, by);
    }

    private void updateMaps(HashMap<Integer, HashMap<Byte, Boolean>> hashMap, Integer n, byte by, Boolean bl) {
        if (!hashMap.containsKey(n)) {
            HashMap<Byte, Boolean> hashMap2 = new HashMap<Byte, Boolean>();
            hashMap2.put(by, bl);
            hashMap.put(n, hashMap2);
        } else {
            hashMap.get(n).put(by, bl);
        }
    }

    private boolean getBlockPermission(HashMap<Integer, HashMap<Byte, Boolean>> hashMap, Integer n, byte by) throws NullPointerException {
        if (!hashMap.containsKey(n)) {
            throw new NullPointerException();
        }
        HashMap<Byte, Boolean> hashMap2 = hashMap.get(n);
        if (!hashMap2.containsKey(by)) {
            throw new NullPointerException();
        }
        return hashMap2.get(by);
    }

    private void reset() {
        this.lastWorldCoord = null;
        this.townBlockStatus = null;
        this.blockErrMsg = null;
        this.buildPermission = new HashMap();
        this.destroyPermission = new HashMap();
        this.switchPermission = new HashMap();
        this.itemUsePermission = new HashMap();
    }

    public void setStatus(TownBlockStatus townBlockStatus) {
        this.townBlockStatus = townBlockStatus;
    }

    public TownBlockStatus getStatus() throws NullPointerException {
        if (this.townBlockStatus == null) {
            throw new NullPointerException();
        }
        return this.townBlockStatus;
    }

    public void setBlockErrMsg(String string) {
        this.blockErrMsg = string;
    }

    public String getBlockErrMsg() {
        String string = this.blockErrMsg;
        this.setBlockErrMsg(null);
        return string;
    }

    public boolean hasBlockErrMsg() {
        return this.blockErrMsg != null;
    }

    public void setLastLocation(Location location) {
        this.lastLocation = location.clone();
    }

    public Location getLastLocation() throws NullPointerException {
        if (this.lastLocation == null) {
            throw new NullPointerException();
        }
        return this.lastLocation;
    }

    public static enum TownBlockStatus {
        UNKOWN,
        NOT_REGISTERED,
        OFF_WORLD,
        ADMIN,
        UNCLAIMED_ZONE,
        LOCKED,
        WARZONE,
        OUTSIDER,
        PLOT_OWNER,
        PLOT_FRIEND,
        PLOT_ALLY,
        TOWN_OWNER,
        TOWN_RESIDENT,
        TOWN_ALLY,
        ENEMY;

    }
}

