/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.TownAddResidentEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.wallgen.Wall;
import com.palmergames.bukkit.wallgen.WallSection;
import com.palmergames.bukkit.wallgen.Walled;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;

public class Town
extends TownBlockOwner
implements Walled,
ResidentList {
    private static final String ECONOMY_ACCOUNT_PREFIX = "town-";
    private List<Resident> residents = new ArrayList<Resident>();
    private List<Location> outpostSpawns = new ArrayList<Location>();
    private Wall wall = new Wall();
    private Resident mayor;
    private int bonusBlocks;
    private int purchasedBlocks;
    private double taxes;
    private double plotTax;
    private double commercialPlotTax;
    private double embassyPlotTax;
    private double plotPrice;
    private double commercialPlotPrice;
    private double embassyPlotPrice;
    private Nation nation;
    private boolean hasUpkeep;
    private boolean isPublic;
    private boolean isTaxPercentage;
    private boolean isOpen;
    private String townBoard = "/town set board [msg]";
    private String tag;
    private TownBlock homeBlock;
    private TownyWorld world;
    private Location spawn;
    private boolean adminDisabledPVP = false;
    private boolean adminEnabledPVP = false;

    public Town(String string) {
        this.setName(string);
        this.tag = "";
        this.bonusBlocks = 0;
        this.purchasedBlocks = 0;
        this.taxes = 0.0;
        this.plotTax = 0.0;
        this.commercialPlotTax = 0.0;
        this.plotPrice = 0.0;
        this.hasUpkeep = true;
        this.isPublic = TownySettings.getTownDefaultPublic();
        this.isTaxPercentage = false;
        this.isOpen = TownySettings.getTownDefaultOpen();
        this.permissions.loadDefault(this);
    }

    @Override
    public void addTownBlock(TownBlock townBlock) throws AlreadyRegisteredException {
        if (this.hasTownBlock(townBlock)) {
            throw new AlreadyRegisteredException();
        }
        this.townBlocks.add(townBlock);
        if (this.townBlocks.size() == 1 && !this.hasHomeBlock()) {
            try {
                this.setHomeBlock(townBlock);
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
    }

    public void setTag(String string) throws TownyException {
        if (string.length() > 4) {
            throw new TownyException("Tag too long");
        }
        this.tag = string.toUpperCase();
        if (this.tag.matches(" ")) {
            this.tag = "";
        }
        this.setChangedName(true);
    }

    public String getTag() {
        return this.tag;
    }

    public boolean hasTag() {
        return !this.tag.isEmpty();
    }

    public Resident getMayor() {
        return this.mayor;
    }

    public void setTaxes(double d) {
        this.taxes = this.isTaxPercentage ? (d > TownySettings.getMaxTaxPercent() ? TownySettings.getMaxTaxPercent() : d) : (d > TownySettings.getMaxTax() ? TownySettings.getMaxTax() : d);
    }

    public double getTaxes() {
        this.setTaxes(this.taxes);
        return this.taxes;
    }

    public void setMayor(Resident resident) throws TownyException {
        if (!this.hasResident(resident)) {
            throw new TownyException("Mayor doesn't belong to town.");
        }
        this.mayor = resident;
        TownyPerms.assignPermissions(resident, null);
    }

    public Nation getNation() throws NotRegisteredException {
        if (this.hasNation()) {
            return this.nation;
        }
        throw new NotRegisteredException("Town doesn't belong to any nation.");
    }

    public void setNation(Nation nation) throws AlreadyRegisteredException {
        if (nation == null) {
            this.nation = null;
            TownyPerms.updateTownPerms(this);
            return;
        }
        if (this.nation == nation) {
            return;
        }
        if (this.hasNation()) {
            throw new AlreadyRegisteredException();
        }
        this.nation = nation;
        TownyPerms.updateTownPerms(this);
    }

    @Override
    public List<Resident> getResidents() {
        return this.residents;
    }

    public List<Resident> getAssistants() {
        ArrayList<Resident> arrayList = new ArrayList<Resident>();
        for (Resident resident : this.residents) {
            if (!resident.hasTownRank("assistant")) continue;
            arrayList.add(resident);
        }
        return arrayList;
    }

    @Override
    public boolean hasResident(String string) {
        for (Resident resident : this.residents) {
            if (!resident.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasResident(Resident resident) {
        return this.residents.contains(resident);
    }

    public boolean hasAssistant(Resident resident) {
        return this.getAssistants().contains(resident);
    }

    public void addResident(Resident resident) throws AlreadyRegisteredException {
        this.addResidentCheck(resident);
        this.residents.add(resident);
        resident.setTown(this);
        BukkitTools.getPluginManager().callEvent((Event)new TownAddResidentEvent(resident, this));
    }

    public void addResidentCheck(Resident resident) throws AlreadyRegisteredException {
        if (this.hasResident(resident)) {
            throw new AlreadyRegisteredException(String.format(TownySettings.getLangString("msg_err_already_in_town"), resident.getName(), this.getFormattedName()));
        }
        if (resident.hasTown()) {
            try {
                if (!resident.getTown().equals(this)) {
                    throw new AlreadyRegisteredException(String.format(TownySettings.getLangString("msg_err_already_in_town"), resident.getName(), resident.getTown().getFormattedName()));
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                notRegisteredException.printStackTrace();
            }
        }
    }

    public boolean isMayor(Resident resident) {
        return resident == this.mayor;
    }

    public boolean hasNation() {
        return this.nation != null;
    }

    public int getNumResidents() {
        return this.residents.size();
    }

    public boolean isCapital() {
        return this.hasNation() ? this.nation.isCapital(this) : false;
    }

    public void setHasUpkeep(boolean bl) {
        this.hasUpkeep = bl;
    }

    public boolean hasUpkeep() {
        return this.hasUpkeep;
    }

    public void setHasMobs(boolean bl) {
        this.permissions.mobs = bl;
    }

    public boolean hasMobs() {
        return this.permissions.mobs;
    }

    public void setPVP(boolean bl) {
        this.permissions.pvp = bl;
    }

    public void setAdminDisabledPVP(boolean bl) {
        this.adminDisabledPVP = bl;
    }

    public void setAdminEnabledPVP(boolean bl) {
        this.adminEnabledPVP = bl;
    }

    public boolean isPVP() {
        if (this.isAdminEnabledPVP()) {
            return false;
        }
        if (this.isAdminDisabledPVP()) {
            return false;
        }
        return this.permissions.pvp;
    }

    public boolean isAdminDisabledPVP() {
        return this.adminDisabledPVP;
    }

    public boolean isAdminEnabledPVP() {
        return this.adminEnabledPVP;
    }

    public void setBANG(boolean bl) {
        this.permissions.explosion = bl;
    }

    public boolean isBANG() {
        return this.permissions.explosion;
    }

    public void setTaxPercentage(boolean bl) {
        this.isTaxPercentage = bl;
        if (this.getTaxes() > 100.0) {
            this.setTaxes(0.0);
        }
    }

    public boolean isTaxPercentage() {
        return this.isTaxPercentage;
    }

    public void setFire(boolean bl) {
        this.permissions.fire = bl;
    }

    public boolean isFire() {
        return this.permissions.fire;
    }

    public void setTownBoard(String string) {
        this.townBoard = string;
    }

    public String getTownBoard() {
        return this.townBoard;
    }

    public void setBonusBlocks(int n) {
        this.bonusBlocks = n;
    }

    public int getTotalBlocks() {
        return TownySettings.getMaxTownBlocks(this);
    }

    public int getBonusBlocks() {
        return this.bonusBlocks;
    }

    public void addBonusBlocks(int n) {
        this.bonusBlocks += n;
    }

    public void setPurchasedBlocks(int n) {
        this.purchasedBlocks = n;
    }

    public int getPurchasedBlocks() {
        return this.purchasedBlocks;
    }

    public void addPurchasedBlocks(int n) {
        this.purchasedBlocks += n;
    }

    public boolean setHomeBlock(TownBlock townBlock) throws TownyException {
        if (townBlock == null) {
            this.homeBlock = null;
            return false;
        }
        if (!this.hasTownBlock(townBlock)) {
            throw new TownyException("Town has no claim over this town block.");
        }
        this.homeBlock = townBlock;
        if (this.world != townBlock.getWorld()) {
            if (this.world != null && this.world.hasTown(this)) {
                this.world.removeTown(this);
            }
            this.setWorld(townBlock.getWorld());
        }
        try {
            this.setSpawn(this.spawn);
        }
        catch (TownyException townyException) {
            this.spawn = null;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return true;
    }

    public TownBlock getHomeBlock() throws TownyException {
        if (this.hasHomeBlock()) {
            return this.homeBlock;
        }
        throw new TownyException("Town has not set a home block.");
    }

    public void setWorld(TownyWorld townyWorld) {
        if (townyWorld == null) {
            this.world = null;
            return;
        }
        if (this.world == townyWorld) {
            return;
        }
        if (this.hasWorld()) {
            try {
                townyWorld.removeTown(this);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        this.world = townyWorld;
        try {
            this.world.addTown(this);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
    }

    public TownyWorld getWorld() {
        if (this.world != null) {
            return this.world;
        }
        return TownyUniverse.getDataSource().getTownWorld(this.getName());
    }

    public boolean hasMayor() {
        return this.mayor != null;
    }

    public void removeResident(Resident resident) throws EmptyTownException, NotRegisteredException {
        if (!this.hasResident(resident)) {
            throw new NotRegisteredException();
        }
        this.remove(resident);
        if (this.getNumResidents() == 0) {
            throw new EmptyTownException(this);
        }
    }

    private void removeAllResidents() {
        for (Resident resident : new ArrayList<Resident>(this.residents)) {
            this.remove(resident);
        }
    }

    private void remove(Resident resident) {
        for (TownBlock object : new ArrayList<TownBlock>(resident.getTownBlocks())) {
            object.setResident(null);
            try {
                object.setPlotPrice(object.getTown().getPlotPrice());
            }
            catch (NotRegisteredException notRegisteredException) {
                notRegisteredException.printStackTrace();
            }
        }
        if (this.isMayor(resident) && this.residents.size() > 1) {
            for (Resident resident2 : new ArrayList<Resident>(this.getAssistants())) {
                if (resident2 == resident || !resident.hasTownRank("assistant")) continue;
                try {
                    this.setMayor(resident2);
                }
                catch (TownyException townyException) {
                    townyException.printStackTrace();
                }
            }
            if (this.isMayor(resident)) {
                for (Resident resident3 : new ArrayList<Resident>(this.getResidents())) {
                    if (resident3 == resident) continue;
                    try {
                        this.setMayor(resident3);
                    }
                    catch (TownyException townyException) {
                        townyException.printStackTrace();
                    }
                }
            }
        }
        try {
            if (resident.hasTown()) {
                BukkitTools.getPluginManager().callEvent((Event)new TownRemoveResidentEvent(resident, resident.getTown()));
            }
            resident.setTown(null);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
        catch (NotRegisteredException notRegisteredException) {
            notRegisteredException.printStackTrace();
        }
        this.residents.remove(resident);
    }

    public void setSpawn(Location location) throws TownyException {
        if (!this.hasHomeBlock()) {
            throw new TownyException("Home Block has not been set");
        }
        Coord coord = Coord.parseCoord(location);
        if (this.homeBlock.getX() != coord.getX() || this.homeBlock.getZ() != coord.getZ()) {
            throw new TownyException("Spawn is not within the homeBlock.");
        }
        this.spawn = location;
    }

    public Location getSpawn() throws TownyException {
        if (this.hasHomeBlock() && this.spawn != null) {
            return this.spawn;
        }
        this.spawn = null;
        throw new TownyException("Town has not set a spawn location.");
    }

    public boolean hasSpawn() {
        return this.hasHomeBlock() && this.spawn != null;
    }

    public boolean hasHomeBlock() {
        return this.homeBlock != null;
    }

    public void clear() throws EmptyNationException {
        this.removeAllResidents();
        this.mayor = null;
        this.residents.clear();
        this.homeBlock = null;
        this.outpostSpawns.clear();
        try {
            if (this.hasWorld()) {
                this.world.removeTownBlocks(this.getTownBlocks());
                this.world.removeTown(this);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (this.hasNation()) {
            try {
                this.nation.removeTown(this);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) throws NotRegisteredException {
        if (!this.hasTownBlock(townBlock)) {
            throw new NotRegisteredException();
        }
        if (townBlock.isOutpost()) {
            this.removeOutpostSpawn(townBlock.getCoord());
        }
        try {
            if (this.getHomeBlock() == townBlock) {
                this.setHomeBlock(null);
            }
        }
        catch (TownyException townyException) {
            // empty catch block
        }
        this.townBlocks.remove(townBlock);
    }

    public void addOutpostSpawn(Location location) throws TownyException {
        this.removeOutpostSpawn(Coord.parseCoord(location));
        Coord coord = Coord.parseCoord(location);
        try {
            TownBlock townBlock = TownyUniverse.getDataSource().getWorld(location.getWorld().getName()).getTownBlock(coord);
            if (townBlock.getX() == coord.getX() && townBlock.getZ() == coord.getZ()) {
                if (!townBlock.isOutpost()) {
                    throw new TownyException("Location is not within an outpost plot.");
                }
                this.outpostSpawns.add(location);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            throw new TownyException("Location is not within a Town.");
        }
    }

    public Location getOutpostSpawn(Integer n) throws TownyException {
        if (this.getMaxOutpostSpawn() == 0) {
            throw new TownyException("Town has no outpost spawns set.");
        }
        return this.outpostSpawns.get(Math.min(this.getMaxOutpostSpawn() - 1, Math.max(0, n - 1)));
    }

    public int getMaxOutpostSpawn() {
        return this.outpostSpawns.size();
    }

    public boolean hasOutpostSpawn() {
        return this.outpostSpawns.size() > 0;
    }

    public List<Location> getAllOutpostSpawns() {
        return Collections.unmodifiableList(this.outpostSpawns);
    }

    private void removeOutpostSpawn(Coord coord) {
        for (Location location : new ArrayList<Location>(this.outpostSpawns)) {
            Coord coord2 = Coord.parseCoord(location);
            if (coord.getX() != coord2.getX() || coord.getZ() != coord.getZ()) continue;
            this.outpostSpawns.remove(location);
        }
    }

    public void setPlotPrice(double d) {
        this.plotPrice = d;
    }

    public double getPlotPrice() {
        return this.plotPrice;
    }

    public double getPlotTypePrice(TownBlockType townBlockType) {
        double d = 0.0;
        switch (townBlockType.ordinal()) {
            case 0: {
                d = this.getPlotPrice();
                break;
            }
            case 1: {
                d = this.getCommercialPlotPrice();
                break;
            }
            case 3: {
                d = this.getEmbassyPlotPrice();
                break;
            }
            default: {
                d = this.getPlotPrice();
            }
        }
        if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    public void setCommercialPlotPrice(double d) {
        this.commercialPlotPrice = d;
    }

    public double getCommercialPlotPrice() {
        return this.commercialPlotPrice;
    }

    public void setEmbassyPlotPrice(double d) {
        this.embassyPlotPrice = d;
    }

    public double getEmbassyPlotPrice() {
        return this.embassyPlotPrice;
    }

    @Override
    public Wall getWall() {
        return this.wall;
    }

    @Override
    public List<WallSection> getWallSections() {
        return this.getWall().getWallSections();
    }

    @Override
    public void setWallSections(List<WallSection> list) {
        this.getWall().setWallSections(list);
    }

    @Override
    public boolean hasWallSection(WallSection wallSection) {
        return this.getWall().hasWallSection(wallSection);
    }

    @Override
    public void addWallSection(WallSection wallSection) {
        this.getWall().addWallSection(wallSection);
    }

    @Override
    public void removeWallSection(WallSection wallSection) {
        this.getWall().removeWallSection(wallSection);
    }

    public boolean isHomeBlock(TownBlock townBlock) {
        return this.hasHomeBlock() ? townBlock == this.homeBlock : false;
    }

    public void setPlotTax(double d) {
        this.plotTax = d;
    }

    public double getPlotTax() {
        return this.plotTax;
    }

    public void setCommercialPlotTax(double d) {
        this.commercialPlotTax = d;
    }

    public double getCommercialPlotTax() {
        return this.commercialPlotTax;
    }

    public void setEmbassyPlotTax(double d) {
        this.embassyPlotTax = d;
    }

    public double getEmbassyPlotTax() {
        return this.embassyPlotTax;
    }

    public void setOpen(boolean bl) {
        this.isOpen = bl;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void collect(double d) throws EconomyException {
        if (TownySettings.isUsingEconomy()) {
            double d2 = TownySettings.getTownBankCap();
            if (d2 > 0.0 && d + this.getHoldingBalance() > d2) {
                TownyMessaging.sendTownMessage(this, String.format(TownySettings.getLangString("msg_err_deposit_capped"), d2));
                return;
            }
            this.collect(d, null);
        }
    }

    public void withdrawFromBank(Resident resident, int n) throws EconomyException, TownyException {
        if (TownySettings.isUsingEconomy()) {
            if (!this.payTo(n, resident, "Town Widthdraw")) {
                throw new TownyException("There is not enough money in the bank.");
            }
        } else {
            throw new TownyException("Economy has not been turned on.");
        }
    }

    @Override
    public List<String> getTreeString(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getTreeDepth(n) + "Town (" + this.getName() + ")");
        arrayList.add(this.getTreeDepth(n + 1) + "Mayor: " + (this.hasMayor() ? this.getMayor().getName() : "None"));
        arrayList.add(this.getTreeDepth(n + 1) + "Home: " + this.homeBlock);
        arrayList.add(this.getTreeDepth(n + 1) + "Bonus: " + this.bonusBlocks);
        arrayList.add(this.getTreeDepth(n + 1) + "TownBlocks (" + this.getTownBlocks().size() + "): ");
        List<Resident> list = this.getAssistants();
        if (list.size() > 0) {
            arrayList.add(this.getTreeDepth(n + 1) + "Assistants (" + list.size() + "): " + Arrays.toString(list.toArray(new Resident[0])));
        }
        arrayList.add(this.getTreeDepth(n + 1) + "Residents (" + this.getResidents().size() + "):");
        for (Resident resident : this.getResidents()) {
            arrayList.addAll(resident.getTreeString(n + 2));
        }
        return arrayList;
    }

    public void setPublic(boolean bl) {
        this.isPublic = bl;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    protected World getBukkitWorld() {
        if (this.hasWorld()) {
            return BukkitTools.getWorld(this.getWorld().getName());
        }
        return super.getBukkitWorld();
    }

    @Override
    public String getEconomyName() {
        return StringMgmt.trimMaxLength(ECONOMY_ACCOUNT_PREFIX + this.getName(), 32);
    }
}

