/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import org.bukkit.entity.Player;

public enum TownSpawnLevel {
    TOWN_RESIDENT(ConfigNodes.GTOWN_SETTINGS_ALLOW_TOWN_SPAWN, "msg_err_town_spawn_forbidden", ConfigNodes.ECO_PRICE_TOWN_SPAWN_TRAVEL, PermissionNodes.TOWNY_SPAWN_TOWN.getNode()),
    TOWN_RESIDENT_OUTPOST(ConfigNodes.GTOWN_SETTINGS_ALLOW_TOWN_SPAWN, "msg_err_town_spawn_forbidden", ConfigNodes.ECO_PRICE_TOWN_SPAWN_TRAVEL, PermissionNodes.TOWNY_SPAWN_OUTPOST.getNode()),
    PART_OF_NATION(ConfigNodes.GTOWN_SETTINGS_ALLOW_TOWN_SPAWN_TRAVEL_NATION, "msg_err_town_spawn_nation_forbidden", ConfigNodes.ECO_PRICE_TOWN_SPAWN_TRAVEL_NATION, PermissionNodes.TOWNY_SPAWN_NATION.getNode()),
    NATION_ALLY(ConfigNodes.GTOWN_SETTINGS_ALLOW_TOWN_SPAWN_TRAVEL_ALLY, "msg_err_town_spawn_ally_forbidden", ConfigNodes.ECO_PRICE_TOWN_SPAWN_TRAVEL_ALLY, PermissionNodes.TOWNY_SPAWN_ALLY.getNode()),
    UNAFFILIATED(ConfigNodes.GTOWN_SETTINGS_ALLOW_TOWN_SPAWN_TRAVEL, "msg_err_public_spawn_forbidden", ConfigNodes.ECO_PRICE_TOWN_SPAWN_TRAVEL_PUBLIC, PermissionNodes.TOWNY_SPAWN_PUBLIC.getNode()),
    ADMIN(null, null, null, null);

    private ConfigNodes isAllowingConfigNode;
    private ConfigNodes ecoPriceConfigNode;
    private String permissionNode;
    private String notAllowedLangNode;

    private TownSpawnLevel(ConfigNodes configNodes, String string2, ConfigNodes configNodes2, String string3) {
        this.isAllowingConfigNode = configNodes;
        this.notAllowedLangNode = string2;
        this.ecoPriceConfigNode = configNodes2;
        this.permissionNode = string3;
    }

    public void checkIfAllowed(Towny towny, Player player) throws TownyException {
        if (!this.isAllowed() || !this.hasPermissionNode(towny, player)) {
            throw new TownyException(TownySettings.getLangString(this.notAllowedLangNode));
        }
    }

    public boolean isAllowed() {
        return this == ADMIN ? true : TownySettings.getBoolean(this.isAllowingConfigNode);
    }

    public boolean hasPermissionNode(Towny towny, Player player) {
        return this == ADMIN ? true : towny.isPermissions() && TownyUniverse.getPermissionSource().has(player, this.permissionNode) || !towny.isPermissions() && TownySettings.isAllowingTownSpawn();
    }

    public double getCost() {
        return this == ADMIN ? 0.0 : TownySettings.getDouble(this.ecoPriceConfigNode);
    }
}

