/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.util.BukkitTools;
import org.bukkit.World;

public class TownyEconomyObject
extends TownyObject {
    private static final TownyServerAccount SERVER_ACCOUNT = new TownyServerAccount();

    public boolean pay(double d, String string) throws EconomyException {
        if (TownySettings.getBoolean(ConfigNodes.ECO_CLOSED_ECONOMY_ENABLED)) {
            return this.payTo(d, SERVER_ACCOUNT, string);
        }
        boolean bl = this._pay(d);
        if (bl) {
            TownyLogger.logMoneyTransaction(this, d, null, string);
        }
        return bl;
    }

    private boolean _pay(double d) throws EconomyException {
        if (this.canPayFromHoldings(d) && TownyEconomyHandler.isActive()) {
            return TownyEconomyHandler.subtract(this.getEconomyName(), d, this.getBukkitWorld());
        }
        return false;
    }

    public boolean collect(double d, String string) throws EconomyException {
        if (TownySettings.getBoolean(ConfigNodes.ECO_CLOSED_ECONOMY_ENABLED)) {
            return SERVER_ACCOUNT.payTo(d, this, string);
        }
        boolean bl = this._collect(d);
        if (bl) {
            TownyLogger.logMoneyTransaction(null, d, this, string);
        }
        return bl;
    }

    private boolean _collect(double d) throws EconomyException {
        return TownyEconomyHandler.add(this.getEconomyName(), d, this.getBukkitWorld());
    }

    public boolean payTo(double d, TownyEconomyObject townyEconomyObject, String string) throws EconomyException {
        boolean bl = this._payTo(d, townyEconomyObject);
        if (bl) {
            TownyLogger.logMoneyTransaction(this, d, townyEconomyObject, string);
        }
        return bl;
    }

    private boolean _payTo(double d, TownyEconomyObject townyEconomyObject) throws EconomyException {
        if (this._pay(d)) {
            townyEconomyObject._collect(d);
            return true;
        }
        return false;
    }

    public String getEconomyName() {
        return this.getName();
    }

    protected World getBukkitWorld() {
        return BukkitTools.getWorlds().get(0);
    }

    public boolean setBalance(double d, String string) throws EconomyException {
        double d2 = this.getHoldingBalance();
        double d3 = d - d2;
        if (d3 > 0.0) {
            return this.collect(d3, string);
        }
        if (d2 > d) {
            d3 = -d3;
            return this.pay(d3, string);
        }
        return true;
    }

    public double getHoldingBalance() throws EconomyException {
        try {
            return TownyEconomyHandler.getBalance(this.getEconomyName(), this.getBukkitWorld());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            noClassDefFoundError.printStackTrace();
            throw new EconomyException("Economy error getting holdings for " + this.getEconomyName());
        }
    }

    public boolean canPayFromHoldings(double d) throws EconomyException {
        return TownyEconomyHandler.hasEnough(this.getEconomyName(), d, this.getBukkitWorld());
    }

    public String getHoldingFormattedBalance() {
        try {
            return TownyEconomyHandler.getFormattedBalance(this.getHoldingBalance());
        }
        catch (EconomyException economyException) {
            return "Error Accessing Bank Account";
        }
    }

    public void removeAccount() {
        TownyEconomyHandler.removeAccount(this.getEconomyName());
    }

    private static final class TownyServerAccount
    extends TownyEconomyObject {
        private TownyServerAccount() {
        }

        @Override
        public String getName() {
            return TownySettings.getString(ConfigNodes.ECO_CLOSED_ECONOMY_SERVER_ACCOUNT);
        }
    }
}

