/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.object.TownyObservableType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Random;

public abstract class TownyObject
extends Observable {
    private Integer UID = 0;
    private String name;
    private boolean isChangedName = true;

    public void setName(String string) {
        if (this.getUID() == 0) {
            this.setUID(string.hashCode() + new Random(System.currentTimeMillis()).nextInt());
        }
        this.setChanged();
        this.notifyObservers((Object)TownyObservableType.OBJECT_NAME);
        this.name = string;
        this.setChangedName(true);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getTreeString(int n) {
        return new ArrayList<String>();
    }

    public String getTreeDepth(int n) {
        char[] cArray = new char[n * 4];
        Arrays.fill(cArray, ' ');
        if (n > 0) {
            cArray[0] = 124;
            int n2 = (n - 1) * 4;
            cArray[n2] = 43;
            cArray[n2 + 1] = 45;
            cArray[n2 + 2] = 45;
        }
        return new String(cArray);
    }

    public String toString() {
        return this.getName();
    }

    public String getFormattedName() {
        return TownyFormatter.getFormattedName(this);
    }

    public boolean isChangedName() {
        return this.isChangedName;
    }

    public void setChangedName(boolean bl) {
        this.isChangedName = bl;
    }

    public Integer getUID() {
        return this.UID;
    }

    public void setUID(Integer n) {
        this.UID = n;
    }
}

