/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;

public class TownyPermission {
    public boolean residentBuild;
    public boolean residentDestroy;
    public boolean residentSwitch;
    public boolean residentItemUse;
    public boolean outsiderBuild;
    public boolean outsiderDestroy;
    public boolean outsiderSwitch;
    public boolean outsiderItemUse;
    public boolean allyBuild;
    public boolean allyDestroy;
    public boolean allySwitch;
    public boolean allyItemUse;
    public boolean pvp;
    public boolean fire;
    public boolean explosion;
    public boolean mobs;

    public TownyPermission() {
        this.reset();
    }

    public void reset() {
        this.setAll(false);
    }

    public void setAll(boolean bl) {
        this.residentBuild = bl;
        this.residentDestroy = bl;
        this.residentSwitch = bl;
        this.residentItemUse = bl;
        this.outsiderBuild = bl;
        this.outsiderDestroy = bl;
        this.outsiderSwitch = bl;
        this.outsiderItemUse = bl;
        this.allyBuild = bl;
        this.allyDestroy = bl;
        this.allySwitch = bl;
        this.allyItemUse = bl;
        this.pvp = bl;
        this.fire = bl;
        this.explosion = bl;
        this.mobs = bl;
    }

    public void set(String string, boolean bl) {
        if (string.equalsIgnoreCase("denyAll")) {
            this.reset();
        } else if (string.equalsIgnoreCase("residentBuild")) {
            this.residentBuild = bl;
        } else if (string.equalsIgnoreCase("residentDestroy")) {
            this.residentDestroy = bl;
        } else if (string.equalsIgnoreCase("residentSwitch")) {
            this.residentSwitch = bl;
        } else if (string.equalsIgnoreCase("residentItemUse")) {
            this.residentItemUse = bl;
        } else if (string.equalsIgnoreCase("outsiderBuild")) {
            this.outsiderBuild = bl;
        } else if (string.equalsIgnoreCase("outsiderDestroy")) {
            this.outsiderDestroy = bl;
        } else if (string.equalsIgnoreCase("outsiderSwitch")) {
            this.outsiderSwitch = bl;
        } else if (string.equalsIgnoreCase("outsiderItemUse")) {
            this.outsiderItemUse = bl;
        } else if (string.equalsIgnoreCase("allyBuild")) {
            this.allyBuild = bl;
        } else if (string.equalsIgnoreCase("allyDestroy")) {
            this.allyDestroy = bl;
        } else if (string.equalsIgnoreCase("allySwitch")) {
            this.allySwitch = bl;
        } else if (string.equalsIgnoreCase("allyItemUse")) {
            this.allyItemUse = bl;
        } else if (string.equalsIgnoreCase("pvp")) {
            this.pvp = bl;
        } else if (string.equalsIgnoreCase("fire")) {
            this.fire = bl;
        } else if (string.equalsIgnoreCase("explosion")) {
            this.explosion = bl;
        } else if (string.equalsIgnoreCase("mobs")) {
            this.mobs = bl;
        }
    }

    public void load(String string) {
        String[] stringArray;
        this.setAll(false);
        for (String string2 : stringArray = string.split(",")) {
            this.set(string2, true);
        }
    }

    public String toString() {
        String string = "";
        if (this.residentBuild) {
            string = string + "residentBuild";
        }
        if (this.residentDestroy) {
            string = string + (string.length() > 0 ? "," : "") + "residentDestroy";
        }
        if (this.residentSwitch) {
            string = string + (string.length() > 0 ? "," : "") + "residentSwitch";
        }
        if (this.residentItemUse) {
            string = string + (string.length() > 0 ? "," : "") + "residentItemUse";
        }
        if (this.outsiderBuild) {
            string = string + (string.length() > 0 ? "," : "") + "outsiderBuild";
        }
        if (this.outsiderDestroy) {
            string = string + (string.length() > 0 ? "," : "") + "outsiderDestroy";
        }
        if (this.outsiderSwitch) {
            string = string + (string.length() > 0 ? "," : "") + "outsiderSwitch";
        }
        if (this.outsiderItemUse) {
            string = string + (string.length() > 0 ? "," : "") + "outsiderItemUse";
        }
        if (this.allyBuild) {
            string = string + (string.length() > 0 ? "," : "") + "allyBuild";
        }
        if (this.allyDestroy) {
            string = string + (string.length() > 0 ? "," : "") + "allyDestroy";
        }
        if (this.allySwitch) {
            string = string + (string.length() > 0 ? "," : "") + "allySwitch";
        }
        if (this.allyItemUse) {
            string = string + (string.length() > 0 ? "," : "") + "allyItemUse";
        }
        if (this.pvp) {
            string = string + (string.length() > 0 ? "," : "") + "pvp";
        }
        if (this.fire) {
            string = string + (string.length() > 0 ? "," : "") + "fire";
        }
        if (this.explosion) {
            string = string + (string.length() > 0 ? "," : "") + "explosion";
        }
        if (this.mobs) {
            string = string + (string.length() > 0 ? "," : "") + "mobs";
        }
        if (string.length() == 0) {
            string = string + "denyAll";
        }
        return string;
    }

    public boolean getResidentPerm(ActionType actionType) {
        switch (actionType) {
            case BUILD: {
                return this.residentBuild;
            }
            case DESTROY: {
                return this.residentDestroy;
            }
            case SWITCH: {
                return this.residentSwitch;
            }
            case ITEM_USE: {
                return this.residentItemUse;
            }
        }
        throw new UnsupportedOperationException();
    }

    public boolean getOutsiderPerm(ActionType actionType) {
        switch (actionType) {
            case BUILD: {
                return this.outsiderBuild;
            }
            case DESTROY: {
                return this.outsiderDestroy;
            }
            case SWITCH: {
                return this.outsiderSwitch;
            }
            case ITEM_USE: {
                return this.outsiderItemUse;
            }
        }
        throw new UnsupportedOperationException();
    }

    public boolean getAllyPerm(ActionType actionType) {
        switch (actionType) {
            case BUILD: {
                return this.allyBuild;
            }
            case DESTROY: {
                return this.allyDestroy;
            }
            case SWITCH: {
                return this.allySwitch;
            }
            case ITEM_USE: {
                return this.allyItemUse;
            }
        }
        throw new UnsupportedOperationException();
    }

    public String getColourString() {
        return "\u00a7aBuild = \u00a77" + (this.residentBuild ? "f" : "-") + (this.allyBuild ? "a" : "-") + (this.outsiderBuild ? "o" : "-") + "\u00a7a" + " Destroy = " + "\u00a77" + (this.residentDestroy ? "f" : "-") + (this.allyDestroy ? "a" : "-") + (this.outsiderDestroy ? "o" : "-") + "\u00a7a" + " Switch = " + "\u00a77" + (this.residentSwitch ? "f" : "-") + (this.allySwitch ? "a" : "-") + (this.outsiderSwitch ? "o" : "-") + "\u00a7a" + " Item = " + "\u00a77" + (this.residentItemUse ? "f" : "-") + (this.allyItemUse ? "a" : "-") + (this.outsiderItemUse ? "o" : "-");
    }

    public void loadDefault(TownBlockOwner townBlockOwner) {
        this.residentBuild = TownySettings.getDefaultPermission(townBlockOwner, PermLevel.RESIDENT, ActionType.BUILD);
        this.residentDestroy = TownySettings.getDefaultPermission(townBlockOwner, PermLevel.RESIDENT, ActionType.DESTROY);
        this.residentSwitch = TownySettings.getDefaultPermission(townBlockOwner, PermLevel.RESIDENT, ActionType.SWITCH);
        this.residentItemUse = TownySettings.getDefaultPermission(townBlockOwner, PermLevel.RESIDENT, ActionType.ITEM_USE);
        this.allyBuild = TownySettings.getDefaultPermission(townBlockOwner, PermLevel.ALLY, ActionType.BUILD);
        this.allyDestroy = TownySettings.getDefaultPermission(townBlockOwner, PermLevel.ALLY, ActionType.DESTROY);
        this.allySwitch = TownySettings.getDefaultPermission(townBlockOwner, PermLevel.ALLY, ActionType.SWITCH);
        this.allyItemUse = TownySettings.getDefaultPermission(townBlockOwner, PermLevel.ALLY, ActionType.ITEM_USE);
        this.outsiderBuild = TownySettings.getDefaultPermission(townBlockOwner, PermLevel.OUTSIDER, ActionType.BUILD);
        this.outsiderDestroy = TownySettings.getDefaultPermission(townBlockOwner, PermLevel.OUTSIDER, ActionType.DESTROY);
        this.outsiderItemUse = TownySettings.getDefaultPermission(townBlockOwner, PermLevel.OUTSIDER, ActionType.ITEM_USE);
        this.outsiderSwitch = TownySettings.getDefaultPermission(townBlockOwner, PermLevel.OUTSIDER, ActionType.SWITCH);
        if (townBlockOwner instanceof Town) {
            this.pvp = TownySettings.getPermFlag_Town_Default_PVP();
            this.fire = TownySettings.getPermFlag_Town_Default_FIRE();
            this.explosion = TownySettings.getPermFlag_Town_Default_Explosion();
            this.mobs = TownySettings.getPermFlag_Town_Default_Mobs();
        } else {
            this.pvp = townBlockOwner.getPermissions().pvp;
            this.fire = townBlockOwner.getPermissions().fire;
            this.explosion = townBlockOwner.getPermissions().explosion;
            this.mobs = townBlockOwner.getPermissions().mobs;
        }
    }

    public static enum PermLevel {
        RESIDENT,
        ALLY,
        OUTSIDER;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static enum ActionType {
        BUILD,
        DESTROY,
        SWITCH,
        ITEM_USE;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

