/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;

public class WorldCoord
extends Coord {
    private String worldName;

    public WorldCoord(String string, int n, int n2) {
        super(n, n2);
        this.worldName = string;
    }

    public WorldCoord(String string, Coord coord) {
        super(coord);
        this.worldName = string;
    }

    public WorldCoord(WorldCoord worldCoord) {
        super(worldCoord);
        this.worldName = worldCoord.getWorldName();
    }

    public String getWorldName() {
        return this.worldName;
    }

    public Coord getCoord() {
        return new Coord(this.x, this.z);
    }

    @Deprecated
    public TownyWorld getWorld() throws NotRegisteredException {
        return this.getTownyWorld();
    }

    @Deprecated
    public WorldCoord(TownyWorld townyWorld, int n, int n2) {
        super(n, n2);
        this.worldName = townyWorld.getName();
    }

    @Deprecated
    public WorldCoord(TownyWorld townyWorld, Coord coord) {
        super(coord);
        this.worldName = townyWorld.getName();
    }

    public static WorldCoord parseWorldCoord(Entity entity) {
        return WorldCoord.parseWorldCoord(entity.getLocation());
    }

    public static WorldCoord parseWorldCoord(Location location) {
        return new WorldCoord(location.getWorld().getName(), WorldCoord.parseCoord(location));
    }

    public static WorldCoord parseWorldCoord(Block block) {
        return new WorldCoord(block.getWorld().getName(), WorldCoord.parseCoord(block.getX(), block.getZ()));
    }

    @Override
    public WorldCoord add(int n, int n2) {
        return new WorldCoord(this.getWorldName(), this.getX() + n, this.getZ() + n2);
    }

    @Override
    public int hashCode() {
        int n = 17;
        n = n * 27 + (this.worldName == null ? 0 : this.worldName.hashCode());
        n = n * 27 + this.x;
        n = n * 27 + this.z;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Coord)) {
            return false;
        }
        if (!(object instanceof WorldCoord)) {
            Coord coord = (Coord)object;
            return this.x == coord.x && this.z == coord.z;
        }
        WorldCoord worldCoord = (WorldCoord)object;
        return this.x == worldCoord.x && this.z == worldCoord.z && (this.worldName == null ? worldCoord.worldName == null : this.worldName.equals(worldCoord.worldName));
    }

    @Override
    public String toString() {
        return this.worldName + "," + super.toString();
    }

    public World getBukkitWorld() {
        return Bukkit.getWorld((String)this.worldName);
    }

    public TownyWorld getTownyWorld() throws NotRegisteredException {
        return TownyUniverse.getDataSource().getWorld(this.worldName);
    }

    public TownBlock getTownBlock() throws NotRegisteredException {
        return this.getTownyWorld().getTownBlock(this.getCoord());
    }
}

