/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.nijikokun.bukkit.Permissions.Permissions;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import org.anjocaido.groupmanager.GroupManager;
import org.bukkit.entity.Player;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public abstract class TownyPermissionSource {
    protected TownySettings settings;
    protected Towny plugin;
    protected GroupManager groupManager = null;
    protected Permissions permissions = null;
    protected PermissionsEx pex = null;

    public abstract String getPrefixSuffix(Resident var1, String var2);

    public abstract int getGroupPermissionIntNode(String var1, String var2);

    public abstract String getPlayerGroup(Player var1);

    public abstract String getPlayerPermissionStringNode(String var1, String var2);

    @Deprecated
    public boolean hasWildOverride(TownyWorld townyWorld, Player player, int n, TownyPermission.ActionType actionType) {
        return this.hasWildOverride(townyWorld, player, n, (byte)0, actionType);
    }

    @Deprecated
    public boolean hasOwnTownOverride(Player player, int n, TownyPermission.ActionType actionType) {
        return this.hasOwnTownOverride(player, n, (byte)0, actionType);
    }

    @Deprecated
    public boolean hasAllTownOverride(Player player, int n, TownyPermission.ActionType actionType) {
        return this.hasAllTownOverride(player, n, (byte)0, actionType);
    }

    public boolean hasWildOverride(TownyWorld townyWorld, Player player, int n, byte by, TownyPermission.ActionType actionType) {
        if (this.plugin.isPermissions()) {
            String string = PermissionNodes.TOWNY_WILD_ALL.getNode(actionType.toString().toLowerCase() + "." + n);
            String string2 = PermissionNodes.TOWNY_WILD_ALL.getNode(actionType.toString().toLowerCase() + "." + n + ":" + by);
            boolean bl = player.isPermissionSet(string2);
            boolean bl2 = this.has(player, string);
            boolean bl3 = this.has(player, string2);
            if (bl3 && bl || bl2 && !bl) {
                return true;
            }
            switch (actionType) {
                case BUILD: {
                    return townyWorld.getUnclaimedZoneBuild();
                }
                case DESTROY: {
                    return townyWorld.getUnclaimedZoneDestroy();
                }
                case SWITCH: {
                    return townyWorld.getUnclaimedZoneSwitch();
                }
                case ITEM_USE: {
                    return townyWorld.getUnclaimedZoneItemUse();
                }
            }
        } else {
            if (this.isTownyAdmin(player)) {
                return true;
            }
            switch (actionType) {
                case BUILD: {
                    return townyWorld.getUnclaimedZoneBuild() != false || townyWorld.isUnclaimedZoneIgnoreId(n);
                }
                case DESTROY: {
                    return townyWorld.getUnclaimedZoneDestroy() != false || townyWorld.isUnclaimedZoneIgnoreId(n);
                }
                case SWITCH: {
                    return townyWorld.getUnclaimedZoneSwitch() != false || townyWorld.isUnclaimedZoneIgnoreId(n);
                }
                case ITEM_USE: {
                    return townyWorld.getUnclaimedZoneItemUse() != false || townyWorld.isUnclaimedZoneIgnoreId(n);
                }
            }
        }
        return false;
    }

    public boolean unclaimedZoneAction(TownyWorld townyWorld, int n, TownyPermission.ActionType actionType) {
        switch (actionType) {
            case BUILD: {
                return townyWorld.getUnclaimedZoneBuild() != false || townyWorld.isUnclaimedZoneIgnoreId(n);
            }
            case DESTROY: {
                return townyWorld.getUnclaimedZoneDestroy() != false || townyWorld.isUnclaimedZoneIgnoreId(n);
            }
            case SWITCH: {
                return townyWorld.getUnclaimedZoneSwitch() != false || townyWorld.isUnclaimedZoneIgnoreId(n);
            }
            case ITEM_USE: {
                return townyWorld.getUnclaimedZoneItemUse() != false || townyWorld.isUnclaimedZoneIgnoreId(n);
            }
        }
        return false;
    }

    public boolean hasOwnTownOverride(Player player, int n, byte by, TownyPermission.ActionType actionType) {
        if (this.plugin.isPermissions()) {
            String string = PermissionNodes.TOWNY_CLAIMED_ALL.getNode("owntown." + actionType.toString().toLowerCase() + "." + n);
            String string2 = PermissionNodes.TOWNY_CLAIMED_ALL.getNode("owntown." + actionType.toString().toLowerCase() + "." + n + ":" + by);
            boolean bl = player.isPermissionSet(string2);
            boolean bl2 = this.has(player, string);
            boolean bl3 = this.has(player, string2);
            TownyMessaging.sendDebugMsg(player.getName() + " - owntown (Block: " + bl2 + " - Data: " + bl3 + ":" + (bl ? "Registered" : "None"));
            if (bl3 && bl || bl2 && !bl || this.hasAllTownOverride(player, n, by, actionType)) {
                return true;
            }
        } else if (this.isTownyAdmin(player)) {
            return true;
        }
        return false;
    }

    public boolean hasAllTownOverride(Player player, int n, byte by, TownyPermission.ActionType actionType) {
        if (this.plugin.isPermissions()) {
            String string = PermissionNodes.TOWNY_CLAIMED_ALL.getNode("alltown." + actionType.toString().toLowerCase() + "." + n);
            String string2 = PermissionNodes.TOWNY_CLAIMED_ALL.getNode("alltown." + actionType.toString().toLowerCase() + "." + n + ":" + by);
            boolean bl = player.isPermissionSet(string2);
            boolean bl2 = this.has(player, string);
            boolean bl3 = this.has(player, string2);
            TownyMessaging.sendDebugMsg(player.getName() + " - alltown (Block: " + bl2 + " - Data: " + bl3 + ":" + (bl ? "Registered" : "None"));
            if (bl3 && bl || bl2 && !bl) {
                return true;
            }
        } else if (this.isTownyAdmin(player)) {
            return true;
        }
        return false;
    }

    public boolean isTownyAdmin(Player player) {
        return player == null || player.isOp() || this.plugin.isPermissions() && this.has(player, PermissionNodes.TOWNY_ADMIN.getNode());
    }

    public boolean testPermission(Player player, String string) {
        return TownyUniverse.getPermissionSource().isTownyAdmin(player) || this.has(player, string);
    }

    public boolean has(Player player, String string) {
        if (player.isOp()) {
            return true;
        }
        if (player.isPermissionSet(string)) {
            return player.hasPermission(string);
        }
        String[] stringArray = string.split("\\.");
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (String string2 : stringArray) {
            stringBuilder.append('*');
            if (player.hasPermission("-" + stringBuilder.toString())) {
                return false;
            }
            if (player.hasPermission(stringBuilder.toString())) {
                return true;
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append(string2).append('.');
        }
        return false;
    }
}

