/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.questioner;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.questioner.ResidentNationQuestionTask;
import com.palmergames.bukkit.util.ChatTools;

public class JoinNationTask
extends ResidentNationQuestionTask {
    public JoinNationTask(Resident resident, Nation nation) {
        super(resident, nation);
    }

    @Override
    public void run() {
        try {
            this.nation.addTown(this.resident.getTown());
            TownyUniverse.getDataSource().saveResident(this.resident);
            TownyUniverse.getDataSource().saveTown(this.resident.getTown());
            TownyUniverse.getDataSource().saveNation(this.nation);
            TownyMessaging.sendNationMessage(this.nation, ChatTools.color(String.format(TownySettings.getLangString("msg_join_nation"), this.resident.getTown().getName())));
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            try {
                TownyMessaging.sendResidentMessage(this.resident, alreadyRegisteredException.getMessage());
            }
            catch (TownyException townyException) {}
        }
        catch (NotRegisteredException notRegisteredException) {
            notRegisteredException.printStackTrace();
        }
    }
}

