/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyObservableType;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.tasks.ResidentPurge;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;

public class DailyTimerTask
extends TownyTimerTask {
    public DailyTimerTask(Towny towny) {
        super(towny);
    }

    @Override
    public void run() {
        long l = System.currentTimeMillis();
        TownyMessaging.sendDebugMsg("New Day");
        if (TownyEconomyHandler.isActive() && TownySettings.isTaxingDaily()) {
            TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_new_day_tax"), new Object[0]));
            try {
                TownyMessaging.sendDebugMsg("Collecting Town Taxes");
                this.collectTownTaxes();
                TownyMessaging.sendDebugMsg("Collecting Nation Taxes");
                this.collectNationTaxes();
                TownyMessaging.sendDebugMsg("Collecting Town Costs");
                this.collectTownCosts();
                TownyMessaging.sendDebugMsg("Collecting Nation Costs");
                this.collectNationCosts();
            }
            catch (EconomyException economyException) {
            }
            catch (TownyException townyException) {
                townyException.printStackTrace();
            }
        } else {
            TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_new_day"), new Object[0]));
        }
        if (TownySettings.isDeletingOldResidents()) {
            new ResidentPurge(this.plugin, null, TownySettings.getDeleteTime() * 1000L).start();
        }
        TownyMessaging.sendDebugMsg("Cleaning up old backups.");
        TownyUniverse.getDataSource().cleanupBackups();
        if (TownySettings.isBackingUpDaily()) {
            try {
                TownyMessaging.sendDebugMsg("Making backup.");
                TownyUniverse.getDataSource().backup();
            }
            catch (IOException iOException) {
                TownyMessaging.sendErrorMsg("Could not create backup.");
                iOException.printStackTrace();
            }
        }
        TownyMessaging.sendDebugMsg("Finished New Day Code");
        TownyMessaging.sendDebugMsg("Universe Stats:");
        TownyMessaging.sendDebugMsg("    Residents: " + TownyUniverse.getDataSource().getResidents().size());
        TownyMessaging.sendDebugMsg("    Towns: " + TownyUniverse.getDataSource().getTowns().size());
        TownyMessaging.sendDebugMsg("    Nations: " + TownyUniverse.getDataSource().getNations().size());
        for (TownyWorld townyWorld : TownyUniverse.getDataSource().getWorlds()) {
            TownyMessaging.sendDebugMsg("    " + townyWorld.getName() + " (townblocks): " + townyWorld.getTownBlocks().size());
        }
        TownyMessaging.sendDebugMsg("Memory (Java Heap):");
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (max)", Runtime.getRuntime().maxMemory() / 1024L / 1024L));
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (total)", Runtime.getRuntime().totalMemory() / 1024L / 1024L));
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (free)", Runtime.getRuntime().freeMemory() / 1024L / 1024L));
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (used=total-free)", (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L));
        TownyMessaging.sendDebugMsg("newDay took " + (System.currentTimeMillis() - l) + "ms");
    }

    public void collectNationTaxes() throws EconomyException {
        ArrayList<Nation> arrayList = new ArrayList<Nation>(TownyUniverse.getDataSource().getNations());
        ListIterator listIterator = arrayList.listIterator();
        Nation nation = null;
        while (listIterator.hasNext()) {
            nation = (Nation)listIterator.next();
            if (!TownyUniverse.getDataSource().hasNation(nation.getName())) continue;
            this.collectNationTaxes(nation);
        }
        this.universe.setChangedNotify(TownyObservableType.COLLECTED_NATION_TAX);
    }

    protected void collectNationTaxes(Nation nation) throws EconomyException {
        if (nation.getTaxes() > 0.0) {
            ArrayList<Town> arrayList = new ArrayList<Town>(nation.getTowns());
            ListIterator listIterator = arrayList.listIterator();
            Town town = null;
            while (listIterator.hasNext()) {
                town = (Town)listIterator.next();
                if (TownyUniverse.getDataSource().hasTown(town.getName())) {
                    if (town.isCapital() || !town.hasUpkeep() || town.payTo(nation.getTaxes(), nation, "Nation Tax")) continue;
                    try {
                        TownyMessaging.sendNationMessage(nation, TownySettings.getCouldntPayTaxesMsg(town, "nation"));
                        nation.removeTown(town);
                    }
                    catch (EmptyNationException emptyNationException) {
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                    TownyUniverse.getDataSource().saveTown(town);
                    TownyUniverse.getDataSource().saveNation(nation);
                    continue;
                }
                TownyMessaging.sendTownMessage(town, TownySettings.getPayedTownTaxMsg() + nation.getTaxes());
            }
        }
    }

    public void collectTownTaxes() throws EconomyException {
        ArrayList<Town> arrayList = new ArrayList<Town>(TownyUniverse.getDataSource().getTowns());
        ListIterator listIterator = arrayList.listIterator();
        Town town = null;
        while (listIterator.hasNext()) {
            town = (Town)listIterator.next();
            if (!TownyUniverse.getDataSource().hasTown(town.getName())) continue;
            this.collectTownTaxes(town);
        }
        this.universe.setChangedNotify(TownyObservableType.COLLECTED_TONW_TAX);
    }

    protected void collectTownTaxes(Town town) throws EconomyException {
        Object object;
        ListIterator listIterator;
        ArrayList<Object> arrayList;
        if (town.getTaxes() > 0.0) {
            arrayList = new ArrayList<Resident>(town.getResidents());
            listIterator = arrayList.listIterator();
            object = null;
            while (listIterator.hasNext()) {
                object = (Resident)listIterator.next();
                if (!TownyUniverse.getDataSource().hasResident(((TownyObject)object).getName())) continue;
                if (town.isMayor((Resident)object) || town.hasAssistant((Resident)object)) {
                    try {
                        TownyMessaging.sendResidentMessage((Resident)object, TownySettings.getTaxExemptMsg());
                    }
                    catch (TownyException townyException) {}
                    continue;
                }
                if (town.isTaxPercentage()) {
                    double d = ((TownyEconomyObject)object).getHoldingBalance() * town.getTaxes() / 100.0;
                    ((TownyEconomyObject)object).payTo(d, town, "Town Tax (Percentage)");
                    continue;
                }
                if (((TownyEconomyObject)object).payTo(town.getTaxes(), town, "Town Tax")) continue;
                TownyMessaging.sendTownMessage(town, TownySettings.getCouldntPayTaxesMsg((TownyObject)object, "town"));
                try {
                    ((Resident)object).clear();
                }
                catch (EmptyTownException emptyTownException) {
                    // empty catch block
                }
                TownyUniverse.getDataSource().saveResident((Resident)object);
                TownyUniverse.getDataSource().saveTown(town);
            }
        }
        if (town.getPlotTax() > 0.0 || town.getCommercialPlotTax() > 0.0 || town.getEmbassyPlotTax() > 0.0) {
            arrayList = new ArrayList<TownBlock>(town.getTownBlocks());
            listIterator = arrayList.listIterator();
            object = null;
            while (listIterator.hasNext()) {
                object = (TownBlock)listIterator.next();
                if (!((TownBlock)object).hasResident()) continue;
                try {
                    Resident resident = ((TownBlock)object).getResident();
                    if (!TownyUniverse.getDataSource().hasResident(resident.getName()) || town.isMayor(resident) || town.hasAssistant(resident) || resident.payTo(((TownBlock)object).getType().getTax(town), town, String.format("Plot Tax (%s)", new Object[]{((TownBlock)object).getType()}))) continue;
                    TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_couldnt_pay_plot_taxes"), resident));
                    ((TownBlock)object).setResident(null);
                    ((TownBlock)object).setPlotPrice(-1.0);
                    ((TownBlock)object).setType(((TownBlock)object).getType());
                    TownyUniverse.getDataSource().saveResident(resident);
                    TownyUniverse.getDataSource().saveTownBlock((TownBlock)object);
                }
                catch (NotRegisteredException notRegisteredException) {}
            }
        }
    }

    public void collectTownCosts() throws EconomyException, TownyException {
        ArrayList<Town> arrayList = new ArrayList<Town>(TownyUniverse.getDataSource().getTowns());
        ListIterator listIterator = arrayList.listIterator();
        Town town = null;
        while (listIterator.hasNext()) {
            town = (Town)listIterator.next();
            if (!TownyUniverse.getDataSource().hasTown(town.getName()) || !town.hasUpkeep()) continue;
            double d = TownySettings.getTownUpkeepCost(town);
            if (d > 0.0) {
                if (town.pay(d, "Town Upkeep")) continue;
                TownyUniverse.getDataSource().removeTown(town);
                TownyMessaging.sendGlobalMessage(town.getName() + TownySettings.getLangString("msg_bankrupt_town"));
                continue;
            }
            if (!(d < 0.0)) continue;
            if (TownySettings.isUpkeepPayingPlots()) {
                ArrayList<TownBlock> arrayList2 = new ArrayList<TownBlock>(town.getTownBlocks());
                for (TownBlock townBlock : arrayList2) {
                    if (townBlock.hasResident()) {
                        townBlock.getResident().pay(d / (double)arrayList2.size(), "Negative Town Upkeep - Plot income");
                        continue;
                    }
                    town.pay(d / (double)arrayList2.size(), "Negative Town Upkeep - Plot income");
                }
                continue;
            }
            town.pay(d, "Negative Town Upkeep");
        }
        this.universe.setChangedNotify(TownyObservableType.UPKEEP_TOWN);
    }

    public void collectNationCosts() throws EconomyException {
        ArrayList<Nation> arrayList = new ArrayList<Nation>(TownyUniverse.getDataSource().getNations());
        ListIterator listIterator = arrayList.listIterator();
        Nation nation = null;
        while (listIterator.hasNext()) {
            nation = (Nation)listIterator.next();
            if (!TownyUniverse.getDataSource().hasNation(nation.getName())) continue;
            if (!nation.pay(TownySettings.getNationUpkeepCost(nation), "Nation Upkeep")) {
                TownyUniverse.getDataSource().removeNation(nation);
                TownyMessaging.sendGlobalMessage(nation.getName() + TownySettings.getLangString("msg_bankrupt_nation"));
            }
            if (!nation.isNeutral() || nation.pay(TownySettings.getNationNeutralityCost(), "Nation Neutrality Upkeep")) continue;
            try {
                nation.setNeutral(false);
            }
            catch (TownyException townyException) {
                townyException.printStackTrace();
            }
            TownyUniverse.getDataSource().saveNation(nation);
            TownyMessaging.sendNationMessage(nation, TownySettings.getLangString("msg_nation_not_neutral"));
        }
        this.universe.setChangedNotify(TownyObservableType.UPKEEP_NATION);
    }
}

