/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyObservableType;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.SetDefaultModes;
import com.palmergames.bukkit.util.BukkitTools;
import org.bukkit.entity.Player;

public class OnPlayerLogin
implements Runnable {
    Towny plugin;
    TownyUniverse universe;
    volatile Player player;

    public OnPlayerLogin(Towny towny, Player player) {
        this.plugin = towny;
        this.universe = towny.getTownyUniverse();
        this.player = player;
    }

    @Override
    public void run() {
        Resident resident = null;
        if (!TownyUniverse.getDataSource().hasResident(this.player.getName())) {
            try {
                TownyUniverse.getDataSource().newResident(this.player.getName());
                resident = TownyUniverse.getDataSource().getResident(this.player.getName());
                TownyMessaging.sendMessage((Object)this.player, TownySettings.getRegistrationMsg(this.player.getName()));
                resident.setRegistered(System.currentTimeMillis());
                if (!TownySettings.getDefaultTownName().equals("")) {
                    try {
                        Town town = TownyUniverse.getDataSource().getTown(TownySettings.getDefaultTownName());
                        town.addResident(resident);
                        TownyUniverse.getDataSource().saveTown(town);
                    }
                    catch (NotRegisteredException notRegisteredException) {
                    }
                    catch (AlreadyRegisteredException alreadyRegisteredException) {
                        // empty catch block
                    }
                }
                TownyUniverse.getDataSource().saveResident(resident);
                TownyUniverse.getDataSource().saveResidentList();
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
            }
            catch (NotRegisteredException notRegisteredException) {}
        } else {
            try {
                resident = TownyUniverse.getDataSource().getResident(this.player.getName());
                resident.setLastOnline(System.currentTimeMillis());
                TownyUniverse.getDataSource().saveResident(resident);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        if (resident != null) {
            TownyPerms.assignPermissions(resident, this.player);
        }
        try {
            TownyMessaging.sendTownBoard(this.player, resident.getTown());
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (TownyUniverse.isWarTime()) {
            this.universe.getWarEvent().sendScores(this.player, 3);
        }
        if (BukkitTools.scheduleSyncDelayedTask(new SetDefaultModes(this.player.getName(), false), 1L) == -1) {
            TownyMessaging.sendErrorMsg("Could not set default modes for " + this.player.getName() + ".");
        }
        this.warningMessage(resident);
        this.universe.setChangedNotify(TownyObservableType.PLAYER_LOGIN);
    }

    private void warningMessage(Resident resident) {
        block10: {
            if (TownyEconomyHandler.isActive() && TownySettings.isTaxingDaily() && resident.hasTown()) {
                try {
                    Town town = resident.getTown();
                    if (town.hasUpkeep()) {
                        double d = TownySettings.getTownUpkeepCost(town);
                        try {
                            if (d > 0.0 && !town.canPayFromHoldings(d)) {
                                TownyMessaging.sendMessage((Object)resident, String.format(TownySettings.getLangString("msg_warning_delete"), town.getName()));
                            }
                        }
                        catch (EconomyException economyException) {
                            // empty catch block
                        }
                    }
                    if (!town.hasNation()) break block10;
                    Nation nation = town.getNation();
                    double d = TownySettings.getNationUpkeepCost(nation);
                    try {
                        if (d > 0.0 && !nation.canPayFromHoldings(d)) {
                            TownyMessaging.sendMessage((Object)resident, String.format(TownySettings.getLangString("msg_warning_delete"), nation.getName()));
                        }
                    }
                    catch (EconomyException economyException) {}
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
        }
    }
}

