/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Player;

public class PlotClaim
extends Thread {
    Towny plugin;
    volatile Player player;
    volatile Resident resident;
    volatile TownyWorld world;
    List<WorldCoord> selection;
    boolean claim;
    boolean forced;

    public PlotClaim(Towny towny, Player player, Resident resident, List<WorldCoord> list, boolean bl) {
        this.plugin = towny;
        this.player = player;
        this.resident = resident;
        this.selection = list;
        this.claim = bl;
        this.setPriority(1);
    }

    @Override
    public void run() {
        if (this.player != null) {
            TownyMessaging.sendMsg((Object)this.player, "Processing " + (this.claim ? "Plot Claim..." : "Plot unclaim..."));
        }
        if (this.selection != null) {
            for (WorldCoord worldCoord : this.selection) {
                try {
                    this.world = worldCoord.getTownyWorld();
                }
                catch (NotRegisteredException notRegisteredException) {
                    TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_err_not_configured"));
                    continue;
                }
                try {
                    if (this.claim) {
                        this.residentClaim(worldCoord);
                        continue;
                    }
                    this.residentUnclaim(worldCoord);
                }
                catch (EconomyException economyException) {
                    TownyMessaging.sendErrorMsg((Object)this.player, economyException.getError());
                }
                catch (TownyException townyException) {
                    TownyMessaging.sendErrorMsg((Object)this.player, townyException.getMessage());
                }
            }
        } else if (!this.claim) {
            this.residentUnclaimAll();
        }
        if (this.player != null) {
            if (this.claim) {
                if (this.selection != null && this.selection.size() > 0) {
                    TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_claimed") + (this.selection.size() > 5 ? "Total TownBlocks: " + this.selection.size() : Arrays.toString(this.selection.toArray(new WorldCoord[0]))));
                } else {
                    TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_not_claimed_1"));
                }
            } else if (this.selection != null) {
                TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_unclaimed") + (this.selection.size() > 5 ? "Total TownBlocks: " + this.selection.size() : Arrays.toString(this.selection.toArray(new WorldCoord[0]))));
            } else {
                TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_unclaimed"));
            }
        }
        TownyUniverse.getDataSource().saveResident(this.resident);
        this.plugin.resetCache();
    }

    private boolean residentClaim(WorldCoord worldCoord) throws TownyException, EconomyException {
        if (this.resident.hasTown()) {
            try {
                TownBlock townBlock = worldCoord.getTownBlock();
                Town town = townBlock.getTown();
                if (this.resident.getTown() != town && !townBlock.getType().equals((Object)TownBlockType.EMBASSY)) {
                    throw new TownyException(TownySettings.getLangString("msg_err_not_part_town"));
                }
                try {
                    Resident resident = townBlock.getResident();
                    if (townBlock.getPlotPrice() != -1.0) {
                        if (TownySettings.isUsingEconomy() && !this.resident.payTo(townBlock.getPlotPrice(), resident, "Plot - Buy From Seller")) {
                            throw new TownyException(TownySettings.getLangString("msg_no_money_purchase_plot"));
                        }
                        int n = TownySettings.getMaxResidentPlots(this.resident);
                        if (n >= 0 && this.resident.getTownBlocks().size() + 1 > n) {
                            throw new TownyException(String.format(TownySettings.getLangString("msg_max_plot_own"), n));
                        }
                        TownyMessaging.sendTownMessage(town, TownySettings.getBuyResidentPlotMsg(this.resident.getName(), resident.getName(), townBlock.getPlotPrice()));
                        townBlock.setPlotPrice(-1.0);
                        townBlock.setResident(this.resident);
                        townBlock.setType(townBlock.getType());
                        TownyUniverse.getDataSource().saveResident(resident);
                        TownyUniverse.getDataSource().saveTownBlock(townBlock);
                        this.plugin.updateCache(worldCoord);
                        return true;
                    }
                    if (town.isMayor(this.resident) || town.hasAssistant(this.resident)) {
                        if (TownySettings.isUsingEconomy() && !town.payTo(0.0, resident, "Plot - Buy Back")) {
                            throw new TownyException(TownySettings.getLangString("msg_town_no_money_purchase_plot"));
                        }
                        TownyMessaging.sendTownMessage(town, TownySettings.getBuyResidentPlotMsg(town.getName(), resident.getName(), 0.0));
                        townBlock.setResident(null);
                        townBlock.setPlotPrice(-1.0);
                        townBlock.setType(townBlock.getType());
                        TownyUniverse.getDataSource().saveResident(resident);
                        TownyUniverse.getDataSource().saveTownBlock(townBlock);
                        return true;
                    }
                    throw new AlreadyRegisteredException(String.format(TownySettings.getLangString("msg_already_claimed"), resident.getName()));
                }
                catch (NotRegisteredException notRegisteredException) {
                    if (townBlock.getPlotPrice() == -1.0) {
                        throw new TownyException(TownySettings.getLangString("msg_err_plot_nfs"));
                    }
                    if (TownySettings.isUsingEconomy() && !this.resident.payTo(townBlock.getPlotPrice(), town, "Plot - Buy From Town")) {
                        throw new TownyException(TownySettings.getLangString("msg_no_money_purchase_plot"));
                    }
                    townBlock.setPlotPrice(-1.0);
                    townBlock.setResident(this.resident);
                    townBlock.setType(townBlock.getType());
                    TownyUniverse.getDataSource().saveTownBlock(townBlock);
                    return true;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                throw new TownyException(TownySettings.getLangString("msg_err_not_part_town"));
            }
        }
        throw new TownyException(TownySettings.getLangString("msg_err_not_in_town_claim"));
    }

    private boolean residentUnclaim(WorldCoord worldCoord) throws TownyException {
        try {
            TownBlock townBlock = worldCoord.getTownBlock();
            townBlock.setResident(null);
            townBlock.setPlotPrice(townBlock.getTown().getPlotPrice());
            townBlock.setType(townBlock.getType());
            TownyUniverse.getDataSource().saveTownBlock(townBlock);
            this.plugin.updateCache(worldCoord);
        }
        catch (NotRegisteredException notRegisteredException) {
            throw new TownyException(TownySettings.getLangString("msg_not_own_place"));
        }
        return true;
    }

    private void residentUnclaimAll() {
        ArrayList<TownBlock> arrayList = new ArrayList<TownBlock>(this.resident.getTownBlocks());
        for (TownBlock townBlock : arrayList) {
            try {
                this.residentUnclaim(townBlock.getWorldCoord());
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)this.player, townyException.getMessage());
            }
        }
    }
}

