/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import java.util.ArrayList;

public class RepeatingTimerTask
extends TownyTimerTask {
    private Long timerCounter = 0L;

    public RepeatingTimerTask(Towny towny) {
        super(towny);
    }

    @Override
    public void run() {
        if (TownyRegenAPI.hasPlotChunks()) {
            this.timerCounter = this.timerCounter + 1L;
            if (Math.max(1L, TownySettings.getPlotManagementSpeed()) >= this.timerCounter) {
                for (PlotBlockData plotBlockData : new ArrayList<PlotBlockData>(TownyRegenAPI.getPlotChunks().values())) {
                    if (plotBlockData.restoreNextBlock()) continue;
                    TownyRegenAPI.deletePlotChunk(plotBlockData);
                    TownyRegenAPI.deletePlotChunkSnapshot(plotBlockData);
                }
                this.timerCounter = 0L;
            }
        }
        if (TownyRegenAPI.hasWorldCoords()) {
            try {
                PlotBlockData plotBlockData;
                TownBlock townBlock = TownyRegenAPI.getWorldCoord().getTownBlock();
                plotBlockData = new PlotBlockData(townBlock);
                plotBlockData.initialize();
                if (!plotBlockData.getBlockList().isEmpty() && plotBlockData.getBlockList() != null) {
                    TownyRegenAPI.addPlotChunkSnapshot(plotBlockData);
                }
                plotBlockData = null;
                townBlock.setLocked(false);
                TownyUniverse.getDataSource().saveTownBlock(townBlock);
                this.plugin.updateCache(townBlock.getWorldCoord());
                if (!TownyRegenAPI.hasWorldCoords()) {
                    TownyLogger.log.info("Plot snapshots completed.");
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        if (TownyRegenAPI.hasDeleteTownBlockIdQueue()) {
            TownyRegenAPI.doDeleteTownBlockIds(TownyRegenAPI.getDeleteTownBlockIdQueue());
        }
    }
}

