/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import java.util.List;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;

public class CombatUtil {
    public static boolean preventDamageCall(Entity entity, Entity entity2) {
        try {
            TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(entity2.getWorld().getName());
            if (!townyWorld.isUsingTowny()) {
                return false;
            }
            Player player = null;
            Player player2 = null;
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                entity = projectile.getShooter();
            }
            if (entity instanceof Player) {
                player = (Player)entity;
            }
            if (entity2 instanceof Player) {
                player2 = (Player)entity2;
            }
            return CombatUtil.preventDamageCall(townyWorld, entity, entity2, player, player2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean preventDamageCall(TownyWorld townyWorld, Entity entity, Entity entity2, Player player, Player player2) {
        if (!townyWorld.isUsingTowny()) {
            return false;
        }
        if (player != null) {
            Coord coord = Coord.parseCoord(entity2);
            TownBlock townBlock = null;
            TownBlock townBlock2 = null;
            try {
                townBlock2 = townyWorld.getTownBlock(Coord.parseCoord(entity));
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            try {
                townBlock = townyWorld.getTownBlock(coord);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            if (player2 != null || townBlock != null && entity2 instanceof Wolf && ((Wolf)entity2).isTamed() && !((Wolf)entity2).getOwner().equals((AnimalTamer)entity)) {
                if (townyWorld.isWarZone(coord)) {
                    return false;
                }
                if (CombatUtil.isPvPPlot(player, player2)) {
                    return false;
                }
                if (CombatUtil.preventFriendlyFire(player, player2)) {
                    return true;
                }
                if (CombatUtil.preventPvP(townyWorld, townBlock2)) {
                    return true;
                }
                if (CombatUtil.preventPvP(townyWorld, townBlock)) {
                    return true;
                }
            } else if (townBlock != null && (entity2 instanceof Animals || entity2 instanceof Villager) && !PlayerCacheUtil.getCachePermission(player, player.getLocation(), 3, (byte)0, TownyPermission.ActionType.DESTROY)) {
                return true;
            }
        }
        return false;
    }

    public static boolean preventPvP(TownyWorld townyWorld, TownBlock townBlock) {
        block7: {
            if (townBlock != null) {
                try {
                    if (townBlock.getTown().isAdminDisabledPVP()) {
                        return true;
                    }
                    if (!(townBlock.getTown().isPVP() || townBlock.getPermissions().pvp || townyWorld.isForcePVP())) {
                        return true;
                    }
                    break block7;
                }
                catch (NotRegisteredException notRegisteredException) {
                    if (!CombatUtil.isWorldPvP(townyWorld)) {
                        return true;
                    }
                    break block7;
                }
            }
            if (!CombatUtil.isWorldPvP(townyWorld)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isWorldPvP(TownyWorld townyWorld) {
        return townyWorld.isForcePVP() || townyWorld.isPVP();
    }

    public static boolean preventFriendlyFire(Player player, Player player2) {
        if (player == player2) {
            return false;
        }
        if (player != null && player2 != null && !TownySettings.getFriendlyFire() && CombatUtil.isAlly(player.getName(), player2.getName())) {
            try {
                TownBlock townBlock = new WorldCoord(player2.getWorld().getName(), Coord.parseCoord((Entity)player2)).getTownBlock();
                if (!townBlock.getType().equals((Object)TownBlockType.ARENA)) {
                    return true;
                }
            }
            catch (TownyException townyException) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPvPPlot(Player player, Player player2) {
        if (player != null && player2 != null) {
            try {
                TownBlock townBlock = new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player)).getTownBlock();
                TownBlock townBlock2 = new WorldCoord(player2.getWorld().getName(), Coord.parseCoord((Entity)player2)).getTownBlock();
                if (townBlock2.getType().equals((Object)TownBlockType.ARENA) && townBlock.getType().equals((Object)TownBlockType.ARENA)) {
                    return true;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isAlly(String string, String string2) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(string);
            Resident resident2 = TownyUniverse.getDataSource().getResident(string2);
            if (resident.getTown() == resident2.getTown()) {
                return true;
            }
            if (resident.getTown().getNation() == resident2.getTown().getNation()) {
                return true;
            }
            if (resident.getTown().getNation().hasAlly(resident2.getTown().getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            return false;
        }
        return false;
    }

    public static boolean isAlly(Town town, Town town2) {
        try {
            if (town == town2) {
                return true;
            }
            if (town.getNation() == town2.getNation()) {
                return true;
            }
            if (town.getNation().hasAlly(town2.getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            return false;
        }
        return false;
    }

    public static boolean canAttackEnemy(String string, String string2) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(string);
            Resident resident2 = TownyUniverse.getDataSource().getResident(string2);
            if (resident.getTown() == resident2.getTown()) {
                return false;
            }
            if (resident.getTown().getNation() == resident2.getTown().getNation()) {
                return false;
            }
            Nation nation = resident.getTown().getNation();
            Nation nation2 = resident2.getTown().getNation();
            if (nation.isNeutral() || nation2.isNeutral()) {
                return false;
            }
            if (nation.hasEnemy(nation2)) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            return false;
        }
        return false;
    }

    public static boolean areAllAllies(List<Nation> list) {
        if (list.size() <= 1) {
            return true;
        }
        for (int i = 0; i < list.size() - 1; ++i) {
            if (list.get(i).hasAlly(list.get(i + 1))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEnemy(String string, String string2) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(string);
            Resident resident2 = TownyUniverse.getDataSource().getResident(string2);
            if (resident.getTown() == resident2.getTown()) {
                return false;
            }
            if (resident.getTown().getNation() == resident2.getTown().getNation()) {
                return false;
            }
            if (resident.getTown().getNation().hasEnemy(resident2.getTown().getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            return false;
        }
        return false;
    }

    public static boolean isEnemy(Town town, Town town2) {
        try {
            if (town == town2) {
                return false;
            }
            if (town.getNation() == town2.getNation()) {
                return false;
            }
            if (town.getNation().hasEnemy(town2.getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            return false;
        }
        return false;
    }

    public boolean isEnemyTownBlock(Player player, WorldCoord worldCoord) {
        try {
            return CombatUtil.isEnemy(TownyUniverse.getDataSource().getResident(player.getName()).getTown(), worldCoord.getTownBlock().getTown());
        }
        catch (NotRegisteredException notRegisteredException) {
            return false;
        }
    }
}

