/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.eventwar;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.war.eventwar.StartWarTimerTask;
import com.palmergames.bukkit.towny.war.eventwar.WarSpoils;
import com.palmergames.bukkit.towny.war.eventwar.WarTimerTask;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.ServerBroadCastTimerTask;
import com.palmergames.util.KeyValue;
import com.palmergames.util.KeyValueTable;
import com.palmergames.util.TimeMgmt;
import com.palmergames.util.TimeTools;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitScheduler;

public class War {
    private Hashtable<WorldCoord, Integer> warZone = new Hashtable();
    private Hashtable<Town, Integer> townScores = new Hashtable();
    private List<Town> warringTowns = new ArrayList<Town>();
    private List<Nation> warringNations = new ArrayList<Nation>();
    private Towny plugin;
    private TownyUniverse universe;
    private boolean warTime = false;
    private List<Integer> warTaskIds = new ArrayList<Integer>();
    private WarSpoils warSpoils = new WarSpoils();

    public War(Towny towny, int n) {
        this.plugin = towny;
        this.universe = towny.getTownyUniverse();
        this.setupDelay(n);
    }

    public void addTaskId(int n) {
        this.warTaskIds.add(n);
    }

    public void clearTaskIds() {
        this.warTaskIds.clear();
    }

    public void cancelTasks(BukkitScheduler bukkitScheduler) {
        for (Integer n : this.getTaskIds()) {
            bukkitScheduler.cancelTask(n.intValue());
        }
        this.clearTaskIds();
    }

    public List<Integer> getTaskIds() {
        return new ArrayList<Integer>(this.warTaskIds);
    }

    public Towny getPlugin() {
        return this.plugin;
    }

    public void setPlugin(Towny towny) {
        this.plugin = towny;
    }

    public void setupDelay(int n) {
        if (n <= 0) {
            this.start();
        } else {
            for (Long l : TimeMgmt.getCountdownDelays(n, TimeMgmt.defaultCountdownDelays)) {
                int n2 = BukkitTools.scheduleAsyncDelayedTask(new ServerBroadCastTimerTask(this.plugin, String.format("War starts in %s", TimeMgmt.formatCountdownTime(l))), TimeTools.convertToTicks((long)n - l));
                if (n2 == -1) {
                    TownyMessaging.sendErrorMsg("Could not schedule a countdown message for war event.");
                    this.end();
                    continue;
                }
                this.addTaskId(n2);
            }
            int n3 = BukkitTools.scheduleAsyncDelayedTask(new StartWarTimerTask(this.plugin), TimeTools.convertToTicks(n));
            if (n3 == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule setup delay for war event.");
                this.end();
            } else {
                this.addTaskId(n3);
            }
        }
    }

    public boolean isWarTime() {
        return this.warTime;
    }

    public TownyUniverse getTownyUniverse() {
        return this.universe;
    }

    public void start() {
        this.warTime = true;
        try {
            this.warSpoils.pay(TownySettings.getBaseSpoilsOfWar(), "Start of War - Base Spoils");
            TownyMessaging.sendMsg("[War] Seeding spoils of war with " + TownySettings.getBaseSpoilsOfWar());
        }
        catch (EconomyException economyException) {
            TownyMessaging.sendErrorMsg("[War] Could not seed spoils of war.");
        }
        for (Nation nation : TownyUniverse.getDataSource().getNations()) {
            if (!nation.isNeutral()) {
                this.add(nation);
                TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_war_join_nation"), nation.getName()));
                continue;
            }
            if (TownySettings.isDeclaringNeutral()) continue;
            try {
                nation.setNeutral(false);
                this.add(nation);
                TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_war_join_forced"), nation.getName()));
            }
            catch (TownyException townyException) {
                townyException.printStackTrace();
            }
        }
        int n = BukkitTools.scheduleAsyncRepeatingTask(new WarTimerTask(this.plugin, this), 0L, TimeTools.convertToTicks(5L));
        if (n == -1) {
            TownyMessaging.sendErrorMsg("Could not schedule war event loop.");
            this.end();
        } else {
            this.addTaskId(n);
        }
        this.checkEnd();
    }

    public void end() {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            this.sendStats(player);
        }
        try {
            double d = this.getWarSpoils().getHoldingBalance() / 2.0;
            try {
                double d2 = d / (double)this.warringNations.size();
                for (Nation nation : this.warringNations) {
                    this.getWarSpoils().payTo(d2, nation, "War - Nation Winnings");
                    TownyMessaging.sendGlobalMessage("Winning Nation: " + nation.getName() + " won " + TownyEconomyHandler.getFormattedBalance(d2) + ".");
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            try {
                KeyValue<Town, Integer> keyValue = this.getWinningTownScore();
                this.getWarSpoils().payTo(d, (TownyEconomyObject)keyValue.key, "War - Town Winnings");
                TownyMessaging.sendGlobalMessage("Highest Score: " + ((Town)keyValue.key).getName() + " won " + TownyEconomyHandler.getFormattedBalance(d) + " with the score " + keyValue.value + ".");
            }
            catch (TownyException townyException) {}
        }
        catch (EconomyException economyException) {
            // empty catch block
        }
    }

    public void add(Nation nation) {
        for (Town town : nation.getTowns()) {
            this.add(town);
        }
        this.warringNations.add(nation);
    }

    public void add(Town town) {
        TownyMessaging.sendTownMessage(town, TownySettings.getJoinWarMsg(town));
        this.townScores.put(town, 0);
        this.warringTowns.add(town);
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (town.isHomeBlock(townBlock)) {
                this.warZone.put(townBlock.getWorldCoord(), TownySettings.getWarzoneHomeBlockHealth());
                continue;
            }
            this.warZone.put(townBlock.getWorldCoord(), TownySettings.getWarzoneTownBlockHealth());
        }
    }

    public boolean isWarZone(WorldCoord worldCoord) {
        return this.warZone.containsKey(worldCoord);
    }

    public void townScored(Town town, int n) {
        this.townScores.put(town, this.townScores.get(town) + n);
        TownyMessaging.sendTownMessage(town, TownySettings.getWarTimeScoreMsg(town, n));
    }

    public void damage(Town town, TownBlock townBlock) throws NotRegisteredException {
        WorldCoord worldCoord = townBlock.getWorldCoord();
        int n = this.warZone.get(worldCoord) - 1;
        if (n > 0) {
            this.warZone.put(worldCoord, n);
            TownyMessaging.sendMessageToMode(townBlock.getTown(), "\u00a78[" + townBlock.getTown().getName() + "](" + townBlock.getCoord().toString() + ") HP: " + n, "");
            TownyMessaging.sendMessageToMode(town, "\u00a78[" + townBlock.getTown().getName() + "](" + townBlock.getCoord().toString() + ") HP: " + n, "");
        } else {
            this.remove(town, townBlock);
        }
    }

    public void remove(Town town, TownBlock townBlock) throws NotRegisteredException {
        this.townScored(town, TownySettings.getWarPointsForTownBlock());
        townBlock.getTown().addBonusBlocks(-1);
        town.addBonusBlocks(1);
        try {
            if (!townBlock.getTown().payTo(TownySettings.getWartimeTownBlockLossPrice(), town, "War - TownBlock Loss")) {
                this.remove(townBlock.getTown());
                TownyMessaging.sendTownMessage(townBlock.getTown(), "Your town ran out of funds to support yourself in war.");
            } else {
                TownyMessaging.sendTownMessage(townBlock.getTown(), "Your town lost " + TownyEconomyHandler.getFormattedBalance(TownySettings.getWartimeTownBlockLossPrice()) + ".");
            }
        }
        catch (EconomyException economyException) {
            // empty catch block
        }
        if (townBlock.getTown().isHomeBlock(townBlock)) {
            this.remove(townBlock.getTown());
        } else {
            this.remove(townBlock.getWorldCoord());
        }
        TownyUniverse.getDataSource().saveTown(townBlock.getTown());
        TownyUniverse.getDataSource().saveTown(town);
    }

    public void remove(TownBlock townBlock) throws NotRegisteredException {
        if (townBlock.getTown().isHomeBlock(townBlock)) {
            this.remove(townBlock.getTown());
        } else {
            this.remove(townBlock.getWorldCoord());
        }
    }

    public void eliminate(Town town) {
        this.remove(town);
        try {
            this.checkNation(town.getNation());
        }
        catch (NotRegisteredException notRegisteredException) {
            TownyMessaging.sendErrorMsg("[War] Error checking " + town.getName() + "'s nation.");
        }
        TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeEliminatedMsg(town.getName()));
        this.checkEnd();
    }

    public void eliminate(Nation nation) {
        this.remove(nation);
        TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeEliminatedMsg(nation.getName()));
        this.checkEnd();
    }

    public void nationLeave(Nation nation) {
        this.remove(nation);
        for (Town town : nation.getTowns()) {
            this.remove(town);
        }
        TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeForfeitMsg(nation.getName()));
        this.checkEnd();
    }

    public void townLeave(Town town) {
        this.remove(town);
        TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeForfeitMsg(town.getName()));
        this.checkEnd();
    }

    public void remove(Town town, Nation nation) {
        this.townScored(town, TownySettings.getWarPointsForNation());
        this.warringNations.remove(nation);
    }

    public void remove(Nation nation) {
        this.warringNations.remove(nation);
    }

    public void remove(Town town, Town town2) throws NotRegisteredException {
        this.townScored(town, TownySettings.getWarPointsForTown());
        for (TownBlock townBlock : town2.getTownBlocks()) {
            this.remove(townBlock.getWorldCoord());
        }
        this.warringTowns.remove(town2);
        try {
            if (!this.townsLeft(town2.getNation())) {
                this.eliminate(town2.getNation());
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
    }

    public void remove(Town town) {
        for (TownBlock townBlock : town.getTownBlocks()) {
            this.remove(townBlock.getWorldCoord());
        }
        this.warringTowns.remove(town);
        try {
            if (!this.townsLeft(town.getNation())) {
                this.eliminate(town.getNation());
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
    }

    public boolean townsLeft(Nation nation) {
        return this.warringTowns.containsAll(nation.getTowns());
    }

    public void remove(WorldCoord worldCoord) {
        try {
            Town town = worldCoord.getTownBlock().getTown();
            TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeLoseTownBlockMsg(worldCoord, town.getName()));
            this.warZone.remove(worldCoord);
        }
        catch (NotRegisteredException notRegisteredException) {
            TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeLoseTownBlockMsg(worldCoord));
            this.warZone.remove(worldCoord);
        }
    }

    public void checkEnd() {
        if (this.warringNations.size() <= 1) {
            this.toggleEnd();
        } else if (CombatUtil.areAllAllies(this.warringNations)) {
            this.toggleEnd();
        }
    }

    public void checkTown(Town town) {
        if (this.countActiveWarBlocks(town) == 0) {
            this.eliminate(town);
        }
    }

    public void checkNation(Nation nation) {
        if (this.countActiveTowns(nation) == 0) {
            this.eliminate(nation);
        }
    }

    public int countActiveWarBlocks(Town town) {
        int n = 0;
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (!this.warZone.containsKey(townBlock.getWorldCoord())) continue;
            ++n;
        }
        return n;
    }

    public int countActiveTowns(Nation nation) {
        int n = 0;
        for (Town town : nation.getTowns()) {
            if (!this.warringTowns.contains(town)) continue;
            ++n;
        }
        return n;
    }

    public void toggleEnd() {
        this.warTime = false;
    }

    public void sendStats(Player player) {
        for (String string : this.getStats()) {
            player.sendMessage(string);
        }
    }

    public List<String> getStats() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ChatTools.formatTitle("War Stats"));
        arrayList.add("\u00a72  Nations: \u00a7a" + this.warringNations.size());
        arrayList.add("\u00a72  Towns: \u00a7a" + this.warringTowns.size() + " / " + this.townScores.size());
        arrayList.add("\u00a72  WarZone: \u00a7a" + this.warZone.size() + " Town blocks");
        try {
            arrayList.add("\u00a72  Spoils of War: \u00a7a" + TownyEconomyHandler.getFormattedBalance(this.warSpoils.getHoldingBalance()));
            return arrayList;
        }
        catch (EconomyException economyException) {
            return null;
        }
    }

    public void sendScores(Player player) {
        this.sendScores(player, 10);
    }

    public void sendScores(Player player, int n) {
        for (String string : this.getScores(n)) {
            player.sendMessage(string);
        }
    }

    public List<String> getScores(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ChatTools.formatTitle("War - Top Scores"));
        KeyValueTable<Town, Integer> keyValueTable = new KeyValueTable<Town, Integer>(this.townScores);
        keyValueTable.sortByValue();
        keyValueTable.revese();
        int n2 = 0;
        for (KeyValue<Town, Integer> keyValue : keyValueTable.getKeyValues()) {
            if (n != -1 && ++n2 > n) break;
            Town town = (Town)keyValue.key;
            arrayList.add(String.format("\u00a73%40s \u00a76|\u00a77 %4d", TownyFormatter.getFormattedName(town), (Integer)keyValue.value));
        }
        return arrayList;
    }

    public boolean isWarringNation(Nation nation) {
        return this.warringNations.contains(nation);
    }

    public KeyValue<Town, Integer> getWinningTownScore() throws TownyException {
        KeyValueTable<Town, Integer> keyValueTable = new KeyValueTable<Town, Integer>(this.townScores);
        keyValueTable.sortByValue();
        keyValueTable.revese();
        if (keyValueTable.getKeyValues().size() > 0) {
            return keyValueTable.getKeyValues().get(0);
        }
        throw new TownyException();
    }

    public WarSpoils getWarSpoils() {
        return this.warSpoils;
    }
}

