/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.eventwar;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.util.BukkitTools;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class WarTimerTask
extends TownyTimerTask {
    War warEvent;

    public WarTimerTask(Towny towny, War war) {
        super(towny);
        this.warEvent = war;
    }

    @Override
    public void run() {
        if (!this.warEvent.isWarTime()) {
            this.warEvent.end();
            this.universe.clearWarEvent();
            this.plugin.resetCache();
            TownyMessaging.sendDebugMsg("War ended.");
            return;
        }
        int n = 0;
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            ++n;
            TownyMessaging.sendDebugMsg("[War] " + player.getName() + ": ");
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                if (!resident.hasNation()) continue;
                Nation nation = resident.getTown().getNation();
                TownyMessaging.sendDebugMsg("[War]   hasNation");
                if (nation.isNeutral()) {
                    if (!this.warEvent.isWarringNation(nation)) continue;
                    this.warEvent.nationLeave(nation);
                    continue;
                }
                TownyMessaging.sendDebugMsg("[War]   notNeutral");
                if (!this.warEvent.isWarringNation(nation)) continue;
                TownyMessaging.sendDebugMsg("[War]   warringNation");
                WorldCoord worldCoord = new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player));
                if (!this.warEvent.isWarZone(worldCoord)) continue;
                TownyMessaging.sendDebugMsg("[War]   warZone");
                if (player.getLocation().getBlockY() < TownySettings.getMinWarHeight()) continue;
                TownyMessaging.sendDebugMsg("[War]   aboveMinHeight");
                TownBlock townBlock = worldCoord.getTownBlock();
                if (nation == townBlock.getTown().getNation() || townBlock.getTown().getNation().hasAlly(nation)) continue;
                TownyMessaging.sendDebugMsg("[War]   notAlly");
                this.warEvent.damage(resident.getTown(), townBlock);
                TownyMessaging.sendDebugMsg("[War]   damaged");
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        TownyMessaging.sendDebugMsg("[War] # Players: " + n);
    }
}

