/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.flagwar;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.war.flagwar.Cell;
import com.palmergames.bukkit.towny.war.flagwar.CellAttackThread;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public class CellUnderAttack
extends Cell {
    private Towny plugin;
    private String nameOfFlagOwner;
    private List<Block> beaconFlagBlocks;
    private List<Block> beaconWireframeBlocks;
    private Block flagBaseBlock;
    private Block flagBlock;
    private Block flagLightBlock;
    private int flagColorId;
    private int thread;

    public CellUnderAttack(Towny towny, String string, Block block) {
        super(block.getLocation());
        this.plugin = towny;
        this.nameOfFlagOwner = string;
        this.flagBaseBlock = block;
        this.flagColorId = 0;
        this.thread = -1;
        World world = block.getWorld();
        this.flagBlock = world.getBlockAt(block.getX(), block.getY() + 1, block.getZ());
        this.flagLightBlock = world.getBlockAt(block.getX(), block.getY() + 2, block.getZ());
    }

    public void loadBeacon() {
        this.beaconFlagBlocks = new ArrayList<Block>();
        this.beaconWireframeBlocks = new ArrayList<Block>();
        if (!TownyWarConfig.isDrawingBeacon()) {
            return;
        }
        int n = TownyWarConfig.getBeaconSize();
        if (Coord.getCellSize() < n) {
            return;
        }
        Block block = this.getBeaconMinBlock(this.getFlagBaseBlock().getWorld());
        if (this.getMinimumHeightForBeacon() >= block.getY()) {
            return;
        }
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n; ++k) {
                    Block block2 = this.flagBaseBlock.getWorld().getBlockAt(block.getX() + k, block.getY() + i, block.getZ() + j);
                    if (!block2.isEmpty()) continue;
                    int n3 = this.getEdgeCount(k, i, j, n2);
                    if (n3 == 1) {
                        this.beaconFlagBlocks.add(block2);
                        continue;
                    }
                    if (n3 <= 1) continue;
                    this.beaconWireframeBlocks.add(block2);
                }
            }
        }
    }

    private Block getTopOfFlagBlock() {
        return this.flagLightBlock;
    }

    private int getMinimumHeightForBeacon() {
        return this.getTopOfFlagBlock().getY() + TownyWarConfig.getBeaconMinHeightAboveFlag();
    }

    private int getEdgeCount(int n, int n2, int n3, int n4) {
        return (this.zeroOr(n, n4) ? 1 : 0) + (this.zeroOr(n2, n4) ? 1 : 0) + (this.zeroOr(n3, n4) ? 1 : 0);
    }

    private boolean zeroOr(int n, int n2) {
        return n == 0 || n == n2;
    }

    private Block getBeaconMinBlock(World world) {
        int n = (int)Math.floor((double)Coord.getCellSize() / 2.0);
        int n2 = TownyWarConfig.getBeaconRadius() - 1;
        int n3 = n - n2;
        int n4 = this.getX() * Coord.getCellSize() + n3;
        int n5 = this.getZ() * Coord.getCellSize() + n3;
        int n6 = world.getMaxHeight();
        int n7 = this.getTopOfFlagBlock().getY() + TownyWarConfig.getBeaconMaxHeightAboveFlag();
        if (n7 > n6) {
            n7 = n6 - TownyWarConfig.getBeaconSize();
        }
        return world.getBlockAt(n4, n7, n5);
    }

    public Block getFlagBaseBlock() {
        return this.flagBaseBlock;
    }

    public String getNameOfFlagOwner() {
        return this.nameOfFlagOwner;
    }

    public boolean hasEnded() {
        return this.flagColorId >= TownyWarConfig.getWoolColors().length;
    }

    public void changeFlag() {
        ++this.flagColorId;
        this.updateFlag();
    }

    public void drawFlag() {
        this.loadBeacon();
        this.flagBaseBlock.setType(TownyWarConfig.getFlagBaseMaterial());
        this.updateFlag();
        this.flagLightBlock.setType(TownyWarConfig.getFlagLightMaterial());
        for (Block block : this.beaconWireframeBlocks) {
            block.setType(TownyWarConfig.getBeaconWireFrameMaterial());
        }
    }

    public void updateFlag() {
        DyeColor[] dyeColorArray = TownyWarConfig.getWoolColors();
        if (this.flagColorId < dyeColorArray.length) {
            System.out.println(String.format("Flag at %s turned %s.", this.getCellString(), dyeColorArray[this.flagColorId].toString()));
            int n = Material.WOOL.getId();
            byte by = dyeColorArray[this.flagColorId].getDyeData();
            this.flagBlock.setTypeIdAndData(n, by, true);
            for (Block block : this.beaconFlagBlocks) {
                block.setTypeIdAndData(n, by, true);
            }
        }
    }

    public void destroyFlag() {
        this.flagLightBlock.setType(Material.AIR);
        this.flagBlock.setType(Material.AIR);
        this.flagBaseBlock.setType(Material.AIR);
        for (Block block : this.beaconFlagBlocks) {
            block.setType(Material.AIR);
        }
        for (Block block : this.beaconWireframeBlocks) {
            block.setType(Material.AIR);
        }
    }

    public void begin() {
        this.drawFlag();
        this.thread = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new CellAttackThread(this), TownyWarConfig.getTimeBetweenFlagColorChange(), TownyWarConfig.getTimeBetweenFlagColorChange());
    }

    public void cancel() {
        if (this.thread != -1) {
            this.plugin.getServer().getScheduler().cancelTask(this.thread);
        }
        this.destroyFlag();
    }

    public String getCellString() {
        return String.format("%s (%d, %d)", this.getWorldName(), this.getX(), this.getZ());
    }

    public boolean isFlagLight(Block block) {
        return this.flagLightBlock.equals(block);
    }

    public boolean isFlag(Block block) {
        return this.flagBlock.equals(block);
    }

    public boolean isFlagBase(Block block) {
        return this.flagBaseBlock.equals(block);
    }

    public boolean isPartOfBeacon(Block block) {
        return this.beaconFlagBlocks.contains(block) || this.beaconWireframeBlocks.contains(block);
    }

    public boolean isUneditableBlock(Block block) {
        return this.isPartOfBeacon(block) || this.isFlagBase(block) || this.isFlagLight(block);
    }
}

