/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitScheduler;

public class BukkitTools {
    private static Towny plugin = null;
    private static Server server = null;

    public static void initialize(Towny towny) {
        plugin = towny;
        server = towny.getServer();
    }

    public static Player[] getOnlinePlayers() {
        return BukkitTools.getServer().getOnlinePlayers();
    }

    public static List<Player> matchPlayer(String string) {
        return BukkitTools.getServer().matchPlayer(string);
    }

    public static Player getPlayerExact(String string) {
        return BukkitTools.getServer().getPlayerExact(string);
    }

    public static Player getPlayer(String string) {
        return BukkitTools.getServer().getPlayer(string);
    }

    public static boolean isOnline(String string) {
        return BukkitTools.getServer().getPlayer(string) != null;
    }

    public static List<World> getWorlds() {
        return BukkitTools.getServer().getWorlds();
    }

    public static World getWorld(String string) {
        return BukkitTools.getServer().getWorld(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Server getServer() {
        Server server = BukkitTools.server;
        synchronized (server) {
            return BukkitTools.server;
        }
    }

    public static PluginManager getPluginManager() {
        return BukkitTools.getServer().getPluginManager();
    }

    public static BukkitScheduler getScheduler() {
        return BukkitTools.getServer().getScheduler();
    }

    public static int scheduleSyncDelayedTask(Runnable runnable, long l) {
        return BukkitTools.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, runnable, l);
    }

    public static int scheduleAsyncDelayedTask(Runnable runnable, long l) {
        return BukkitTools.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, runnable, l).getTaskId();
    }

    public static int scheduleSyncRepeatingTask(Runnable runnable, long l, long l2) {
        return BukkitTools.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, runnable, l, l2);
    }

    public static int scheduleAsyncRepeatingTask(Runnable runnable, long l, long l2) {
        return BukkitTools.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, runnable, l, l2).getTaskId();
    }

    public static HashMap<String, Integer> getPlayersPerWorld() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (World world : BukkitTools.getServer().getWorlds()) {
            hashMap.put(world.getName(), 0);
        }
        for (Player player : BukkitTools.getServer().getOnlinePlayers()) {
            hashMap.put(player.getWorld().getName(), hashMap.get(player.getWorld().getName()) + 1);
        }
        return hashMap;
    }

    public static Block getBlockOffset(Block block, int n, int n2, int n3) {
        return block.getWorld().getBlockAt(block.getX() + n, block.getY() + n2, block.getZ() + n3);
    }

    public static List<String> getWhiteListedUsers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("white-list.txt"));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    arrayList.add(string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return arrayList;
    }

    public static int calcChunk(int n) {
        return n * TownySettings.getTownBlockSize() / 16;
    }
}

