/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.bukkit.towny.TownySettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.naming.InvalidNameException;

public class NameValidation {
    private static Pattern namePattern = null;

    public static String checkAndFilterName(String string) throws InvalidNameException {
        String string2 = NameValidation.filterName(string);
        if (NameValidation.isBlacklistName(string2)) {
            throw new InvalidNameException(string2 + " is an invalid name.");
        }
        return string2;
    }

    public static String checkAndFilterPlayerName(String string) throws InvalidNameException {
        String string2 = NameValidation.filterName(string);
        if (!NameValidation.isValidName(string2)) {
            throw new InvalidNameException(string2 + " is an invalid name.");
        }
        return string2;
    }

    public static String[] checkAndFilterArray(String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n = 0;
        for (String string : stringArray) {
            stringArray2[n] = NameValidation.filterName(string);
            ++n;
        }
        return stringArray2;
    }

    public static boolean isBlacklistName(String string) {
        if (string.length() > TownySettings.getMaxNameLength()) {
            return true;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList("list", "new", "here", "help", "?", "leave", "withdraw", "deposit", "set", "toggle", "mayor", "assistant", "kick", "add", "claim", "unclaim", "title", "outpost", "ranklist"));
        if (arrayList.contains(string.toLowerCase())) {
            return true;
        }
        return !NameValidation.isValidName(string);
    }

    public static boolean isValidName(String string) {
        try {
            if (namePattern == null) {
                namePattern = Pattern.compile(TownySettings.getNameCheckRegex());
            }
            return namePattern.matcher(string).find();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            patternSyntaxException.printStackTrace();
            return false;
        }
    }

    public static String filterName(String string) {
        return string.replaceAll(TownySettings.getNameFilterRegex(), "_").replaceAll(TownySettings.getNameRemoveRegex(), "");
    }
}

