/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileMgmt {
    public static void checkFolders(String[] stringArray) {
        for (String string : stringArray) {
            File file = new File(string);
            if (file.exists() && file.isDirectory()) continue;
            file.getParentFile().mkdirs();
            file.mkdir();
        }
    }

    public static void checkFiles(String[] stringArray) throws IOException {
        for (String string : stringArray) {
            File file = new File(string);
            if (file.exists() && file.isFile()) continue;
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
    }

    public static String fileSeparator() {
        return System.getProperty("file.separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectory(File file, File file2) throws IOException {
        File file3 = file;
        synchronized (file3) {
            if (file.isDirectory()) {
                if (!file2.exists()) {
                    file2.mkdir();
                }
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    FileMgmt.copyDirectory(new File(file, stringArray[i]), new File(file2, stringArray[i]));
                }
            } else {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                try {
                    int n;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    byte[] byArray = new byte[1024];
                    while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                    }
                    ((InputStream)fileInputStream).close();
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    System.out.println("Error: Could not access: " + file);
                }
                ((OutputStream)fileOutputStream).close();
            }
        }
    }

    public static File CheckYMLExists(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File unpackResourceFile(String string, String string2, String string3) {
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        try {
            FileMgmt.checkFiles(new String[]{string});
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            String string4 = FileMgmt.convertStreamToString("/" + string2);
            FileMgmt.stringToFile(string4, string);
        }
        catch (IOException iOException) {
            try {
                String string5 = FileMgmt.convertStreamToString("/" + string3);
                FileMgmt.stringToFile(string5, string);
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(String string) throws IOException {
        if (string != null) {
            StringWriter stringWriter = new StringWriter();
            InputStream inputStream = FileMgmt.class.getResourceAsStream(string);
            char[] cArray = new char[1024];
            try {
                int n;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "US-ASCII"));
                while ((n = bufferedReader.read(cArray)) != -1) {
                    ((Writer)stringWriter).write(cArray, 0, n);
                }
            }
            catch (IOException iOException) {
                System.out.println("Exception ");
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (NullPointerException nullPointerException) {
                    throw new IOException();
                }
            }
            return ((Object)stringWriter).toString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertFileToString(File file) {
        if (file != null && file.exists() && file.canRead() && !file.isDirectory()) {
            StringWriter stringWriter = new StringWriter();
            FileInputStream fileInputStream = null;
            char[] cArray = new char[1024];
            try {
                int n;
                fileInputStream = new FileInputStream(file);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
                while ((n = bufferedReader.read(cArray)) != -1) {
                    ((Writer)stringWriter).write(cArray, 0, n);
                }
            }
            catch (IOException iOException) {
                System.out.println("Exception ");
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return ((Object)stringWriter).toString();
        }
        return "";
    }

    public static boolean stringToFile(String string, String string2) {
        if (string != null) {
            try {
                return FileMgmt.stringToFile(string, new File(string2));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public static boolean stringToFile(String string, File file) throws IOException {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            string.replaceAll("\n", System.getProperty("line.separator"));
            outputStreamWriter.write(string);
            outputStreamWriter.close();
            return true;
        }
        catch (IOException iOException) {
            System.out.println("Exception ");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveFile(File file, String string) throws IOException {
        File file2 = file;
        synchronized (file2) {
            if (file.isFile()) {
                boolean bl;
                File file3 = new File(file.getParent() + FileMgmt.fileSeparator() + string);
                if (file3.exists() && file3.isFile()) {
                    file3.delete();
                }
                if (!(bl = file.renameTo(new File(file.getParent() + FileMgmt.fileSeparator() + string, file.getName())))) {
                    // empty if block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDirectory(File file, File file2) throws IOException {
        File file3 = file;
        synchronized (file3) {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            FileMgmt.recursiveZipDirectory(file, zipOutputStream);
            zipOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDirectories(File[] fileArray, File file) throws IOException {
        File[] fileArray2 = fileArray;
        synchronized (fileArray) {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            for (File file2 : fileArray) {
                FileMgmt.recursiveZipDirectory(file2, zipOutputStream);
            }
            zipOutputStream.close();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveZipDirectory(File file, ZipOutputStream zipOutputStream) throws IOException {
        File file2 = file;
        synchronized (file2) {
            String[] stringArray = file.list();
            byte[] byArray = new byte[2156];
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                File file3 = new File(file, stringArray[i]);
                if (file3.isDirectory()) {
                    FileMgmt.recursiveZipDirectory(file3, zipOutputStream);
                    continue;
                }
                if (!file3.isFile() || !file3.canRead()) continue;
                FileInputStream fileInputStream = new FileInputStream(file3);
                ZipEntry zipEntry = new ZipEntry(file3.getPath());
                zipOutputStream.putNextEntry(zipEntry);
                while ((n = fileInputStream.read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                fileInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(File file) {
        File file2 = file;
        synchronized (file2) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    for (File file3 : fileArray) {
                        FileMgmt.deleteFile(file3);
                    }
                }
                if (!((fileArray = file.listFiles()) != null && fileArray.length != 0 || file.delete())) {
                    System.out.println("Error: Could not delete folder: " + file.getPath());
                }
            } else if (file.isFile() && !file.delete()) {
                System.out.println("Error: Could not delete file: " + file.getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteOldBackups(File file, long l) {
        File file2 = file;
        synchronized (file2) {
            File[] fileArray;
            TreeSet<Long> treeSet = new TreeSet<Long>();
            if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
                for (File file3 : fileArray) {
                    try {
                        long l2;
                        String[] stringArray;
                        String string;
                        long l3;
                        String string2 = file3.getName();
                        if (file3.isFile() && string2.contains(".")) {
                            string2 = string2.split("\\.")[0];
                        }
                        if ((l3 = Long.parseLong(string = (stringArray = string2.split(" "))[stringArray.length - 1])) < 0L || (l2 = System.currentTimeMillis() - l3) < l) continue;
                        FileMgmt.deleteFile(file3);
                        treeSet.add(l2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (treeSet.size() > 0) {
                System.out.println(String.format("[Towny] Deleting %d Old Backups (%s).", treeSet.size(), treeSet.size() > 1 ? String.format("%d-%d days old", TimeUnit.MILLISECONDS.toDays((Long)treeSet.first()), TimeUnit.MILLISECONDS.toDays((Long)treeSet.last())) : String.format("%d days old", TimeUnit.MILLISECONDS.toDays((Long)treeSet.first()))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void deleteUnusedFiles(File file, Set<String> set) {
        File file2 = file;
        synchronized (file2) {
            File[] fileArray;
            int n = 0;
            if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
                for (File file3 : fileArray) {
                    try {
                        String string = file3.getName();
                        if (!file3.isFile()) continue;
                        if (string.contains(".txt")) {
                            string = string.split("\\.txt")[0];
                        }
                        if (set.contains(string.toLowerCase())) continue;
                        FileMgmt.deleteFile(file3);
                        ++n;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n > 0) {
                    System.out.println(String.format("[Towny] Deleted %d old files.", n));
                }
            }
        }
    }
}

