/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class KeyValueFile {
    private static final String newLine = System.getProperty("line.separator");
    private Map<String, String> keys = new HashMap<String, String>();
    private String fileName;

    public KeyValueFile(String string) {
        this.fileName = string;
        File file = new File(string);
        if (file.exists()) {
            this.load();
        } else {
            this.save();
        }
    }

    public void load() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.fileName));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    String string2;
                    String[] stringArray = string.split("#");
                    if (stringArray.length <= 0 || (stringArray = (string2 = stringArray[0]).split("=")).length < 2) continue;
                    this.keys.put(stringArray[0], stringArray[1]);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void save() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(this.keys);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.fileName));
            try {
                for (String string : treeMap.keySet()) {
                    bufferedWriter.write(string.toLowerCase() + "=" + (String)treeMap.get(string) + newLine);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setMap(Map<String, String> map) {
        this.keys = map;
        this.save();
    }

    public String get(String string) {
        return this.keys.get(string);
    }

    public Map<String, String> returnMap() throws Exception {
        return new HashMap<String, String>(this.keys);
    }

    public boolean containsKey(String string) {
        return this.keys.containsKey(string);
    }

    public String getProperty(String string) {
        return this.keys.get(string);
    }

    public void removeKey(String string) {
        if (this.keys.containsKey(string)) {
            this.keys.remove(string);
            this.save();
        }
    }

    public boolean keyExists(String string) {
        return this.containsKey(string);
    }

    public String getString(String string) {
        if (this.containsKey(string)) {
            return this.getProperty(string);
        }
        return "";
    }

    public String getString(String string, String string2) {
        if (this.containsKey(string)) {
            return this.getProperty(string);
        }
        this.setString(string, string2);
        return string2;
    }

    public void setString(String string, String string2) {
        this.keys.put(string, string2);
        this.save();
    }

    public int getInt(String string) {
        if (this.containsKey(string)) {
            return Integer.parseInt(this.getProperty(string));
        }
        return 0;
    }

    public int getInt(String string, int n) {
        if (this.containsKey(string)) {
            return Integer.parseInt(this.getProperty(string));
        }
        this.setInt(string, n);
        return n;
    }

    public void setInt(String string, int n) {
        this.keys.put(string, String.valueOf(n));
        this.save();
    }

    public double getDouble(String string) {
        if (this.containsKey(string)) {
            return Double.parseDouble(this.getProperty(string));
        }
        return 0.0;
    }

    public double getDouble(String string, double d) {
        if (this.containsKey(string)) {
            return Double.parseDouble(this.getProperty(string));
        }
        this.setDouble(string, d);
        return d;
    }

    public void setDouble(String string, double d) {
        this.keys.put(string, String.valueOf(d));
        this.save();
    }

    public long getLong(String string) {
        if (this.containsKey(string)) {
            return Long.parseLong(this.getProperty(string));
        }
        return 0L;
    }

    public long getLong(String string, long l) {
        if (this.containsKey(string)) {
            return Long.parseLong(this.getProperty(string));
        }
        this.setLong(string, l);
        return l;
    }

    public void setLong(String string, long l) {
        this.keys.put(string, String.valueOf(l));
        this.save();
    }

    public boolean getBoolean(String string) {
        if (this.containsKey(string)) {
            return Boolean.parseBoolean(this.getProperty(string));
        }
        return false;
    }

    public boolean getBoolean(String string, boolean bl) {
        if (this.containsKey(string)) {
            return Boolean.parseBoolean(this.getProperty(string));
        }
        this.setBoolean(string, bl);
        return bl;
    }

    public void setBoolean(String string, boolean bl) {
        this.keys.put(string, String.valueOf(bl));
        this.save();
    }
}

