/*
 * Decompiled with CFR 0.152.
 */
package me.chaseoes.firstjoinplus;

import java.util.ArrayList;
import me.chaseoes.firstjoinplus.FirstJoinEvent;
import me.chaseoes.firstjoinplus.utilities.Utilities;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class FirstJoinListener
implements Listener {
    private final JavaPlugin plugin;

    public FirstJoinListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onFirstJoin(final FirstJoinEvent event) {
        Integer invincible;
        final Player player = event.getPlayer();
        if (this.plugin.getConfig().getBoolean("on-first-join.show-first-join-message")) {
            event.setFirstJoinMessage(Utilities.getUtilities().formatVariables(this.plugin.getConfig().getString("settings.first-join-message"), player));
        }
        if (this.plugin.getConfig().getBoolean("on-first-join.give-items.enabled")) {
            Utilities.getUtilities().giveFirstJoinItems(player);
        }
        if (this.plugin.getConfig().getBoolean("on-first-join.send-motd.enabled")) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    for (String motdStr : FirstJoinListener.this.plugin.getConfig().getStringList("on-first-join.send-motd.messages")) {
                        player.sendMessage(Utilities.getUtilities().formatVariables(motdStr, player));
                    }
                }
            }, this.plugin.getConfig().getLong("on-first'join.send-motd.delay"));
        }
        if (this.plugin.getConfig().getBoolean("on-first-join.teleport")) {
            final Location loc = event.getLocation();
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    player.teleport(loc);
                    if (FirstJoinListener.this.plugin.getConfig().getBoolean("on-first-join.show-smoke")) {
                        Utilities.getUtilities().playSmoke(loc);
                    }
                    if (FirstJoinListener.this.plugin.getConfig().getBoolean("on-first-join.launch-firework")) {
                        Utilities.getUtilities().playFirework(event.getLocation());
                    }
                }
            }, this.plugin.getConfig().getLong("settings.teleport-delay"));
        }
        if (!this.plugin.getConfig().getBoolean("on-first-join.teleport")) {
            Utilities.getUtilities().playSmoke(event.getLocation());
        }
        if (this.plugin.getConfig().getBoolean("on-first-join.launch-firework") && !this.plugin.getConfig().getBoolean("on-first-join.teleport")) {
            Utilities.getUtilities().playFirework(event.getLocation());
        }
        if (this.plugin.getConfig().getBoolean("on-first-join.play-notify-sound")) {
            Player[] playerArray = this.plugin.getServer().getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                if (p.hasPermission("firstjoinplus.notify")) {
                    Sound s = Sound.valueOf((String)this.plugin.getConfig().getString("settings.notify-sound"));
                    p.playSound(p.getLocation(), s, 1.0f, 1.0f);
                }
                ++n2;
            }
        }
        if (this.plugin.getConfig().getInt("on-first-join.give-xp") != 0) {
            player.setLevel(this.plugin.getConfig().getInt("on-first-join.give-xp"));
        }
        if (this.plugin.getConfig().getBoolean("on-first-join.run-commands.enabled")) {
            for (String command : this.plugin.getConfig().getStringList("on-first-join.run-commands.commands-to-run")) {
                String cmnd = Utilities.getUtilities().formatVariables(command, player);
                player.performCommand(cmnd);
            }
        }
        if (this.plugin.getConfig().getBoolean("on-first-join.run-console-commands.enabled")) {
            for (String command : this.plugin.getConfig().getStringList("on-first-join.run-console-commands.commands-to-run")) {
                String cmnd = Utilities.getUtilities().formatVariables(command, player);
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), cmnd);
            }
        }
        if ((invincible = Integer.valueOf(this.plugin.getConfig().getInt("on-first-join.set-invincible"))) != 0) {
            Utilities.getUtilities().invincible.add(player.getName());
            final Player p = player;
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Utilities.getUtilities().invincible.remove(p.getName());
                }
            }, (long)invincible.intValue() * 20L);
        }
        if (this.plugin.getConfig().getBoolean("on-first-join.give-written-books.enabled")) {
            Utilities.getUtilities().giveWrittenBooks(player);
        }
        if (this.plugin.getConfig().getBoolean("on-first-join.apply-potion-effects.enabled")) {
            ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
            for (String s : this.plugin.getConfig().getStringList("on-first-join.apply-potion-effects.effects")) {
                String[] effect = s.split("\\:");
                effects.add(new PotionEffect(PotionEffectType.getByName((String)effect[0].toUpperCase()), Integer.parseInt(effect[2]) * 20, Integer.parseInt(effect[1]) - 1));
            }
            player.addPotionEffects(effects);
        }
    }
}

