/*
 * Decompiled with CFR 0.152.
 */
package me.chaseoes.firstjoinplus;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import me.chaseoes.firstjoinplus.FirstJoinListener;
import me.chaseoes.firstjoinplus.PlayerListeners;
import me.chaseoes.firstjoinplus.metrics.MetricsLite;
import me.chaseoes.firstjoinplus.utilities.UpdateChecker;
import me.chaseoes.firstjoinplus.utilities.Utilities;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import uk.org.whoami.geoip.GeoIPLookup;
import uk.org.whoami.geoip.GeoIPTools;

public class FirstJoinPlus
extends JavaPlugin {
    private static FirstJoinPlus instance;
    public UpdateChecker update;
    String smile = "Girls with the prettiest smiles, have the saddest stories.";

    public static FirstJoinPlus getInstance() {
        return instance;
    }

    public void onEnable() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new PlayerListeners(), (Plugin)this);
        pm.registerEvents((Listener)new FirstJoinListener(this), (Plugin)this);
        Utilities.getUtilities().setup(this);
        instance = this;
        this.update = new UpdateChecker();
        this.update.startTask();
        if (this.getConfig().getBoolean("on-first-join.give-written-books.enabled")) {
            this.saveResource("rules.txt", false);
        }
        if (this.getConfig().getString("settings.worldname") != null) {
            String[] sections;
            File configuration = new File(this.getDataFolder() + "/config.yml");
            configuration.setWritable(true);
            configuration.renameTo(new File(this.getDataFolder() + "/old-config.yml"));
            String[] stringArray = sections = this.getConfig().getConfigurationSection("").getKeys(false).toArray(new String[0]);
            int n = sections.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.getConfig().set(s, null);
                ++n2;
            }
            this.saveConfig();
            this.getLogger().log(Level.SEVERE, "Your configuration was found to be outdated, so we generated a new one for you.");
        }
        this.getConfig().options().header("FirstJoinPlus " + this.getDescription().getVersion() + " Configuration -- Please see: https://github.com/chaseoes/FirstJoinPlus/wiki/Configuration #");
        this.getConfig().options().copyDefaults(true);
        this.getConfig().options().copyHeader(true);
        this.saveConfig();
        try {
            MetricsLite metrics = new MetricsLite((Plugin)this);
            metrics.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.reloadConfig();
        this.saveConfig();
    }

    public boolean onCommand(CommandSender cs, Command cmnd, String string, String[] strings) {
        String prefix = ChatColor.DARK_GREEN + "[FirstJoinPlus] ";
        String noPermission = String.valueOf(prefix) + ChatColor.DARK_RED + "You don't have permission.";
        if (strings.length == 0) {
            cs.sendMessage(ChatColor.GOLD + "FirstJoinPlus " + ChatColor.GRAY + "version " + ChatColor.GOLD + this.getDescription().getVersion() + ChatColor.GRAY + " by chaseoes.");
            return true;
        }
        if (strings.length != 1) {
            cs.sendMessage(String.valueOf(prefix) + ChatColor.DARK_RED + "Usage: /firstjoinplus <reload|setspawn|spawn|items|motd>");
            return true;
        }
        if (strings[0].equalsIgnoreCase("reload")) {
            if (cs.hasPermission("firstjoinplus.reload")) {
                this.reloadConfig();
                this.saveConfig();
                if (this.getConfig().getBoolean("on-first-join.give-written-books.enabled")) {
                    this.saveResource("rules.txt", false);
                }
                cs.sendMessage(String.valueOf(prefix) + ChatColor.GREEN + "Successfully reloaded the configuration.");
            } else {
                cs.sendMessage(noPermission);
            }
            return true;
        }
        if (!(cs instanceof Player)) {
            cs.sendMessage("You must be a player to do that.");
            return true;
        }
        Player player = (Player)cs;
        if (strings[0].equalsIgnoreCase("motd")) {
            if (cs.hasPermission("firstjoinplus.motd")) {
                for (String motdStr : this.getConfig().getStringList("on-first-join.send-motd.messages")) {
                    cs.sendMessage(Utilities.getUtilities().formatVariables(motdStr, player));
                }
            } else {
                cs.sendMessage(noPermission);
            }
        }
        if (strings[0].equalsIgnoreCase("setspawn")) {
            if (cs.hasPermission("firstjoinplus.setspawn")) {
                this.getConfig().set("on-first-join.teleport", (Object)true);
                this.getConfig().set("spawn.x", (Object)player.getLocation().getBlockX());
                this.getConfig().set("spawn.y", (Object)player.getLocation().getBlockY());
                this.getConfig().set("spawn.z", (Object)player.getLocation().getBlockZ());
                this.getConfig().set("spawn.pitch", (Object)Float.valueOf(player.getLocation().getPitch()));
                this.getConfig().set("spawn.yaw", (Object)Float.valueOf(player.getLocation().getYaw()));
                this.getConfig().set("spawn.world", (Object)player.getLocation().getWorld().getName());
                this.saveConfig();
                this.reloadConfig();
                cs.sendMessage(String.valueOf(prefix) + ChatColor.GREEN + "Successfully set the first join spawn location.");
            } else {
                cs.sendMessage(noPermission);
            }
        }
        if (strings[0].equalsIgnoreCase("items")) {
            if (cs.hasPermission("firstjoinplus.items")) {
                Utilities.getUtilities().giveFirstJoinItems(player);
                if (this.getConfig().getBoolean("on-first-join.give-written-books.enabled")) {
                    Utilities.getUtilities().giveWrittenBooks(player);
                }
                cs.sendMessage(String.valueOf(prefix) + ChatColor.GREEN + "Successfully gave all defined items.");
            } else {
                cs.sendMessage(noPermission);
            }
        }
        if (strings[0].equalsIgnoreCase("spawn")) {
            if (cs.hasPermission("firstjoinplus.spawn")) {
                if (!this.getConfig().getBoolean("on-first-join.teleport")) {
                    cs.sendMessage(String.valueOf(prefix) + ChatColor.DARK_RED + "A first join spawn location hasn't been set.");
                    return true;
                }
                player.teleport(Utilities.getUtilities().getFirstJoinLocation());
                cs.sendMessage(String.valueOf(prefix) + ChatColor.GREEN + "Successfully teleported to the first join spawn location.");
            } else {
                cs.sendMessage(noPermission);
            }
        }
        return true;
    }

    public GeoIPLookup getGeoIPLookup() {
        Plugin pl = this.getServer().getPluginManager().getPlugin("GeoIPTools");
        if (pl != null) {
            return ((GeoIPTools)pl).getGeoIPLookup();
        }
        return null;
    }
}

