/*
 * Decompiled with CFR 0.152.
 */
package me.chaseoes.firstjoinplus.utilities;

import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.logging.Level;
import me.chaseoes.firstjoinplus.FirstJoinPlus;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private String latestVersion = this.getCurrentVersion();

    public String getCurrentVersion() {
        return FirstJoinPlus.getInstance().getDescription().getVersion();
    }

    public boolean needsUpdate() {
        return !this.latestVersion.equalsIgnoreCase(this.getCurrentVersion());
    }

    public void nagPlayer(Player player) {
        player.sendMessage(ChatColor.DARK_GREEN + "[FirstJoinPlus]" + ChatColor.DARK_RED + " Version " + this.latestVersion + " is available! Please update ASAP.");
        player.sendMessage(ChatColor.RED + "http://dev.bukkit.org/server-mods/firstjoinplus/");
    }

    public void startTask() {
        FirstJoinPlus.getInstance().getServer().getScheduler().runTaskTimerAsynchronously((Plugin)FirstJoinPlus.getInstance(), new Runnable(){

            @Override
            public void run() {
                UpdateChecker.this.checkForUpdate();
            }
        }, 0L, 12000L);
    }

    public void checkForUpdate() {
        if (FirstJoinPlus.getInstance().getConfig().getBoolean("settings.update-checking")) {
            try {
                String channel = "https://raw.github.com/chaseoes/FirstJoinPlus/master/version";
                URL url = new URL(channel);
                InputStream i = url.openStream();
                Scanner scan = new Scanner(i);
                String ver = scan.nextLine();
                i.close();
                this.latestVersion = ver.equalsIgnoreCase("0.0") ? this.getCurrentVersion() : ver;
                return;
            }
            catch (Exception e) {
                FirstJoinPlus.getInstance().getLogger().log(Level.WARNING, "An error was encountered while attempting to check for updates.");
            }
        }
        this.latestVersion = this.getCurrentVersion();
    }
}

