/*
 * Decompiled with CFR 0.152.
 */
package me.chaseoes.firstjoinplus.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.logging.Level;
import me.chaseoes.firstjoinplus.FirstJoinPlus;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class Utilities {
    private FirstJoinPlus plugin;
    static Utilities instance = new Utilities();
    public HashSet<String> invincible = new HashSet();

    private Utilities() {
    }

    public static Utilities getUtilities() {
        return instance;
    }

    public void setup(FirstJoinPlus p) {
        this.plugin = p;
    }

    public String colorize(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public int getUniquePlayerCount() {
        return new File(String.valueOf(((World)this.plugin.getServer().getWorlds().get(0)).getName()) + "/players/").list().length;
    }

    public Location getFirstJoinLocation() {
        int x = this.plugin.getConfig().getInt("spawn.x");
        int y = this.plugin.getConfig().getInt("spawn.y");
        int z = this.plugin.getConfig().getInt("spawn.z");
        float pitch = this.plugin.getConfig().getInt("spawn.pitch");
        float yaw = this.plugin.getConfig().getInt("spawn.yaw");
        return new Location(this.plugin.getServer().getWorld(this.plugin.getConfig().getString("spawn.world")), (double)x + 0.5, (double)y, (double)z + 0.5, yaw, pitch);
    }

    public void giveFirstJoinItems(Player player) {
        for (String itemStr : this.plugin.getConfig().getStringList("on-first-join.give-items.items")) {
            String[] itemValues = itemStr.split("\\:");
            ItemStack i = this.isNumber(itemValues[0]) ? new ItemStack(Material.getMaterial((int)Integer.parseInt(itemValues[0]))) : new ItemStack(Material.getMaterial((String)itemValues[0].toUpperCase()));
            if (itemValues.length > 1) {
                i.setAmount(Integer.parseInt(itemValues[1]));
            }
            if (itemValues.length > 2) {
                i = new ItemStack(i.getType(), i.getAmount(), (short)Integer.parseInt(itemValues[2]));
            }
            player.getInventory().addItem(new ItemStack[]{i});
        }
    }

    public void giveWrittenBooks(Player player) {
        for (String file : this.plugin.getConfig().getStringList("on-first-join.give-written-books.book-files")) {
            ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
            BookMeta bm = (BookMeta)book.getItemMeta();
            File f = new File(this.plugin.getDataFolder() + "/" + file);
            try {
                BufferedReader br = new BufferedReader(new FileReader(f));
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                int i = 0;
                while (line != null) {
                    if (++i != 1 && i != 2) {
                        if (line.equalsIgnoreCase("/newpage") || line.equalsIgnoreCase("/np")) {
                            bm.addPage(new String[]{sb.toString()});
                            sb = new StringBuilder();
                        } else {
                            sb.append(Utilities.getUtilities().colorize(line));
                            sb.append("\n");
                        }
                    } else {
                        if (i == 1) {
                            bm.setTitle(Utilities.getUtilities().colorize(line));
                        }
                        if (i == 2) {
                            bm.setAuthor(Utilities.getUtilities().colorize(line));
                        }
                    }
                    line = br.readLine();
                }
                br.close();
                bm.addPage(new String[]{sb.toString()});
            }
            catch (Exception e) {
                e.printStackTrace();
                this.plugin.getLogger().log(Level.WARNING, "Error encountered while trying to give a new player a written book! (File " + file + ")");
                this.plugin.getLogger().log(Level.WARNING, "Please check that the file exists and is readable.");
            }
            book.setItemMeta((ItemMeta)bm);
            player.getInventory().addItem(new ItemStack[]{book});
        }
    }

    public void playSmoke(Location loc) {
        int i = 0;
        while (i <= 25) {
            loc.getWorld().playEffect(loc, Effect.SMOKE, i);
            ++i;
        }
    }

    public void playFirework(Location loc) {
        Firework fw = (Firework)loc.getWorld().spawnEntity(loc, EntityType.FIREWORK);
        FireworkMeta fm = fw.getFireworkMeta();
        FireworkEffect effect = FireworkEffect.builder().trail(true).flicker(false).withColor(Color.PURPLE).withFade(Color.PURPLE).with(FireworkEffect.Type.BALL_LARGE).build();
        fm.addEffect(effect);
        fm.setPower(2);
        fw.setFireworkMeta(fm);
    }

    public String formatVariables(String string, Player player) {
        return this.colorize(string.replace("%player-name", player.getName()).replace("%player-display-name", player.getDisplayName()).replace("%unique-players", String.valueOf(this.getUniquePlayerCount())).replace("%country", this.getCountry(player)).replace("%city", this.getCity(player)).replace("%new-line", "%new-line"));
    }

    public String formatVariables(String string, Player player, String reason) {
        return this.colorize(string.replace("%player-name", player.getName()).replace("%player-display-name", player.getDisplayName()).replace("%unique-players", String.valueOf(this.getUniquePlayerCount())).replace("%reason", reason).replace("%country", this.getCountry(player)).replace("%city", this.getCity(player)).replace("%new-line", "%new-line"));
    }

    public boolean isNumber(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String getCountry(Player player) {
        if (this.plugin.getGeoIPLookup() != null) {
            if (this.plugin.getGeoIPLookup().getLocation(player.getAddress().getAddress()) != null) {
                return this.plugin.getGeoIPLookup().getLocation((InetAddress)player.getAddress().getAddress()).countryName;
            }
            return "unknown";
        }
        return "N/A";
    }

    public String getCity(Player player) {
        if (this.plugin.getGeoIPLookup() != null) {
            if (this.plugin.getGeoIPLookup().getLocation(player.getAddress().getAddress()) != null) {
                return this.plugin.getGeoIPLookup().getLocation((InetAddress)player.getAddress().getAddress()).city;
            }
            return "unknown";
        }
        return "N/A";
    }
}

