/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv;

import com.lishid.openinv.OpenInvEntityListener;
import com.lishid.openinv.OpenInvInventoryListener;
import com.lishid.openinv.OpenInvPlayerListener;
import com.lishid.openinv.commands.AnyChestPluginCommand;
import com.lishid.openinv.commands.OpenEnderPluginCommand;
import com.lishid.openinv.commands.OpenInvPluginCommand;
import com.lishid.openinv.commands.SearchInvPluginCommand;
import com.lishid.openinv.commands.SilentChestPluginCommand;
import com.lishid.openinv.commands.ToggleOpenInvPluginCommand;
import com.lishid.openinv.internal.IAnySilentChest;
import com.lishid.openinv.internal.IInventoryAccess;
import com.lishid.openinv.internal.IPlayerDataManager;
import com.lishid.openinv.internal.ISpecialEnderChest;
import com.lishid.openinv.internal.ISpecialPlayerInventory;
import com.lishid.openinv.internal.InternalAccessor;
import com.lishid.openinv.utils.Metrics;
import com.lishid.openinv.utils.UpdateManager;
import java.util.HashMap;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class OpenInv
extends JavaPlugin {
    public static final Logger logger = Logger.getLogger("Minecraft.OpenInv");
    public static HashMap<String, ISpecialPlayerInventory> inventories = new HashMap();
    public static HashMap<String, ISpecialEnderChest> enderChests = new HashMap();
    private static Metrics metrics;
    private UpdateManager updater = new UpdateManager();
    public static OpenInv mainPlugin;
    public static IPlayerDataManager playerLoader;
    public static IInventoryAccess inventoryAccess;
    public static IAnySilentChest anySilentChest;

    public void onEnable() {
        PluginManager pm = this.getServer().getPluginManager();
        boolean success = InternalAccessor.Initialize(this.getServer());
        if (!success) {
            OpenInv.log("Your version of CraftBukkit is not supported.");
            OpenInv.log("Please look for an updated version of OpenInv.");
            pm.disablePlugin((Plugin)this);
            return;
        }
        playerLoader = InternalAccessor.Instance.newPlayerDataManager();
        inventoryAccess = InternalAccessor.Instance.newInventoryAccess();
        anySilentChest = InternalAccessor.Instance.newAnySilentChest();
        mainPlugin = this;
        mainPlugin.getConfig().addDefault("ItemOpenInvItemID", (Object)280);
        mainPlugin.getConfig().addDefault("CheckForUpdates", (Object)true);
        mainPlugin.getConfig().options().copyDefaults(true);
        mainPlugin.saveConfig();
        pm.registerEvents((Listener)new OpenInvPlayerListener(), (Plugin)this);
        pm.registerEvents((Listener)new OpenInvEntityListener(), (Plugin)this);
        pm.registerEvents((Listener)new OpenInvInventoryListener(), (Plugin)this);
        this.getCommand("openinv").setExecutor((CommandExecutor)new OpenInvPluginCommand(this));
        this.getCommand("searchinv").setExecutor((CommandExecutor)new SearchInvPluginCommand());
        this.getCommand("toggleopeninv").setExecutor((CommandExecutor)new ToggleOpenInvPluginCommand());
        this.getCommand("silentchest").setExecutor((CommandExecutor)new SilentChestPluginCommand(this));
        this.getCommand("anychest").setExecutor((CommandExecutor)new AnyChestPluginCommand(this));
        this.getCommand("openender").setExecutor((CommandExecutor)new OpenEnderPluginCommand(this));
        this.updater.Initialize(this, this.getFile());
        try {
            metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (Exception e) {
            OpenInv.log(e);
        }
    }

    public static boolean GetCheckForUpdates() {
        return mainPlugin.getConfig().getBoolean("CheckForUpdates", true);
    }

    public static boolean GetPlayerItemOpenInvStatus(String name) {
        return mainPlugin.getConfig().getBoolean("ItemOpenInv." + name.toLowerCase() + ".toggle", false);
    }

    public static void SetPlayerItemOpenInvStatus(String name, boolean status) {
        mainPlugin.getConfig().set("ItemOpenInv." + name.toLowerCase() + ".toggle", (Object)status);
        mainPlugin.saveConfig();
    }

    public static boolean GetPlayerSilentChestStatus(String name) {
        return mainPlugin.getConfig().getBoolean("SilentChest." + name.toLowerCase() + ".toggle", false);
    }

    public static void SetPlayerSilentChestStatus(String name, boolean status) {
        mainPlugin.getConfig().set("SilentChest." + name.toLowerCase() + ".toggle", (Object)status);
        mainPlugin.saveConfig();
    }

    public static boolean GetPlayerAnyChestStatus(String name) {
        return mainPlugin.getConfig().getBoolean("AnyChest." + name.toLowerCase() + ".toggle", true);
    }

    public static void SetPlayerAnyChestStatus(String name, boolean status) {
        mainPlugin.getConfig().set("AnyChest." + name.toLowerCase() + ".toggle", (Object)status);
        mainPlugin.saveConfig();
    }

    public static int GetItemOpenInvItem() {
        if (mainPlugin.getConfig().get("ItemOpenInvItemID") == null) {
            OpenInv.SaveToConfig("ItemOpenInvItemID", 280);
        }
        return mainPlugin.getConfig().getInt("ItemOpenInvItemID", 280);
    }

    public static Object GetFromConfig(String data, Object defaultValue) {
        Object val = mainPlugin.getConfig().get(data);
        if (val == null) {
            mainPlugin.getConfig().set(data, defaultValue);
            return defaultValue;
        }
        return val;
    }

    public static void SaveToConfig(String data, Object value) {
        mainPlugin.getConfig().set(data, value);
        mainPlugin.saveConfig();
    }

    public static void log(String text) {
        logger.info("[OpenInv] " + text);
    }

    public static void log(Throwable e) {
        logger.severe("[OpenInv] " + e.toString());
        e.printStackTrace();
    }

    public static void ShowHelp(Player player) {
        player.sendMessage(ChatColor.GREEN + "/openinv <Player> - Open a player's inventory");
        player.sendMessage(ChatColor.GREEN + "   (aliases: oi, inv, open)");
        player.sendMessage(ChatColor.GREEN + "/openender <Player> - Open a player's enderchest");
        player.sendMessage(ChatColor.GREEN + "   (aliases: oe, enderchest)");
        player.sendMessage(ChatColor.GREEN + "/toggleopeninv - Toggle item openinv function");
        player.sendMessage(ChatColor.GREEN + "   (aliases: toi, toggleoi, toggleinv)");
        player.sendMessage(ChatColor.GREEN + "/searchinv <Item> [MinAmount] - ");
        player.sendMessage(ChatColor.GREEN + "   Search and list players having a specific item.");
        player.sendMessage(ChatColor.GREEN + "   (aliases: si, search)");
        player.sendMessage(ChatColor.GREEN + "/anychest - Toggle anychest function");
        player.sendMessage(ChatColor.GREEN + "   (aliases: ac)");
        player.sendMessage(ChatColor.GREEN + "/silentchest - Toggle silent chest function");
        player.sendMessage(ChatColor.GREEN + "   (aliases: sc, silent)");
    }
}

